/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import net.opengis.wcs10.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.util.factory.Hints;
import org.vfny.geoserver.wcs.WcsException;

public class Wcs10GetCoverageResponse
extends Response {
    private static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final Hints hints = new Hints(new HashMap(5));
    Catalog catalog;
    private CoverageResponseDelegateFinder responseFactory;

    public Wcs10GetCoverageResponse(Catalog catalog, CoverageResponseDelegateFinder responseFactory) {
        super(GridCoverage[].class);
        this.catalog = catalog;
        this.responseFactory = responseFactory;
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            throw new WcsException("Cannot handle object of type: " + String.valueOf(operation.getParameters()[0].getClass()));
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = getCoverage.getOutput().getFormat().getValue();
        CoverageResponseDelegate delegate = this.getResponseDelegate(outputFormat);
        return getCoverage.getSourceCoverage() + "." + delegate.getFileExtension(outputFormat);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            throw new WcsException("Cannot handle object of type: " + String.valueOf(operation.getParameters()[0].getClass()));
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = getCoverage.getOutput().getFormat().getValue();
        CoverageResponseDelegate delegate = this.getResponseDelegate(outputFormat);
        return delegate.getMimeType(outputFormat);
    }

    private CoverageResponseDelegate getResponseDelegate(String outputFormat) {
        CoverageResponseDelegate delegate = this.responseFactory.encoderFor(outputFormat);
        if (delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        return delegate;
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = getCoverage.getOutput().getFormat().getValue();
        CoverageResponseDelegate delegate = this.getResponseDelegate(outputFormat);
        return delegate.canProduce(outputFormat);
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat().getValue();
        CoverageResponseDelegate delegate = this.getResponseDelegate(outputFormat);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        delegate.encode(coverage, outputFormat, Collections.emptyMap(), output);
        output.flush();
    }

    static {
        hints.add((RenderingHints)LENIENT_HINT);
    }
}

