/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.util.Converters;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xs.bindings.XSQNameBinding;
import org.geotools.xsd.ComplexEMFBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QueryTypeBinding
extends ComplexEMFBinding {
    NamespaceContext namespaceContext;

    public QueryTypeBinding(NamespaceContext namespaceContext) {
        super((EFactory)Wfs20Factory.eINSTANCE, WFS.QueryType);
        this.namespaceContext = namespaceContext;
    }

    protected void setProperty(EObject eObject, String property, Object value, boolean lax) {
        super.setProperty(eObject, property, value, lax);
        if (!lax && "typeNames".equalsIgnoreCase(property)) {
            QueryType q = (QueryType)eObject;
            ArrayList<QName> qNames = new ArrayList<QName>();
            for (Object s : q.getTypeNames()) {
                try {
                    QName parsed = (QName)new XSQNameBinding(this.namespaceContext).parse(null, s);
                    qNames.add(parsed);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            q.getTypeNames().clear();
            q.getTypeNames().addAll(qNames);
        }
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("aliases".equalsIgnoreCase(name.getLocalPart())) {
            EList aliases = ((QueryType)object).getAliases();
            if (aliases.isEmpty()) {
                return null;
            }
            StringBuffer ret = new StringBuffer();
            for (Object o : aliases) {
                String alias = (String)o;
                if (ret.length() > 0) {
                    ret.append(",");
                }
                ret.append(alias);
            }
            return ret.toString();
        }
        if ("typeNames".equalsIgnoreCase(name.getLocalPart())) {
            StringBuilder s = new StringBuilder();
            for (Object typeName : ((QueryType)object).getTypeNames()) {
                if (typeName instanceof Collection) {
                    Collection collection = (Collection)typeName;
                    typeName = collection.iterator().next();
                }
                s.append((String)Converters.convert(typeName, String.class));
                s.append(",");
            }
            s.setLength(s.length() - 1);
            return s.toString();
        }
        if ("AbstractProjectionClause".equalsIgnoreCase(name.getLocalPart())) {
            return null;
        }
        return super.getProperty(object, name);
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        Element e = super.encode(object, document, value);
        QueryType resultType = (QueryType)object;
        Iterator it = resultType.getAbstractProjectionClause().iterator();
        while (it.hasNext()) {
            Element node = document.createElementNS("http://www.opengis.net/wfs/2.0", "PropertyName");
            node.setTextContent((String)Converters.convert(it.next(), String.class));
            e.appendChild(node);
        }
        return e;
    }
}

