/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.affine;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderableOp;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.affine.AffinePropertyGenerator;
import org.eclipse.imagen.media.affine.JaiI18N;
import org.eclipse.imagen.media.range.Range;

public class AffineDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(AffineDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Affine"}, {"LocalName", "Affine"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", JaiI18N.getString("AffineDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AffineDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("AffineDescriptor1")}, {"arg1Desc", JaiI18N.getString("AffineDescriptor2")}, {"arg2Desc", JaiI18N.getString("AffineDescriptor3")}, {"arg3Desc", JaiI18N.getString("AffineDescriptor4")}, {"arg4Desc", JaiI18N.getString("AffineDescriptor5")}, {"arg5Desc", JaiI18N.getString("AffineDescriptor6")}, {"arg6Desc", JaiI18N.getString("AffineDescriptor7")}};
    private static final Class[] paramClasses = new Class[]{AffineTransform.class, Interpolation.class, double[].class, ROI.class, Boolean.class, Boolean.class, Range.class};
    private static final String[] paramNames = new String[]{"transform", "interpolation", "backgroundValues", "roi", "useROIAccessor", "setDestinationNoData", "nodata"};
    private static final Object[] paramDefaults = new Object[]{new AffineTransform(), Interpolation.getInstance((int)0), null, null, false, false, null};

    public AffineDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new AffinePropertyGenerator()};
        return pg;
    }

    protected boolean validateParameters(ParameterBlock args, StringBuffer message) {
        if (!super.validateParameters(args, message)) {
            return false;
        }
        AffineTransform transform = (AffineTransform)args.getObjectParameter(0);
        try {
            AffineTransform affineTransform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            message.append(this.getName() + " " + JaiI18N.getString("AffineDescriptor7"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, ROI roi) {
        return AffineDescriptor.create(source0, transform, interpolation, backgroundValues, roi, false, false, null, null);
    }

    public static RenderedOp create(RenderedImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, ROI roi, boolean useROIAccessor, boolean setDestinationNoData, Range nodata, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Affine", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("transform", (Object)transform);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        pb.setParameter("setDestinationNoData", setDestinationNoData);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("roi", (Object)roi);
            pb.setParameter("useROIAccessor", useROIAccessor);
        }
        return ImageN.create((String)"Affine", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, ROI roi, boolean useROIAccessor, boolean setDestinationNoData, Range nodata, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Affine", "renderable");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("transform", (Object)transform);
        pb.setParameter("interpolation", (Object)interpolation);
        pb.setParameter("backgroundValues", (Object)backgroundValues);
        pb.setParameter("setDestinationNoData", setDestinationNoData);
        pb.setParameter("nodata", (Object)nodata);
        if (roi != null) {
            pb.setParameter("roi", (Object)roi);
            pb.setParameter("useROIAccessor", useROIAccessor);
        }
        return ImageN.createRenderable((String)"Affine", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

