/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang3.tuple.Pair;
import org.geoserver.security.ldap.BindingLdapTemplate;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class BindingLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Logger logger = Logging.getLogger(BindingLdapAuthoritiesPopulator.class);
    private GrantedAuthority defaultRole;
    private final SpringSecurityLdapTemplate ldapTemplate;
    private final SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    private boolean useNestedParentGroups = false;
    private int maxGroupSearchLevel = 10;
    private String nestedGroupSearchFilter = "(member={0})";

    public BindingLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new BindingLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase == null) {
            logger.info("groupSearchBase is null. No group search will be performed.");
        } else if (groupSearchBase.isEmpty()) {
            logger.info("groupSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContext ctx, DirContextOperations user, String username) {
        return null;
    }

    public final Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
        return this.getGrantedAuthorities(user, username, null);
    }

    public final Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username, String password) {
        String userDn = user.getNameInNamespace();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting authorities for user " + userDn);
        }
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>();
        if (password != null) {
            Consumer<Consumer> ctxConsumer = ctxFunc -> this.ldapTemplate.authenticate((Name)LdapUtils.emptyLdapName(), userDn, password, (ctx, ldapEntryIdentification) -> ctxFunc.accept(ctx));
            this.ldapTemplate.authenticate((Name)LdapUtils.emptyLdapName(), userDn, password, (ctx, ldapEntryIdentification) -> this.getAllRoles(user, userDn, result, username, ctxConsumer));
        } else {
            this.getAllRoles(user, userDn, result, username, func -> func.accept(null));
        }
        return result;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(Consumer<Consumer<DirContext>> ctxConsumer, String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Searching for roles for user '" + username + "', DN = '" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'");
        }
        ArrayList userRolesNameDn = new ArrayList();
        ctxConsumer.accept(ctx -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.ldapTemplate);
            String formattedFilter = MessageFormat.format(this.groupSearchFilter, userDn, username);
            formattedFilter = LDAPUtils.escapeSearchString(formattedFilter);
            userRolesNameDn.addAll(authTemplate.search(this.getGroupSearchBase(), formattedFilter, (ContextMapper)new AbstractContextMapper<Pair<String, String>>(){

                protected Pair<String, String> doMapFromContext(DirContextOperations ctx) {
                    String name = ctx.getStringAttribute(BindingLdapAuthoritiesPopulator.this.groupRoleAttribute);
                    String dn = ctx.getNameInNamespace();
                    return Pair.of((Object)name, (Object)dn);
                }
            }));
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Roles from search: " + String.valueOf(userRolesNameDn));
        }
        for (Pair roleNameDn : userRolesNameDn) {
            String role = (String)roleNameDn.getLeft();
            String dn = (String)roleNameDn.getRight();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
            if (!this.useNestedParentGroups) continue;
            this.searchNestedGroupMembershipRoles(ctxConsumer, dn, (String)roleNameDn.getLeft(), authorities, this.maxGroupSearchLevel - 1);
        }
        return authorities;
    }

    private void searchNestedGroupMembershipRoles(Consumer<Consumer<DirContext>> ctxConsumer, String groupDn, String groupName, Set<GrantedAuthority> authorities, int depth) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Searching for roles for nested group '" + groupName + "', DN = '" + groupDn + "', with filter " + this.nestedGroupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'");
        }
        ArrayList groupRolesNameDn = new ArrayList();
        ctxConsumer.accept(ctx -> {
            SpringSecurityLdapTemplate authTemplate = LDAPUtils.getLdapTemplateInContext(ctx, this.ldapTemplate);
            String formattedFilter = MessageFormat.format(this.nestedGroupSearchFilter, groupDn, groupName);
            formattedFilter = LDAPUtils.escapeSearchString(formattedFilter);
            groupRolesNameDn.addAll(authTemplate.search(this.getGroupSearchBase(), formattedFilter, (ContextMapper)new AbstractContextMapper<Pair<String, String>>(){

                protected Pair<String, String> doMapFromContext(DirContextOperations ctx) {
                    String name = ctx.getStringAttribute(BindingLdapAuthoritiesPopulator.this.groupRoleAttribute);
                    String dn = ctx.getNameInNamespace();
                    return Pair.of((Object)name, (Object)dn);
                }
            }));
        });
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Roles from search: " + String.valueOf(groupRolesNameDn));
        }
        for (Pair roleNameDn : groupRolesNameDn) {
            String role = (String)roleNameDn.getLeft();
            String dn = (String)roleNameDn.getRight();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            boolean addedSuccesfuly = authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.rolePrefix + role));
            if (this.maxGroupSearchLevel != -1 && depth <= 0 || !addedSuccesfuly) continue;
            this.searchNestedGroupMembershipRoles(ctxConsumer, dn, (String)roleNameDn.getLeft(), authorities, depth - 1);
        }
    }

    protected ContextSource getContextSource() {
        return this.ldapTemplate.getContextSource();
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.ldapTemplate.setIgnorePartialResultException(ignore);
    }

    private void getAllRoles(DirContextOperations user, String userDn, List<GrantedAuthority> result, String userName, Consumer<Consumer<DirContext>> ctxConsumer) {
        Set<GrantedAuthority> roles = this.getGroupMembershipRoles(ctxConsumer, userDn, userName);
        HashSet extraRoles = new HashSet();
        ctxConsumer.accept(ctx -> extraRoles.addAll(this.getAdditionalRoles((DirContext)ctx, user, userName)));
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        result.addAll(roles);
    }

    public void setUseNestedParentGroups(boolean useNestedParentGroups) {
        this.useNestedParentGroups = useNestedParentGroups;
    }

    public void setMaxGroupSearchLevel(int maxGroupSearchLevel) {
        this.maxGroupSearchLevel = maxGroupSearchLevel;
    }

    public void setNestedGroupSearchFilter(String nestedGroupSearchFilter) {
        this.nestedGroupSearchFilter = nestedGroupSearchFilter;
    }
}

