/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import org.eclipse.imagen.media.stats.Statistics;

public class Max
extends Statistics {
    private double max = Double.NEGATIVE_INFINITY;

    Max() {
        this.type = Statistics.StatsType.MAX;
    }

    private double getMax() {
        return this.max;
    }

    @Override
    public void addSample(double sample) {
        ++this.samples;
        if (sample > this.max) {
            this.max = sample;
        }
    }

    @Override
    protected synchronized void accumulateStats(Statistics stats) {
        this.checkSameStats(stats);
        Max maxStats = (Max)stats;
        double maxNew = maxStats.getMax();
        if (maxNew > this.max) {
            this.max = maxNew;
        }
        this.samples += stats.getNumSamples().longValue();
    }

    @Override
    public Object getResult() {
        return this.max;
    }

    @Override
    public Long getNumSamples() {
        return this.samples;
    }

    @Override
    protected void clearStats() {
        this.max = Double.NEGATIVE_INFINITY;
    }
}

