/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.stats.Statistics;

public class Median
extends Statistics {
    private List<Double> listData;
    private final Range interval;

    Median(double minBound, double maxBound) {
        if (minBound == Double.NEGATIVE_INFINITY) {
            minBound = -1.7976931348623157E308;
        }
        if (maxBound == Double.POSITIVE_INFINITY) {
            maxBound = Double.MAX_VALUE;
        }
        this.interval = RangeFactory.create((double)minBound, (boolean)true, (double)maxBound, (boolean)false, (boolean)false);
        this.listData = Collections.synchronizedList(new ArrayList());
        this.type = Statistics.StatsType.MEDIAN;
    }

    @Override
    public void addSample(double sample) {
        ++this.samples;
        if (this.interval.contains(sample)) {
            this.listData.add(sample);
        }
    }

    @Override
    protected void accumulateStats(Statistics stats) {
        throw new UnsupportedOperationException("Median statistics cannot be accumulated");
    }

    @Override
    public Object getResult() {
        Collections.sort(this.listData);
        int listSize = this.listData.size();
        if (listSize == 0) {
            return Double.NaN;
        }
        if (listSize == 1) {
            return this.listData.get(0);
        }
        int halfSize = listSize / 2;
        double halfValue = this.listData.get(halfSize);
        if (this.listData.size() % 2 == 1) {
            return halfValue;
        }
        return (halfValue + this.listData.get(halfSize + 1)) / 2.0;
    }

    @Override
    public Long getNumSamples() {
        return this.samples;
    }

    @Override
    protected void clearStats() {
        this.listData = Collections.synchronizedList(new ArrayList());
    }
}

