/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import org.eclipse.imagen.media.stats.Statistics;

public class Min
extends Statistics {
    private double min = Double.POSITIVE_INFINITY;

    Min() {
        this.type = Statistics.StatsType.MIN;
    }

    private double getMin() {
        return this.min;
    }

    @Override
    public void addSample(double sample) {
        ++this.samples;
        if (sample < this.min) {
            this.min = sample;
        }
    }

    @Override
    protected synchronized void accumulateStats(Statistics stats) {
        this.checkSameStats(stats);
        Min minStats = (Min)stats;
        double minNew = minStats.getMin();
        if (minNew < this.min) {
            this.min = minNew;
        }
        this.samples += stats.getNumSamples().longValue();
    }

    @Override
    public Object getResult() {
        return this.min;
    }

    @Override
    protected void clearStats() {
        this.min = Double.POSITIVE_INFINITY;
    }

    @Override
    public Long getNumSamples() {
        return this.samples;
    }
}

