/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RasterAccessor;
import org.eclipse.imagen.RasterFormatTag;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.media.iterators.RandomIterFactory;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.stats.StatisticsOpImage;
import org.eclipse.imagen.media.stats.StatsFactory;

public class SimpleStatsOpImage
extends StatisticsOpImage {
    public SimpleStatsOpImage(RenderedImage source, int xPeriod, int yPeriod, ROI roi, Range noData, boolean useROIAccessor, int[] bands, Statistics.StatsType[] statsTypes) {
        super(source, xPeriod, yPeriod, roi, noData, useROIAccessor, bands, statsTypes, null, null, null);
        int i;
        if (statsTypes != null) {
            for (i = 0; i < statsTypes.length; ++i) {
                if (statsTypes[i].getStatsId() <= 6) continue;
                throw new IllegalArgumentException("Wrong statistic types");
            }
        } else {
            throw new IllegalArgumentException("Statistic types not present");
        }
        this.statsTypes = statsTypes;
        this.statNum = statsTypes.length;
        this.bands = bands;
        this.stats = new Statistics[this.selectedBands][this.statNum];
        for (i = 0; i < this.selectedBands; ++i) {
            for (int j = 0; j < this.statNum; ++j) {
                this.stats[i][j] = StatsFactory.createSimpleStatisticsObjectFromInt(statsTypes[j].getStatsId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = this.getSourceImage(0).getTile(tileX, tileY);
        if (this.xPeriod > this.getTileWidth() || this.yPeriod > this.getTileHeight()) {
            return source;
        }
        Rectangle srcRect = this.getSourceImage(0).getBounds().intersection(source.getBounds());
        RasterAccessor src = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor roi = null;
        RandomIter roiIter = null;
        if (this.useROIAccessor) {
            Raster roiRaster = null;
            roiRaster = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
            roi = new RasterAccessor(roiRaster, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
        } else if (this.hasROI) {
            roiIter = RandomIterFactory.create((RenderedImage)this.srcROIImage, (Rectangle)this.srcROIImage.getBounds(), (boolean)true, (boolean)true);
        }
        Statistics[][] statArray = new Statistics[this.selectedBands][this.statNum];
        for (int i = 0; i < this.selectedBands; ++i) {
            for (int j = 0; j < this.statNum; ++j) {
                statArray[i][j] = StatsFactory.createSimpleStatisticsObjectFromInt(this.statsTypes[j].getStatsId());
            }
        }
        switch (src.getDataType()) {
            case 0: {
                this.byteLoop(src, srcRect, roi, statArray, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(src, srcRect, roi, statArray, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(src, srcRect, roi, statArray, roiIter);
                break;
            }
            case 3: {
                this.intLoop(src, srcRect, roi, statArray, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(src, srcRect, roi, statArray, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(src, srcRect, roi, statArray, roiIter);
            }
        }
        SimpleStatsOpImage simpleStatsOpImage = this;
        synchronized (simpleStatsOpImage) {
            for (int i = 0; i < this.selectedBands; ++i) {
                for (int j = 0; j < this.statNum; ++j) {
                    this.stats[i][j].accumulateStats(statArray[i][j]);
                }
            }
        }
        return source;
    }
}

