/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptorImpl;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.stats.StatisticsPropertyGenerator;

public class StatisticsDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Stats"}, {"LocalName", "Stats"}, {"Vendor", "org.eclipse.imagen.media"}, {"Description", "Image operator for calculating simple image statistics like mean supporting ROI and No Data"}, {"DocURL", "Not defined"}, {"Version", "1.0"}, {"arg0Desc", "Horizontal subsampling parameter"}, {"arg1Desc", "Vertical subsampling parameter"}, {"arg2Desc", "ROI object used"}, {"arg3Desc", "No Data Range used"}, {"arg4Desc", "Boolean checking if ROI RasterAccessor is used"}, {"arg5Desc", "Array containing the indexes of the bands to calculate"}, {"arg6Desc", "Array indicating which statistical operations must be performed on all the selected bands"}, {"arg7Desc", "Array indicating the minimum bounds for each statistic types (if needed)"}, {"arg8Desc", "Array indicating the maximum bounds for each statistic types (if needed)"}, {"arg9Desc", "Array indicating the number of bins for each statistic types (if needed)"}};
    private static final Class[] paramClasses = new Class[]{Integer.class, Integer.class, ROI.class, Range.class, Boolean.class, int[].class, Statistics.StatsType[].class, double[].class, double[].class, int[].class};
    private static final String[] paramNames = new String[]{"xPeriod", "yPeriod", "ROI", "noData", "useRoiAccessor", "bands", "stats", "lowValue", "highValue", "numBins"};
    private static final Object[] paramDefaults = new Object[]{1, 1, null, null, false, new int[]{0}, null, new double[]{0.0}, new double[]{256.0}, new int[]{256}};

    public StatisticsDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new StatisticsPropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, int xPeriod, int yPeriod, ROI roi, Range noData, boolean useRoiAccessor, int[] bands, Statistics.StatsType[] stats, double[] minBounds, double[] maxBounds, int[] numBins, RenderingHints hints) {
        ParameterBlockImageN pb = new ParameterBlockImageN("Stats", "rendered");
        pb.setSource("source0", (Object)source0);
        pb.setParameter("xPeriod", xPeriod);
        pb.setParameter("yPeriod", yPeriod);
        pb.setParameter("ROI", (Object)roi);
        pb.setParameter("NoData", (Object)noData);
        pb.setParameter("useRoiAccessor", useRoiAccessor);
        pb.setParameter("bands", (Object)bands);
        pb.setParameter("stats", (Object)stats);
        if (minBounds != null && maxBounds != null && numBins != null) {
            pb.setParameter("lowValue", (Object)minBounds);
            pb.setParameter("highValue", (Object)maxBounds);
            pb.setParameter("numBins", (Object)numBins);
        } else if (minBounds != null || maxBounds != null || numBins != null) {
            throw new IllegalArgumentException("bounds and bins must be declared together");
        }
        return ImageN.create((String)"Stats", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderedOp create(RenderedImage source0, int xPeriod, int yPeriod, ROI roi, Range noData, boolean useRoiAccessor, int[] bands, Statistics.StatsType[] stats, RenderingHints hints) {
        return StatisticsDescriptor.create(source0, xPeriod, yPeriod, roi, noData, useRoiAccessor, bands, stats, null, null, null, hints);
    }
}

