/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OpImage;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RasterAccessor;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.util.PropertyUtil;

public abstract class StatisticsOpImage
extends OpImage {
    protected static final BorderExtender ROI_EXTENDER = BorderExtender.createInstance((int)0);
    protected Statistics[][] stats;
    protected final boolean hasNoData;
    protected final boolean hasROI;
    protected final boolean useROIAccessor;
    protected final PlanarImage srcROIImage;
    protected final Rectangle roiBounds;
    protected final boolean caseA;
    protected final boolean caseB;
    protected final boolean caseC;
    protected int bandsNumber;
    protected int selectedBands;
    protected int[] bands;
    protected Statistics.StatsType[] statsTypes;
    protected int statNum;
    protected AtomicBoolean firstTime = new AtomicBoolean(true);
    protected final int xPeriod;
    protected final int yPeriod;
    protected final boolean[] booleanLookupTable = new boolean[256];
    protected Range noData;
    protected RenderedOp srcROIImgExt;

    public StatisticsOpImage(RenderedImage source, int xPeriod, int yPeriod, ROI roi, Range noData, boolean useROIAccessor, int[] bands, Statistics.StatsType[] statsTypes, double[] minBound, double[] maxBound, int[] numBins) {
        super(StatisticsOpImage.vectorize((RenderedImage)source), new ImageLayout(source), null, true);
        this.bandsNumber = source.getSampleModel().getNumBands();
        int selectedBands = bands.length;
        if (selectedBands > this.bandsNumber) {
            throw new IllegalArgumentException("Number of Bands to analyze cannot be more than the Image bands");
        }
        if (selectedBands <= 0) {
            throw new IllegalArgumentException("Number of Bands to analyze cannot be less or equal to 0");
        }
        for (int i = 0; i < selectedBands; ++i) {
            if (bands[i] > this.bandsNumber) {
                throw new IllegalArgumentException("Band index cannot be more than the Image bands");
            }
            if (bands[i] >= 0) continue;
            throw new IllegalArgumentException("Band index cannot be less than 0");
        }
        if (xPeriod < 1 || yPeriod < 1) {
            throw new UnsupportedOperationException("Oversampling cannot be calculated");
        }
        this.xPeriod = xPeriod;
        this.yPeriod = yPeriod;
        this.bands = bands;
        this.selectedBands = selectedBands;
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        if (roi != null) {
            this.hasROI = true;
            ROI srcROI = roi;
            this.srcROIImage = srcROI.getAsImage();
            Rectangle srcRect = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
            this.roiBounds = this.srcROIImage.getBounds();
            int deltaX0 = this.roiBounds.x - srcRect.x;
            int leftP = deltaX0 > 0 ? deltaX0 : 0;
            int deltaY0 = this.roiBounds.y - srcRect.y;
            int topP = deltaY0 > 0 ? deltaY0 : 0;
            int deltaX1 = srcRect.x + srcRect.width - this.roiBounds.x + this.roiBounds.width;
            int rightP = deltaX1 > 0 ? deltaX1 : 0;
            int deltaY1 = srcRect.y + srcRect.height - this.roiBounds.y + this.roiBounds.height;
            int bottomP = deltaY1 > 0 ? deltaY1 : 0;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.srcROIImage, 0);
            pb.set(leftP, 0);
            pb.set(rightP, 1);
            pb.set(topP, 2);
            pb.set(bottomP, 3);
            pb.set(ROI_EXTENDER, 4);
            this.srcROIImgExt = ImageN.create((String)"border", (ParameterBlock)pb);
            this.useROIAccessor = useROIAccessor;
        } else {
            this.hasROI = false;
            this.useROIAccessor = false;
            this.roiBounds = null;
            this.srcROIImage = null;
        }
        if (this.hasNoData && source.getSampleModel().getDataType() == 0) {
            for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                byte value = (byte)i;
                this.booleanLookupTable[i] = !noData.contains(value);
            }
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
    }

    public String[] getPropertyNames() {
        String[] statsNames = new String[]{"ImageN-EXT.stats"};
        String[] superNames = super.getPropertyNames();
        if (superNames == null) {
            return statsNames;
        }
        ArrayList<String> extraNames = new ArrayList<String>();
        for (int i = 0; i < statsNames.length; ++i) {
            String prefix = statsNames[i];
            String[] names = PropertyUtil.getPropertyNames((String[])superNames, (String)prefix);
            if (names == null) continue;
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equalsIgnoreCase(prefix)) continue;
                extraNames.add(prefix);
            }
        }
        if (extraNames.size() == 0) {
            return superNames;
        }
        String[] propNames = new String[superNames.length + extraNames.size()];
        System.arraycopy(superNames, 0, propNames, 0, superNames.length);
        int offset = superNames.length;
        for (int i = 0; i < extraNames.size(); ++i) {
            propNames[offset++] = (String)extraNames.get(i);
        }
        return propNames;
    }

    public synchronized void clearStatistic() {
        for (int i = 0; i < this.stats.length; ++i) {
            for (int j = 0; j < this.statNum; ++j) {
                this.stats[i][j].clearStats();
            }
        }
        this.firstTime.getAndSet(true);
    }

    public void dispose() {
        if (this.srcROIImgExt != null) {
            this.srcROIImgExt.dispose();
        }
        super.dispose();
        this.clearStatistic();
    }

    public Raster[] getTiles() {
        if (this.firstTime.getAndSet(false)) {
            if (this.hasROI) {
                return this.getTiles(this.getTileIndices(this.roiBounds));
            }
            return this.getTiles(this.getTileIndices(this.getBounds()));
        }
        return null;
    }

    public Object getProperty(String name) {
        if ("ImageN-EXT.stats".equalsIgnoreCase(name)) {
            Point[] tileIndices = this.hasROI ? this.getTileIndices(this.roiBounds) : this.getTileIndices(this.getBounds());
            for (Point tileIndex : tileIndices) {
                this.getTile(tileIndex.x, tileIndex.y);
            }
            return this.stats.clone();
        }
        return super.getProperty(name);
    }

    protected void byteLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        byte[][] srcData = src.getByteDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                        if (!this.booleanLookupTable[sample]) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                        if (!this.booleanLookupTable[sample]) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFF;
                        if (!this.booleanLookupTable[sample]) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    protected void ushortLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        short[][] srcData = src.getShortDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                        boolean bl = isData = !this.noData.contains((short)sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                        boolean bl = isData = !this.noData.contains((short)sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]] & 0xFFFF;
                        boolean bl = isData = !this.noData.contains((short)sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    protected void shortLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        short[][] srcData = src.getShortDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        short sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    protected void intLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        int[][] srcData = src.getIntDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        int sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    protected void floatLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        float[][] srcData = src.getFloatDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        float sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    protected void doubleLoop(RasterAccessor src, Rectangle srcRect, RasterAccessor roi, Statistics[][] statArray, RandomIter roiIter) {
        int roiDataLength;
        int roiScanLineInc;
        byte[] roiDataArray;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiScanLineInc = roi.getScanlineStride() * this.yPeriod;
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiScanLineInc = 0;
            roiDataLength = 0;
        }
        double[][] srcData = src.getDoubleDataArrays();
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        if (this.caseA) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    int posyROI = y * roiScanLineInc;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int windex = x * this.xPeriod + posyROI;
                        int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                        if (w == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            } else {
                for (int y = 0; y < srcHeight; y += this.yPeriod) {
                    int posy = y * srcScanlineStride;
                    for (int x = 0; x < srcWidth; x += this.xPeriod) {
                        int w;
                        int posx = x * srcPixelStride;
                        int x0 = srcX + x;
                        int y0 = srcY + y;
                        if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                        for (int i = 0; i < this.selectedBands; ++i) {
                            double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                            for (int j = 0; j < this.statNum; ++j) {
                                statArray[i][j].addSample(sample);
                            }
                        }
                    }
                }
            }
        } else if (this.caseC) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int posx = x * srcPixelStride;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else if (this.useROIAccessor) {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                int posyROI = y * roiScanLineInc;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int windex = x * this.xPeriod + posyROI;
                    int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                    if (w == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        } else {
            for (int y = 0; y < srcHeight; y += this.yPeriod) {
                int posy = y * srcScanlineStride;
                for (int x = 0; x < srcWidth; x += this.xPeriod) {
                    int w;
                    int posx = x * srcPixelStride;
                    int x0 = srcX + x;
                    int y0 = srcY + y;
                    if (!this.roiBounds.contains(x0, y0) || (w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0) continue;
                    for (int i = 0; i < this.selectedBands; ++i) {
                        boolean isData;
                        double sample = srcData[this.bands[i]][posx + posy + srcBandOffsets[this.bands[i]]];
                        boolean bl = isData = !this.noData.contains(sample);
                        if (!isData) continue;
                        for (int j = 0; j < this.statNum; ++j) {
                            statArray[i][j].addSample(sample);
                        }
                    }
                }
            }
        }
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        return destRect;
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        return sourceRect;
    }
}

