/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.opimage.RIFUtil;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.stats.ComplexStatsOpImage;
import org.eclipse.imagen.media.stats.SimpleStatsOpImage;
import org.eclipse.imagen.media.stats.Statistics;

public class StatisticsRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock pb, RenderingHints hints) {
        RenderedImage source = pb.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)hints);
        int xPeriod = pb.getIntParameter(0);
        int yPeriod = pb.getIntParameter(1);
        ROI roi = (ROI)pb.getObjectParameter(2);
        Range noData = (Range)pb.getObjectParameter(3);
        noData = RangeFactory.convert((Range)noData, (int)source.getSampleModel().getDataType());
        boolean useROIAccessor = (Boolean)pb.getObjectParameter(4);
        int[] bands = (int[])pb.getObjectParameter(5);
        Statistics.StatsType[] statsTypes = (Statistics.StatsType[])pb.getObjectParameter(6);
        boolean isSimpleStat = true;
        for (int i = 0; i < statsTypes.length; ++i) {
            if (statsTypes[i].getStatsId() <= 6) continue;
            isSimpleStat = false;
            break;
        }
        if (isSimpleStat) {
            return new SimpleStatsOpImage(source, xPeriod, yPeriod, roi, noData, useROIAccessor, bands, statsTypes);
        }
        double[] minBounds = (double[])pb.getObjectParameter(7);
        double[] maxBounds = (double[])pb.getObjectParameter(8);
        int[] numBins = (int[])pb.getObjectParameter(9);
        return new ComplexStatsOpImage(source, xPeriod, yPeriod, roi, noData, useROIAccessor, bands, statsTypes, minBounds, maxBounds, numBins);
    }
}

