/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.stats;

import org.eclipse.imagen.media.stats.Extrema;
import org.eclipse.imagen.media.stats.HistogramMode;
import org.eclipse.imagen.media.stats.Max;
import org.eclipse.imagen.media.stats.MeanSum;
import org.eclipse.imagen.media.stats.Median;
import org.eclipse.imagen.media.stats.Min;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.stats.VarianceStd;

public class StatsFactory {
    private StatsFactory() {
    }

    public static Statistics createMeanObject() {
        return new MeanSum(false);
    }

    public static Statistics createSumObject() {
        return new MeanSum(true);
    }

    public static Statistics createMaxObject() {
        return new Max();
    }

    public static Statistics createMinObject() {
        return new Min();
    }

    public static Statistics createExtremaObject() {
        return new Extrema();
    }

    public static Statistics createVarianceObject() {
        return new VarianceStd(true);
    }

    public static Statistics createDevStdObject() {
        return new VarianceStd(false);
    }

    public static Statistics createHistogramObject(int numBins, double minBound, double maxBound) {
        return new HistogramMode(numBins, minBound, maxBound, true);
    }

    public static Statistics createModeObject(int numBins, double minBound, double maxBound) {
        return new HistogramMode(numBins, minBound, maxBound, false);
    }

    public static Statistics createMedianObject(double minBound, double maxBound) {
        return new Median(minBound, maxBound);
    }

    public static Statistics createSimpleStatisticsObjectFromInt(int value) {
        Statistics.StatsType type = Statistics.StatsType.values()[value];
        switch (type) {
            case MEAN: {
                return StatsFactory.createMeanObject();
            }
            case SUM: {
                return StatsFactory.createSumObject();
            }
            case MAX: {
                return StatsFactory.createMaxObject();
            }
            case MIN: {
                return StatsFactory.createMinObject();
            }
            case EXTREMA: {
                return StatsFactory.createExtremaObject();
            }
            case VARIANCE: {
                return StatsFactory.createVarianceObject();
            }
            case DEV_STD: {
                return StatsFactory.createDevStdObject();
            }
        }
        throw new IllegalArgumentException("Wrong StatsType object selected");
    }

    public static Statistics createComplexStatisticsObjectFromInt(int value, double minBound, double maxBound, int numBins) {
        Statistics.StatsType type = Statistics.StatsType.values()[value];
        switch (type) {
            case HISTOGRAM: {
                return StatsFactory.createHistogramObject(numBins, minBound, maxBound);
            }
            case MODE: {
                return StatsFactory.createModeObject(numBins, minBound, maxBound);
            }
            case MEDIAN: {
                return StatsFactory.createMedianObject(minBound, maxBound);
            }
        }
        throw new IllegalArgumentException("Wrong StatsType object selected");
    }
}

