/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.util.logging.Logging;

public class DescribeFeatureType {
    private Catalog catalog;
    private WFSInfo wfs;
    private static Logger LOGGER = Logging.getLogger(DescribeFeatureType.class);

    public DescribeFeatureType(WFSInfo wfs, Catalog catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setWFS(WFSInfo wfs) {
        this.wfs = wfs;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeRequest request) throws WFSException {
        ArrayList<QName> names = new ArrayList<QName>(request.getTypeNames());
        boolean citeConformance = this.getWFS().isCiteCompliant();
        if (!citeConformance) {
            ArrayList<QName> hackedNames = new ArrayList<QName>(names.size());
            NamespaceInfo defaultNameSpace = this.catalog.getDefaultNamespace();
            if (defaultNameSpace == null) {
                throw new IllegalStateException("No default namespace configured in GeoServer");
            }
            String defaultNsUri = defaultNameSpace.getURI();
            for (QName name : names) {
                String nsUri = name.getNamespaceURI();
                if ("".equals(nsUri) || "http://www.opengis.net/wfs".equals(nsUri) || "http://www.opengis.net/wfs/2.0".equals(nsUri)) {
                    name = new QName(defaultNsUri, name.getLocalPart());
                }
                hackedNames.add(name);
            }
            names = hackedNames;
        }
        ArrayList<FeatureTypeInfo> requested = new ArrayList<FeatureTypeInfo>(names.size());
        if (names.isEmpty()) {
            boolean skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)this.getWFS().getGeoServer().getGlobal().getResourceErrorHandling());
            for (FeatureTypeInfo ftInfo : new ArrayList(this.catalog.getFeatureTypes())) {
                if (!ftInfo.enabled()) continue;
                try {
                    ftInfo.getFeatureType();
                    requested.add(ftInfo);
                }
                catch (IOException ioe) {
                    ClientStreamAbortedException.rethrowUncheked((Exception)ioe);
                    if (skipMisconfigured) {
                        LOGGER.log(Level.WARNING, "Skipping DescribeFeature for " + ftInfo.prefixedName() + " because we couldn't connect", ioe);
                        continue;
                    }
                    throw new WFSException(ioe);
                }
            }
        } else {
            for (QName name : names) {
                String namespaceURI = name.getNamespaceURI();
                String typeName = name.getLocalPart();
                FeatureTypeInfo typeInfo = citeConformance && "".equals(namespaceURI) ? null : this.catalog.getFeatureTypeByName(namespaceURI, typeName);
                if (typeInfo != null && typeInfo.enabled()) {
                    requested.add(typeInfo);
                    continue;
                }
                String msg = "Could not find type: " + String.valueOf(name);
                if (citeConformance) {
                    msg = msg + ". \nStrict WFS protocol conformance is being applied.\nMake sure the type name is correctly qualified";
                }
                throw new WFSException((RequestObject)request, msg, "InvalidParameterValue");
            }
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

