/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.fes20.AbstractQueryExpressionType;
import net.opengis.wfs.XlinkPropertyNameType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ResultTypeType;
import net.opengis.wfs20.StoredQueryType;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.feature.TypeNameExtractingVisitor;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.AliasedQuery;
import org.geoserver.wfs.BBOXNamespaceSettingVisitor;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.geoserver.wfs.CountExecutor;
import org.geoserver.wfs.FeatureBoundsFeatureCollection;
import org.geoserver.wfs.FeatureSizeFeatureCollection;
import org.geoserver.wfs.GetFeatureCallback;
import org.geoserver.wfs.GetFeatureContext;
import org.geoserver.wfs.JoinExtractingVisitor;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.TypeInfoCollectionWrapper;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.LockFeatureResponse;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Join;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.filter.v2_0.FES;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.helpers.NamespaceSupport;

public class GetFeature {
    static final String GET_FEATURE_BY_ID_DEPRECATED = "urn:ogc:def:query:OGC-WFS::GetFeatureById";
    static final String GET_FEATURE_BY_ID = "http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById";
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests");
    private static final FilterCapabilities joinFilterCapabilities = new FilterCapabilities();
    protected Catalog catalog;
    protected WFSInfo wfs;
    protected FilterFactory filterFactory;
    StoredQueryProvider storedQueryProvider;

    public GetFeature(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public NamespaceSupport getNamespaceSupport() {
        return new CatalogNamespaceSupport(this.catalog);
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setStoredQueryProvider(StoredQueryProvider storedQueryProvider) {
        this.storedQueryProvider = storedQueryProvider;
    }

    public FeatureCollectionResponse run(GetFeatureRequest request) throws WFSException {
        int totalOffset;
        BigInteger bi;
        List<Query> queries = request.getQueries();
        if (queries.isEmpty()) {
            throw new WFSException((RequestObject)request, "No query specified");
        }
        if (WFSInfo.Version.V_20.compareTo(request.getVersion()) >= 0 && request.isLockRequest() && request.isResultTypeHits()) {
            throw new WFSException("GetFeatureWithLock cannot be used with result type 'hits'", "InvalidParameterValue", "resultType");
        }
        boolean getFeatureById = this.processStoredQueries(request);
        queries = request.getQueries();
        if (request.isQueryTypeNamesUnset()) {
            GetFeature.expandTypeNames(request, queries, getFeatureById, this.getCatalog());
        }
        String lockId = null;
        if (request.isLockRequest()) {
            lockId = this.filterRequestToLocked(request, queries);
        }
        if ((bi = request.getMaxFeatures()) == null) {
            request.setMaxFeatures(BigInteger.valueOf(Integer.MAX_VALUE));
        }
        int maxFeatures = Math.min(request.getMaxFeatures().intValue(), this.wfs.getMaxFeatures());
        if (this.wfs.isHitsIgnoreMaxFeatures() && request.isResultTypeHits()) {
            maxFeatures = Integer.MAX_VALUE;
        }
        List<Map<String, String>> viewParams = null;
        if (request.getViewParams() != null && !request.getViewParams().isEmpty()) {
            viewParams = request.getViewParams();
        }
        boolean isNumberMatchedSkipped = false;
        int count = 0;
        Supplier<BigInteger> totalCount = () -> BigInteger.ZERO;
        int n = totalOffset = request.getStartIndex() != null ? request.getStartIndex().intValue() : -1;
        if (totalOffset == -1 && request.getVersion().startsWith("2") && (this.wfs.isCiteCompliant() || request.getMaxFeatures() != null && request.getMaxFeatures().longValue() > 0L && request.isResultTypeHits())) {
            totalOffset = 0;
        }
        int offset = totalOffset;
        boolean calculateSize = !"1.0".equals(request.getVersion()) && !"1.0.0".equals(request.getVersion()) || queries.size() != 1 && maxFeatures != Integer.MAX_VALUE;
        ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>> results = new ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>>();
        ArrayList<CountExecutor> totalCountExecutors = new ArrayList<CountExecutor>();
        try {
            for (int i = 0; i < queries.size() && (i == 0 || count < maxFeatures); ++i) {
                Query query = queries.get(i);
                try {
                    this.validateQueryAliases(request, query);
                    List<FeatureTypeInfo> metas = new ArrayList<FeatureTypeInfo>();
                    for (QName typeName : query.getTypeNames()) {
                        metas.add(this.featureTypeInfo(typeName, request));
                    }
                    FeatureTypeInfo meta = (FeatureTypeInfo)metas.get(0);
                    List<List<String>> reqPropertyNames = this.parsePropertyNames(query, metas);
                    NamespaceSupport ns = this.getNamespaceSupport();
                    List<Join> joins = null;
                    String primaryAlias = null;
                    QName primaryTypeName = query.getTypeNames().get(0);
                    FeatureTypeInfo primaryMeta = (FeatureTypeInfo)metas.get(0);
                    Filter filter = query.getFilter();
                    if (filter == null && metas.size() > 1) {
                        throw new WFSException((RequestObject)request, "Join query must specify a filter");
                    }
                    if (filter != null) {
                        if (meta.getFeatureType() instanceof SimpleFeatureType) {
                            if (metas.size() > 1) {
                                query = AliasedQuery.fixAliases(metas, query);
                                filter = query.getFilter();
                                filter = SimplifyingFilterVisitor.simplify((Filter)filter);
                                JoinExtractingVisitor extractor = new JoinExtractingVisitor(metas, query.getAliases());
                                extractor.setQueriedTypes(query.getTypeNames());
                                filter.accept((FilterVisitor)extractor, null);
                                primaryAlias = extractor.getPrimaryAlias();
                                primaryMeta = extractor.getPrimaryFeatureType();
                                metas = extractor.getFeatureTypes();
                                primaryTypeName = new QName(primaryMeta.getNamespace().getURI(), primaryMeta.getName());
                                joins = extractor.getJoins();
                                if (joins.size() != metas.size() - 1) {
                                    throw new WFSException((RequestObject)request, String.format("Query specified %d types but %d join filters were found", metas.size(), extractor.getJoins().size()));
                                }
                                for (int j = 1; j < metas.size(); ++j) {
                                    Join join = joins.get(j - 1);
                                    this.validateJoin(request, query, filter, join, metas.get(j));
                                }
                                filter = extractor.getPrimaryFilter();
                                if (filter != null) {
                                    this.validateFilter(filter, query, primaryMeta, request);
                                }
                            } else {
                                this.validateFilter(filter, query, meta, request);
                            }
                        } else {
                            BBOXNamespaceSettingVisitor filterVisitor = new BBOXNamespaceSettingVisitor(ns);
                            filter.accept((FilterVisitor)filterVisitor, null);
                        }
                    }
                    ArrayList<List<PropertyName>> propNames = new ArrayList<List<PropertyName>>();
                    ArrayList<List<PropertyName>> allPropNames = new ArrayList<List<PropertyName>>();
                    this.collectPropertyNames(request, metas, meta, reqPropertyNames, ns, propNames, allPropNames);
                    List<SortBy> sortBy = query.getSortBy();
                    if (sortBy != null && !sortBy.isEmpty() && meta.getFeatureType() instanceof SimpleFeatureType) {
                        this.validateSortBy(sortBy, meta, request);
                    }
                    Hints hints = null;
                    if (joins != null) {
                        hints = new Hints((RenderingHints.Key)ResourcePool.JOINS, joins);
                    }
                    if (meta.getStore().getConnectionParameters().get(WFSDataStoreFactory.USEDEFAULTSRS.key) != null && meta.getMetadata().get((Object)"OTHER_SRS") != null && !Boolean.valueOf(((Serializable)meta.getStore().getConnectionParameters().get(WFSDataStoreFactory.USEDEFAULTSRS.key)).toString()).booleanValue() && query.getSrsName() != null) {
                        hints = this.setWFSCascadingReprojection(query, meta, hints);
                    }
                    FeatureSource source = primaryMeta.getFeatureSource(null, hints);
                    int queryMaxFeatures = maxFeatures - count;
                    int metaMaxFeatures = this.maxFeatures(metas);
                    if (metaMaxFeatures > 0 && metaMaxFeatures < queryMaxFeatures) {
                        queryMaxFeatures = metaMaxFeatures;
                    }
                    Map<String, String> viewParam = viewParams != null ? viewParams.get(i) : null;
                    org.geotools.api.data.Query gtQuery = this.toDataQuery(query, filter, offset, queryMaxFeatures, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Query is " + String.valueOf(query) + "\n To gt2: " + String.valueOf(gtQuery));
                    }
                    GetFeatureContext context = new GetFeatureContext(request, meta, (FeatureSource<? extends FeatureType, ? extends Feature>)source, gtQuery);
                    List callbacks = GeoServerExtensions.extensions(GetFeatureCallback.class);
                    if (!callbacks.isEmpty()) {
                        for (GetFeatureCallback callback : callbacks) {
                            callback.beforeQuerying(context);
                        }
                        if (gtQuery != context.getQuery() && LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Query after GetFeatureCallback changes: " + String.valueOf(source));
                        }
                        gtQuery = context.getQuery();
                    }
                    FeatureCollection<? extends FeatureType, ? extends Feature> features = this.getFeatures(request, (FeatureSource<? extends FeatureType, ? extends Feature>)source, gtQuery);
                    if (!(meta.getFeatureType() instanceof SimpleFeatureType)) {
                        features.getSchema().getUserData().put("targetCrs", query.getSrsName());
                        features.getSchema().getUserData().put("targetVersion", request.getVersion());
                    }
                    if (!calculateSize) {
                        calculateSize = offset > 0 && i < queries.size() - 1;
                    }
                    int size = 0;
                    if (calculateSize) {
                        size = features.size();
                    }
                    count += size;
                    boolean bl = isNumberMatchedSkipped = meta.getSkipNumberMatched() && !request.isResultTypeHits();
                    if (!isNumberMatchedSkipped) {
                        if (calculateSize && (queryMaxFeatures == Integer.MAX_VALUE || size < queryMaxFeatures) && offset <= 0) {
                            totalCountExecutors.add(new CountExecutor(size));
                        } else {
                            org.geotools.api.data.Query qTotal = this.toDataQuery(query, filter, 0, Integer.MAX_VALUE, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                            totalCountExecutors.add(new CountExecutor(source, qTotal));
                        }
                    }
                    if (offset > 0) {
                        if (size > 0) {
                            offset = 0;
                        } else {
                            org.geotools.api.data.Query q2 = this.toDataQuery(query, filter, 0, queryMaxFeatures, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                            int size2 = source.getCount(q2);
                            if (size2 > 0) {
                                offset = Math.max(0, offset - size2);
                            }
                        }
                    }
                    List metaPropNames = (List)propNames.get(0);
                    if (features.getSchema() instanceof SimpleFeatureType && metaPropNames != null && metaPropNames.size() < ((List)allPropNames.get(0)).size()) {
                        features = this.retypeToRequestedProperties(features, metaPropNames);
                    }
                    if (primaryMeta != null) {
                        features = TypeInfoCollectionWrapper.wrap(features, primaryMeta);
                    }
                    results.add(features);
                    continue;
                }
                catch (WFSException e) {
                    if (query.getHandle() != null && (e.getLocator() == null || "GetFeature".equalsIgnoreCase(e.getLocator()))) {
                        e.setLocator(query.getHandle());
                    }
                    throw e;
                }
            }
            totalCount = this.updateTotalCount(maxFeatures, isNumberMatchedSkipped, count, totalOffset, calculateSize, totalCountExecutors);
        }
        catch (IOException | SchemaException e) {
            throw new WFSException(request, "Error occurred getting features", e, request.getHandle());
        }
        return this.buildResults(request, totalOffset, maxFeatures, count, totalCount, results, lockId, getFeatureById);
    }

    private void validateJoin(GetFeatureRequest request, Query query, Filter filter, Join join, FeatureTypeInfo meta) throws IOException {
        if (!this.isValidJoinFilter(join.getJoinFilter())) {
            throw new WFSException((RequestObject)request, "Unable to perform join with specified join filter: " + String.valueOf(filter));
        }
        if (join.getFilter() != null) {
            this.validateFilter(join.getFilter(), query, meta, request);
        }
    }

    private void validateQueryAliases(GetFeatureRequest request, Query query) {
        if (!query.getAliases().isEmpty() && query.getAliases().size() != query.getTypeNames().size()) {
            throw new WFSException((RequestObject)request, String.format("Query specifies %d type names and %d aliases, must be equal", query.getTypeNames().size(), query.getAliases().size()));
        }
    }

    private Supplier<BigInteger> updateTotalCount(int maxFeatures, boolean isNumberMatchedSkipped, int count, int totalOffset, boolean calculateSize, List<CountExecutor> totalCountExecutors) throws IOException {
        if (isNumberMatchedSkipped) {
            return () -> BigInteger.valueOf(-1L);
        }
        if (count < maxFeatures && calculateSize && totalOffset == 0) {
            return () -> BigInteger.valueOf(count);
        }
        if (this.isPreComputed(totalCountExecutors)) {
            long total = this.getTotalCount(totalCountExecutors);
            return () -> BigInteger.valueOf(total);
        }
        AtomicLong cache = new AtomicLong(Long.MIN_VALUE);
        return () -> {
            try {
                if (cache.get() == Long.MIN_VALUE) {
                    cache.set(this.getTotalCount(totalCountExecutors));
                }
                return BigInteger.valueOf(cache.get());
            }
            catch (IOException ioException) {
                throw new RuntimeException("Lazy total count unavailable " + ioException.getMessage(), ioException);
            }
        };
    }

    private void collectPropertyNames(GetFeatureRequest request, List<FeatureTypeInfo> metas, FeatureTypeInfo meta, List<List<String>> reqPropertyNames, NamespaceSupport ns, List<List<PropertyName>> propNames, List<List<PropertyName>> allPropNames) throws IOException {
        for (int j = 0; j < metas.size(); ++j) {
            List<String> propertyNames = reqPropertyNames.get(j);
            List<Object> metaPropNames = null;
            List<Object> metaAllPropNames = null;
            if (!propertyNames.isEmpty()) {
                metaPropNames = new ArrayList<PropertyName>();
                for (String propertyName : propertyNames) {
                    PropertyName propName = this.createPropertyName(propertyName, ns);
                    if (propName.evaluate((Object)meta.getFeatureType()) == null) {
                        String mesg = "Requested property: " + String.valueOf(propName) + " is not available for " + meta.prefixedName() + ".  ";
                        if (meta.getFeatureType() instanceof SimpleFeatureType) {
                            List atts = meta.attributes();
                            ArrayList<String> attNames = new ArrayList<String>(atts.size());
                            for (AttributeTypeInfo att : atts) {
                                attNames.add(att.getName());
                            }
                            mesg = mesg + "The possible propertyName values are: " + String.valueOf(attNames);
                        }
                        throw new WFSException((RequestObject)request, mesg, "InvalidParameterValue");
                    }
                    metaPropNames.add(propName);
                }
                metaAllPropNames = this.wfs.isFeatureBounding() ? this.addGeometryProperties(meta, metaPropNames) : metaPropNames;
                if (meta.getFeatureType() instanceof SimpleFeatureType) {
                    metaAllPropNames = DataUtilities.addMandatoryProperties((SimpleFeatureType)((SimpleFeatureType)meta.getFeatureType()), metaAllPropNames);
                    metaPropNames = DataUtilities.addMandatoryProperties((SimpleFeatureType)((SimpleFeatureType)meta.getFeatureType()), metaPropNames);
                }
            }
            allPropNames.add(metaAllPropNames);
            propNames.add(metaPropNames);
        }
    }

    private Hints setWFSCascadingReprojection(Query query, FeatureTypeInfo meta, Hints hints) {
        String otherSrsStr = (String)((Object)meta.getMetadata().get((Object)"OTHER_SRS"));
        List<String> otherSRSList = Arrays.asList(otherSrsStr.split(","));
        try {
            CoordinateReferenceSystem requestedCRS = CRS.decode((String)query.getSrsName().toString());
            for (String otherSRS : otherSRSList) {
                if (CRS.isTransformationRequired((CoordinateReferenceSystem)CRS.decode((String)otherSRS), (CoordinateReferenceSystem)requestedCRS)) continue;
                if (hints == null) {
                    hints = new Hints();
                }
                hints.put((Object)ResourcePool.MAP_CRS, (Object)requestedCRS);
                break;
            }
        }
        catch (FactoryException ne) {
            LOGGER.log(Level.SEVERE, ne.getMessage(), ne);
        }
        return hints;
    }

    private FeatureCollection<? extends FeatureType, ? extends Feature> retypeToRequestedProperties(FeatureCollection<? extends FeatureType, ? extends Feature> features, List<PropertyName> metaPropNames) throws SchemaException {
        String[] residualNames = new String[metaPropNames.size()];
        Iterator<PropertyName> it = metaPropNames.iterator();
        int j = 0;
        while (it.hasNext()) {
            residualNames[j] = it.next().getPropertyName();
            ++j;
        }
        SimpleFeatureType targetType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)features.getSchema()), (String[])residualNames);
        features = new FeatureBoundsFeatureCollection((SimpleFeatureCollection)features, targetType);
        return features;
    }

    private String filterRequestToLocked(GetFeatureRequest request, List<Query> queries) {
        LockFeatureRequest lockRequest = request.createLockRequest();
        lockRequest.setExpiry(request.getExpiry());
        lockRequest.setHandle(request.getHandle());
        if (request.isLockActionSome()) {
            lockRequest.setLockActionSome();
        } else {
            lockRequest.setLockActionAll();
        }
        for (Query query : queries) {
            Lock lock = lockRequest.createLock();
            lock.setFilter(query.getFilter());
            lock.setHandle(query.getHandle());
            List<QName> typeNames = query.getTypeNames();
            lock.setTypeName(typeNames.get(0));
            lockRequest.addLock(lock);
        }
        LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
        lockFeature.setFilterFactory(this.filterFactory);
        LockFeatureResponse response = lockFeature.lockFeature(lockRequest);
        String lockId = response.getLockId();
        if (request.isLockActionSome()) {
            Filter lockedFeatureFilter = this.toFeatureIdFilter(response.getLockedFeatures());
            for (Query query : queries) {
                Filter filter = query.getFilter();
                if (filter == null || filter == Filter.INCLUDE) {
                    query.setFilter(lockedFeatureFilter);
                    continue;
                }
                Filter joined = Predicates.and((Filter)filter, (Filter)lockedFeatureFilter);
                query.setFilter(joined);
            }
        }
        return lockId;
    }

    private boolean isPreComputed(List<CountExecutor> totalCountExecutors) {
        for (CountExecutor q : totalCountExecutors) {
            if (q.isCountSet()) continue;
            return false;
        }
        return true;
    }

    private long getTotalCount(List<CountExecutor> totalCountExecutors) throws IOException {
        long totalCount = 0L;
        for (CountExecutor q : totalCountExecutors) {
            int result = q.getCount();
            if (result == -1) {
                totalCount = -1L;
                break;
            }
            totalCount += (long)result;
        }
        return totalCount;
    }

    private Filter toFeatureIdFilter(List<FeatureId> lockedFeatures) {
        if (lockedFeatures == null || lockedFeatures.isEmpty()) {
            return Filter.EXCLUDE;
        }
        Set ids = lockedFeatures.stream().map(fid -> this.filterFactory.featureId(fid.getID())).collect(Collectors.toSet());
        return this.filterFactory.id(ids);
    }

    static void expandTypeNames(RequestObject request, List<Query> queries, boolean getFeatureById, Catalog catalog) {
        for (Query q : queries) {
            if (!q.getTypeNames().isEmpty()) continue;
            if (q.getFilter() != null) {
                TypeNameExtractingVisitor v = new TypeNameExtractingVisitor(catalog);
                q.getFilter().accept((FilterVisitor)v, null);
                q.getTypeNames().addAll(v.getTypeNames());
            }
            if (!q.getTypeNames().isEmpty()) continue;
            if (getFeatureById) {
                throw new WFSException(request, "Could not find feature with specified id", "NotFound");
            }
            String msg = "No feature types specified";
            throw new WFSException(request, msg, "InvalidParameterValue");
        }
    }

    protected boolean processStoredQueries(GetFeatureRequest request) {
        List<Object> queries = request.getAdaptedQueries();
        boolean foundGetFeatureById = GetFeature.expandStoredQueries(request, queries, this.storedQueryProvider);
        return queries.size() == 1 && foundGetFeatureById;
    }

    static boolean expandStoredQueries(RequestObject request, List<AbstractQueryExpressionType> queries, StoredQueryProvider storedQueryProvider) {
        boolean foundGetFeatureById = false;
        for (int i = 0; i < queries.size(); ++i) {
            AbstractQueryExpressionType obj = queries.get(i);
            if (!(obj instanceof StoredQueryType)) continue;
            StoredQueryType sq = (StoredQueryType)obj;
            if (storedQueryProvider == null) {
                throw new WFSException(request, "Stored query not supported");
            }
            String storedQueryId = sq.getId();
            foundGetFeatureById |= GET_FEATURE_BY_ID.equalsIgnoreCase(storedQueryId) || GET_FEATURE_BY_ID_DEPRECATED.equals(storedQueryId);
            StoredQuery storedQuery = storedQueryProvider.getStoredQuery(storedQueryId);
            if (storedQuery == null) {
                WFSException exception = new WFSException(request, "Stored query '" + storedQueryId + "' does not exist.", "InvalidParameterValue");
                exception.setLocator("STOREDQUERY_ID");
                throw exception;
            }
            List<QueryType> compiled = storedQuery.compile(sq);
            queries.remove(i);
            queries.addAll(i, compiled);
            i += compiled.size();
        }
        return foundGetFeatureById;
    }

    protected FeatureCollectionResponse buildResults(GetFeatureRequest request, int offset, int maxFeatures, int count, Supplier<BigInteger> total, List<FeatureCollection<? extends FeatureType, ? extends Feature>> results, String lockId, boolean getFeatureById) {
        FeatureCollectionResponse result = request.createResponse();
        result.setNumberOfFeatures(BigInteger.valueOf(count));
        result.setLazyTotalNumberOfFeatures(total);
        result.setTimeStamp(Calendar.getInstance());
        result.setLockId(lockId);
        result.getFeature().addAll(results);
        result.setGetFeatureById(getFeatureById);
        if (offset > 0 || count < Integer.MAX_VALUE) {
            Request req = (Request)Dispatcher.REQUEST.get();
            KvpMap<String, String> kvp = null;
            kvp = req.isGet() ? this.mapValuesToStrings(req.getRawKvp()) : this.buildKvpFromRequest(request);
            this.buildPrevNextLinks(request, offset, maxFeatures, count, result, (Map<String, String>)kvp);
        }
        return result;
    }

    private KvpMap<String, String> mapValuesToStrings(Map<String, Object> rawKvp) {
        return rawKvp.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue(), (u, v) -> {
            throw new IllegalStateException("Duplicate key %s".formatted(u));
        }, () -> new KvpMap()));
    }

    protected void buildPrevNextLinks(GetFeatureRequest request, int offset, int maxFeatures, int count, FeatureCollectionResponse result, Map<String, String> kvp) {
        if (request.isResultTypeHits() && (request.getVersion() == null || request.getVersion().startsWith("2"))) {
            kvp = new KvpMap(kvp);
            kvp.put("RESULTTYPE", "results");
            kvp.put("STARTINDEX", "0");
        }
        if (!(offset <= 0 || request.isResultTypeHits() && request.getVersion().startsWith("2"))) {
            int prevOffset = Math.max(offset - maxFeatures, 0);
            kvp.put("startIndex", String.valueOf(prevOffset));
            kvp.put("count", String.valueOf(offset - prevOffset));
            result.setPrevious(ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"wfs", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
        }
        if (request.isResultTypeHits() && request.getVersion().startsWith("2")) {
            result.setNext(ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"wfs", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
        } else if (count > 0 && offset > -1 && maxFeatures <= count) {
            kvp.put("startIndex", String.valueOf(offset > 0 ? offset + count : count));
            kvp.put("count", String.valueOf(maxFeatures));
            result.setNext(ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"wfs", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
        }
    }

    protected KvpMap<String, String> buildKvpFromRequest(GetFeatureRequest request) {
        KvpMap kvp = new KvpMap();
        kvp.put("SERVICE", (Object)"WFS");
        kvp.put("REQUEST", (Object)"GetFeature");
        kvp.put("VERSION", (Object)request.getVersion());
        kvp.put("OUTPUTFORMAT", (Object)request.getOutputFormat());
        kvp.put("RESULTTYPE", (Object)(request.isResultTypeHits() ? ResultTypeType.HITS.name() : ResultTypeType.RESULTS.name()));
        List<Query> queries = request.getQueries();
        Query q = queries.get(0);
        if (q.getSrsName() != null) {
            kvp.put("SRSNAME", (Object)q.getSrsName().toString());
        }
        StringBuilder typeNames = new StringBuilder();
        StringBuilder propertyName = !q.getPropertyNames().isEmpty() ? new StringBuilder() : null;
        StringBuilder aliases = !q.getAliases().isEmpty() ? new StringBuilder() : null;
        StringBuilder filter = q.getFilter() != null && q.getFilter() != Filter.INCLUDE ? new StringBuilder() : null;
        this.encodeQueryAsKvp(q, typeNames, propertyName, aliases, filter, true);
        if (queries.size() > 1) {
            for (int i = 1; i < queries.size(); ++i) {
                this.encodeQueryAsKvp(queries.get(i), typeNames, propertyName, aliases, filter, true);
            }
        }
        kvp.put("TYPENAMES", (Object)typeNames.toString());
        if (propertyName != null) {
            kvp.put("PROPERTYNAME", (Object)propertyName.toString());
        }
        if (aliases != null) {
            kvp.put("ALIASES", (Object)aliases.toString());
        }
        if (filter != null) {
            kvp.put("FILTER", (Object)filter.toString());
        }
        return kvp;
    }

    void encodeQueryAsKvp(Query q, StringBuilder typeNames, StringBuilder propertyName, StringBuilder aliases, StringBuilder filter, boolean useDelim) {
        if (useDelim) {
            typeNames.append("(");
        }
        for (QName qName : q.getTypeNames()) {
            typeNames.append(qName.getPrefix()).append(":").append(qName.getLocalPart()).append(",");
        }
        typeNames.setLength(typeNames.length() - 1);
        if (useDelim) {
            typeNames.append(")");
        }
        if (propertyName != null) {
            if (useDelim) {
                propertyName.append("(");
            }
            for (String pName : q.getPropertyNames()) {
                propertyName.append(pName).append(",");
            }
            propertyName.setLength(propertyName.length() - 1);
            if (useDelim) {
                propertyName.append(")");
            }
        }
        if (aliases != null) {
            if (useDelim) {
                aliases.append("(");
            }
            for (String alias : q.getAliases()) {
                aliases.append(alias).append(",");
            }
            aliases.setLength(aliases.length() - 1);
            if (useDelim) {
                aliases.append(")");
            }
        }
        if (filter != null) {
            Filter f = q.getFilter();
            if (useDelim) {
                filter.append("(");
            }
            try {
                Encoder e = new Encoder((Configuration)new FESConfiguration());
                e.setOmitXMLDeclaration(true);
                filter.append(e.encodeAsString((Object)q.getFilter(), FES.Filter));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to encode filter " + String.valueOf(f), e);
            }
            if (useDelim) {
                filter.append(")");
            }
        }
    }

    protected FeatureCollection<? extends FeatureType, ? extends Feature> getFeatures(Object request, FeatureSource<? extends FeatureType, ? extends Feature> source, org.geotools.api.data.Query gtQuery) throws IOException {
        FeatureCollection<? extends FeatureType, ? extends Feature> features = source.getFeatures(gtQuery);
        features = FeatureSizeFeatureCollection.wrap(features, source, gtQuery);
        return features;
    }

    public org.geotools.api.data.Query toDataQuery(Query query, Filter filter, int offset, int maxFeatures, FeatureSource<? extends FeatureType, ? extends Feature> source, GetFeatureRequest request, List<PropertyName> props, Map<String, String> viewParams, List<Join> joins, QName primaryTypeName, String primaryAlias) throws WFSException {
        Iterator<XlinkPropertyNameType> iterator;
        List<XlinkPropertyNameType> xlinkProperties;
        String featureVersion;
        List<SortBy> sortBy;
        CoordinateReferenceSystem target;
        URI srsName;
        String wfsVersion = request.getVersion();
        if (maxFeatures < 0) {
            maxFeatures = Integer.MAX_VALUE;
        }
        if (maxFeatures == 0) {
            filter = Filter.EXCLUDE;
        } else if (filter == null) {
            filter = Filter.INCLUDE;
        } else {
            SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
            filter = (Filter)filter.accept((FilterVisitor)visitor, null);
        }
        CoordinateReferenceSystem crs = source.getSchema().getCoordinateReferenceSystem();
        FeatureTypeInfo featureTypeInfo = this.catalog.getFeatureTypeByName(primaryTypeName.getPrefix(), primaryTypeName.getLocalPart());
        CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(crs, wfsVersion);
        Filter transformedFilter = filter;
        transformedFilter = declaredCRS != null ? WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS) : this.buildFilterCRSFromInfo(filter, primaryTypeName, source, wfsVersion);
        declaredCRS = this.replaceCRSIfComplexFeatures(source, wfsVersion, crs, featureTypeInfo, declaredCRS);
        transformedFilter = (Filter)transformedFilter.accept((FilterVisitor)new BoundedByVisitor(), null);
        QName typeName = primaryTypeName;
        org.geotools.api.data.Query dataQuery = new org.geotools.api.data.Query(typeName.getLocalPart(), transformedFilter, maxFeatures, props, query.getHandle());
        if (primaryAlias != null) {
            dataQuery.setAlias(primaryAlias);
        }
        if ((srsName = query.getSrsName()) != null) {
            try {
                target = CRS.decode((String)srsName.toString());
            }
            catch (Exception e) {
                String msg = "Unable to support srsName: " + String.valueOf(srsName);
                throw new WFSException(request, msg, (Throwable)e, "InvalidParameterValue").locator("srsName");
            }
        } else {
            target = declaredCRS;
        }
        if (target != null && declaredCRS != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)target)) {
            dataQuery.setCoordinateSystemReproject(target);
        }
        if ((sortBy = query.getSortBy()) != null) {
            dataQuery.setSortBy(sortBy.toArray(new SortBy[sortBy.size()]));
        }
        if ((featureVersion = query.getFeatureVersion()) != null) {
            dataQuery.setVersion(featureVersion);
        }
        if (offset > -1) {
            dataQuery.setStartIndex(Integer.valueOf(offset));
        }
        Hints hints = new Hints();
        String traverseXlinkDepth = request.getTraverseXlinkDepth();
        if (traverseXlinkDepth != null) {
            Integer depth = GetFeature.traverseXlinkDepth(traverseXlinkDepth);
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)depth);
        }
        hints.put((Object)Hints.RESOLVE, (Object)request.getResolve());
        BigInteger resolveTimeOut = request.getResolveTimeOut();
        if (resolveTimeOut != null) {
            hints.put((Object)Hints.RESOLVE_TIMEOUT, (Object)resolveTimeOut.intValue());
        }
        if (!(xlinkProperties = query.getXlinkPropertyNames()).isEmpty() && (iterator = xlinkProperties.iterator()).hasNext()) {
            XlinkPropertyNameType xlinkProperty = iterator.next();
            Integer xlinkDepth = GetFeature.traverseXlinkDepth(xlinkProperty.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)xlinkDepth);
            PropertyName xlinkPropertyName = this.filterFactory.property(xlinkProperty.getValue());
            hints.put((Object)Hints.ASSOCIATION_PROPERTY, (Object)xlinkPropertyName);
            dataQuery.setHints(hints);
        }
        hints.put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        if (viewParams != null) {
            hints.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams);
        }
        hints.put((Object)org.geotools.api.data.Query.INCLUDE_MANDATORY_PROPS, (Object)true);
        if (joins != null) {
            dataQuery.getJoins().addAll(joins);
        }
        dataQuery.setHints(hints);
        return dataQuery;
    }

    private CoordinateReferenceSystem replaceCRSIfComplexFeatures(FeatureSource<? extends FeatureType, ? extends Feature> source, String wfsVersion, CoordinateReferenceSystem crs, FeatureTypeInfo featureTypeInfo, CoordinateReferenceSystem formerCrs) {
        if (source.getSchema() instanceof SimpleFeatureType) {
            return formerCrs;
        }
        ProjectionPolicy projectionPolicy = featureTypeInfo.getProjectionPolicy();
        switch (projectionPolicy) {
            case REPROJECT_TO_DECLARED: 
            case FORCE_DECLARED: {
                return WFSReprojectionUtil.getDeclaredCrs(featureTypeInfo.getCRS(), wfsVersion);
            }
        }
        return WFSReprojectionUtil.getDeclaredCrs(crs, wfsVersion);
    }

    static Integer traverseXlinkDepth(String raw) {
        Integer traverseXlinkDepth = null;
        try {
            traverseXlinkDepth = Integer.valueOf(raw);
        }
        catch (NumberFormatException nfe) {
            if ("*".equals(raw)) {
                traverseXlinkDepth = 2;
            }
            throw nfe;
        }
        return traverseXlinkDepth;
    }

    boolean isValidJoinFilter(Filter filter) {
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(joinFilterCapabilities, null, null);
        filter.accept((FilterVisitor)visitor, null);
        return visitor.getFilterPost() == null || visitor.getFilterPost() == Filter.INCLUDE;
    }

    FeatureTypeInfo featureTypeInfo(QName name, GetFeatureRequest request) throws WFSException, IOException {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(name.getNamespaceURI(), name.getLocalPart());
        if (meta == null) {
            String msg = "Could not locate " + String.valueOf(name) + " in catalog.";
            throw new WFSException((RequestObject)request, msg, "InvalidParameterValue").locator("typeName");
        }
        return meta;
    }

    List<List<String>> parsePropertyNames(Query query, List<FeatureTypeInfo> featureTypes) {
        ArrayList<List<String>> propNames = new ArrayList<List<String>>();
        for (FeatureTypeInfo featureType : featureTypes) {
            propNames.add(new ArrayList());
        }
        if (featureTypes.size() == 1) {
            ((List)propNames.get(0)).addAll(query.getPropertyNames());
            return propNames;
        }
        block1: for (String propName : query.getPropertyNames()) {
            int j;
            for (j = 0; j < featureTypes.size(); ++j) {
                FeatureTypeInfo featureType = featureTypes.get(j);
                if (propName.startsWith(featureType.prefixedName() + "/")) {
                    ((List)propNames.get(j)).add(propName.substring((featureType.prefixedName() + "/").length()));
                    continue block1;
                }
                if (!propName.startsWith(featureType.getName() + "/")) continue;
                ((List)propNames.get(j)).add(propName.substring((featureType.getName() + "/").length()));
                continue block1;
            }
            for (j = 0; j < query.getAliases().size(); ++j) {
                String alias = query.getAliases().get(j);
                if (!propName.startsWith(alias + "/")) continue;
                ((List)propNames.get(j)).add(propName.substring((alias + "/").length()));
                continue block1;
            }
            ((List)propNames.get(0)).add(propName);
        }
        return propNames;
    }

    void validateSortBy(List<SortBy> sortBys, FeatureTypeInfo meta, GetFeatureRequest request) throws IOException {
        FeatureType featureType = meta.getFeatureType();
        for (SortBy sortBy : sortBys) {
            PropertyName name = sortBy.getPropertyName();
            if (name.evaluate((Object)featureType) != null) continue;
            throw new WFSException((RequestObject)request, "Illegal property name: " + name.getPropertyName() + " for feature type " + meta.prefixedName(), "InvalidParameterValue");
        }
    }

    void validateFilter(Filter filter, Query query, final FeatureTypeInfo meta, final GetFeatureRequest request) throws IOException {
        final FeatureType featureType = meta.getFeatureType();
        AbstractExpressionVisitor visitor = new AbstractExpressionVisitor(){

            public Object visit(PropertyName name, Object data) {
                if (name.evaluate((Object)featureType) == null && !GetFeature.this.isGmlBoundedBy(name)) {
                    throw new WFSException((RequestObject)request, "Illegal property name: " + name.getPropertyName() + " for feature type " + meta.prefixedName(), "InvalidParameterValue");
                }
                return name;
            }
        };
        filter.accept((FilterVisitor)new AbstractFilterVisitor((ExpressionVisitor)visitor), null);
        AbstractFilterVisitor fvisitor = new AbstractFilterVisitor(){

            protected Object visit(BinarySpatialOperator filter, Object data) {
                AttributeDescriptor att;
                PropertyName name = null;
                if (filter.getExpression1() instanceof PropertyName) {
                    name = (PropertyName)filter.getExpression1();
                } else if (filter.getExpression2() instanceof PropertyName) {
                    name = (PropertyName)filter.getExpression2();
                }
                if (name != null && !((att = (AttributeDescriptor)name.evaluate((Object)featureType)) instanceof GeometryDescriptor) && !GetFeature.this.isGmlBoundedBy(name)) {
                    throw new WFSException((RequestObject)request, "Property " + String.valueOf(name) + " is not geometric in feature type " + meta.prefixedName(), "InvalidParameterValue");
                }
                return filter;
            }
        };
        filter.accept((FilterVisitor)fvisitor, null);
        if (this.wfs.isCiteCompliant() && query.getSrsName() != null) {
            Query fquery = query;
            fvisitor = new CiteBBOXValidator(fquery, request);
            filter.accept((FilterVisitor)fvisitor, null);
        }
        if (this.wfs.isCiteCompliant()) {
            fvisitor = new AbstractFilterVisitor(){

                protected Object visit(BinaryComparisonOperator filter, Object data) {
                    PropertyName name;
                    Expression ex1 = filter.getExpression1();
                    Expression ex2 = filter.getExpression2();
                    if (ex1 instanceof PropertyName) {
                        name = (PropertyName)ex1;
                        this.checkNonSpatial(name);
                    }
                    if (ex2 instanceof PropertyName) {
                        name = (PropertyName)ex2;
                        this.checkNonSpatial(name);
                    }
                    return super.visit(filter, data);
                }

                private void checkNonSpatial(PropertyName pn) {
                    AttributeDescriptor ad = (AttributeDescriptor)pn.evaluate((Object)featureType);
                    if (ad instanceof GeometryDescriptor || GetFeature.this.isGmlBoundedBy(pn)) {
                        throw new WFSException((RequestObject)request, "Cannot use a spatial property in a alphanumeric binary comparison");
                    }
                }
            };
            filter.accept((FilterVisitor)fvisitor, null);
        }
    }

    boolean isGmlBoundedBy(PropertyName name) {
        String propertyName = name.getPropertyName();
        int idx = propertyName.indexOf(58);
        if (idx > 1 && propertyName.indexOf(":") < propertyName.length() - 1) {
            String[] split = propertyName.split("\\:");
            String prefix = split[0];
            String localName = split[1];
            if (!"boundedBy".equals(localName)) {
                return false;
            }
            if (name.getNamespaceContext() == null && "gml".equals(prefix)) {
                return true;
            }
            String ns = name.getNamespaceContext().getURI(prefix);
            return ns == null && "gml".equals(prefix) || "http://www.opengis.net/gml".equals(ns) || "http://www.opengis.net/gml/3.2".equals(ns);
        }
        return false;
    }

    int maxFeatures(List<FeatureTypeInfo> metas) {
        int maxFeatures = Integer.MAX_VALUE;
        for (FeatureTypeInfo meta : metas) {
            if (meta.getMaxFeatures() <= 0) continue;
            maxFeatures = Math.min(maxFeatures, meta.getMaxFeatures());
        }
        return maxFeatures;
    }

    protected PropertyName createPropertyName(String path, NamespaceSupport namespaceContext) {
        if (path.contains("/")) {
            return this.filterFactory.property(path, namespaceContext);
        }
        if (path.contains(":")) {
            int i = path.indexOf(":");
            return this.filterFactory.property((Name)new NameImpl(namespaceContext.getURI(path.substring(0, i)), path.substring(i + 1)));
        }
        return this.filterFactory.property(path);
    }

    protected List<PropertyName> addGeometryProperties(FeatureTypeInfo meta, List<PropertyName> oldProperties) throws IOException {
        List atts = meta.attributes();
        Iterator ii = atts.iterator();
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>(oldProperties);
        while (ii.hasNext()) {
            AttributeTypeInfo ati = (AttributeTypeInfo)ii.next();
            PropertyName propName = this.filterFactory.property(ati.getName());
            if (!(meta.getFeatureType().getDescriptor(ati.getName()) instanceof GeometryDescriptor) || properties.contains(propName)) continue;
            properties.add(propName);
        }
        return properties;
    }

    private Filter buildFilterCRSFromInfo(Filter filter, QName primaryTypeName, FeatureSource<? extends FeatureType, ? extends Feature> source, String wfsVersion) {
        FeatureTypeInfo featureTypeInfo = this.catalog.getFeatureTypeByName(primaryTypeName.getPrefix(), primaryTypeName.getLocalPart());
        if (featureTypeInfo != null && featureTypeInfo.getCRS() != null) {
            return WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), WFSReprojectionUtil.getDeclaredCrs(featureTypeInfo.getCRS(), wfsVersion), featureTypeInfo.getCRS());
        }
        return filter;
    }

    static {
        joinFilterCapabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        joinFilterCapabilities.addType(PropertyIsNull.class);
        joinFilterCapabilities.addType(PropertyIsBetween.class);
        joinFilterCapabilities.addType(Id.class);
        joinFilterCapabilities.addType(IncludeFilter.class);
        joinFilterCapabilities.addType(ExcludeFilter.class);
        joinFilterCapabilities.addType(PropertyIsLike.class);
        joinFilterCapabilities.addType(BBOX.class);
        joinFilterCapabilities.addType(Contains.class);
        joinFilterCapabilities.addType(Crosses.class);
        joinFilterCapabilities.addType(Disjoint.class);
        joinFilterCapabilities.addType(Equals.class);
        joinFilterCapabilities.addType(Intersects.class);
        joinFilterCapabilities.addType(Overlaps.class);
        joinFilterCapabilities.addType(Touches.class);
        joinFilterCapabilities.addType(Within.class);
        joinFilterCapabilities.addType(DWithin.class);
        joinFilterCapabilities.addType(Beyond.class);
        joinFilterCapabilities.addType(After.class);
        joinFilterCapabilities.addType(Before.class);
        joinFilterCapabilities.addType(Begins.class);
        joinFilterCapabilities.addType(BegunBy.class);
        joinFilterCapabilities.addType(During.class);
        joinFilterCapabilities.addType(Ends.class);
        joinFilterCapabilities.addType(EndedBy.class);
        joinFilterCapabilities.addType(TContains.class);
        joinFilterCapabilities.addType(TEquals.class);
        joinFilterCapabilities.addType(And.class);
        joinFilterCapabilities.addType(Or.class);
        joinFilterCapabilities.addType(Not.class);
    }

    private class BoundedByVisitor
    extends DuplicatingFilterVisitor {
        public BoundedByVisitor() {
            super(GetFeature.this.filterFactory);
        }

        public Object visit(PropertyName expression, Object extraData) {
            if (GetFeature.this.isGmlBoundedBy(expression)) {
                return GetFeature.this.filterFactory.function("boundedBy", new Expression[]{GetFeature.this.filterFactory.property("")});
            }
            return super.visit(expression, extraData);
        }

        public Object visit(BBOX filter, Object extraData) {
            PropertyName name;
            Expression expression1 = filter.getExpression1();
            if (expression1 instanceof PropertyName && GetFeature.this.isGmlBoundedBy(name = (PropertyName)expression1)) {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference((Bounds)filter.getBounds());
                Polygon polygon = JTS.toGeometry((ReferencedEnvelope)bounds);
                Function boundedBy = GetFeature.this.filterFactory.function("boundedBy", new Expression[]{GetFeature.this.filterFactory.property("")});
                return GetFeature.this.filterFactory.intersects((Expression)boundedBy, (Expression)GetFeature.this.filterFactory.literal((Object)polygon));
            }
            return super.visit(filter, extraData);
        }
    }

    private static class CiteBBOXValidator
    extends AbstractFilterVisitor {
        private final Query fquery;
        private final GetFeatureRequest request;

        public CiteBBOXValidator(Query fquery, GetFeatureRequest request) {
            this.fquery = fquery;
            this.request = request;
        }

        public Object visit(BBOX filter, Object data) {
            ReferencedEnvelope ex2Envelope = (ReferencedEnvelope)filter.getExpression2().evaluate(null, ReferencedEnvelope.class);
            try {
                CoordinateReferenceSystem queryCrs = CRS.decode((String)this.fquery.getSrsName().toString());
                if (ex2Envelope != null && ex2Envelope.getCoordinateReferenceSystem() != null && !queryCrs.equals(ex2Envelope.getCoordinateReferenceSystem())) {
                    DefaultGeographicCRS geo = DefaultGeographicCRS.WGS84;
                    GeneralBounds e = new GeneralBounds((Bounds)filter.getBounds());
                    e = CRS.transform((Bounds)e, (CoordinateReferenceSystem)geo);
                    CoordinateReferenceSystem crs = queryCrs;
                    GeographicBoundingBox valid = (GeographicBoundingBox)crs.getDomainOfValidity().getGeographicElements().iterator().next();
                    if (e.getMinimum(0) < valid.getWestBoundLongitude() || e.getMinimum(0) > valid.getEastBoundLongitude() || e.getMaximum(0) < valid.getWestBoundLongitude() || e.getMaximum(0) > valid.getEastBoundLongitude() || e.getMinimum(1) < valid.getSouthBoundLatitude() || e.getMinimum(1) > valid.getNorthBoundLatitude() || e.getMaximum(1) < valid.getSouthBoundLatitude() || e.getMaximum(1) > valid.getNorthBoundLatitude()) {
                        throw new WFSException((RequestObject)this.request, "bounding box out of valid range of crs", "InvalidParameterValue");
                    }
                }
            }
            catch (Exception e) {
                throw new WFSException((RequestObject)this.request, (Throwable)e);
            }
            return data;
        }
    }
}

