/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class InsertElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private FilterFactory filterFactory;

    public InsertElementHandler(GeoServer gs, FilterFactory filterFactory) {
        super(gs);
        this.filterFactory = filterFactory;
    }

    @Override
    public void checkValidity(TransactionElement element, Map<QName, FeatureTypeInfo> featureTypeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
            throw new WFSException((RequestObject)element, "Transaction INSERT support is not enabled");
        }
    }

    public void execute(TransactionElement element, TransactionRequest request, Map featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        List featureList;
        Insert insert = (Insert)element;
        LOGGER.finer("Transaction Insert:" + String.valueOf(insert));
        long inserted = response.getTotalInserted().longValue();
        try {
            SimpleFeatureType schema;
            LinkedHashMap<SimpleFeatureType, ListFeatureCollection> schema2features = new LinkedHashMap<SimpleFeatureType, ListFeatureCollection>();
            featureList = insert.getFeatures();
            for (Object item : featureList) {
                SimpleFeature feature = (SimpleFeature)item;
                SimpleFeatureType schema2 = feature.getFeatureType();
                ListFeatureCollection collection = (ListFeatureCollection)((HashMap)schema2features).get(schema2);
                if (collection == null) {
                    collection = new ListFeatureCollection(schema2);
                    schema2features.put(schema2, collection);
                }
                if (insert.isIdGenUseExisting()) {
                    feature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                } else {
                    Object identifier = feature.getAttribute((Name)new NameImpl("http://www.opengis.net/gml/3.2", "identifier"));
                    if (WFSInfo.Version.V_20.compareTo(insert.getVersion()) >= 0 && identifier instanceof String) {
                        String string = (String)identifier;
                        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(feature.getFeatureType());
                        fb.init(feature);
                        feature = fb.buildFeature(string);
                        feature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                    }
                }
                collection.add(feature);
            }
            HashMap schema2fids = new HashMap();
            for (Object value : ((HashMap)schema2features).values()) {
                CoordinateReferenceSystem target;
                GeometryDescriptor defaultGeometry;
                SimpleFeatureCollection collection = (SimpleFeatureCollection)value;
                schema = (SimpleFeatureType)collection.getSchema();
                QName elementName = new QName(schema.getName().getNamespaceURI(), schema.getTypeName());
                SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.get(elementName)));
                if (store == null) {
                    throw new WFSException((RequestObject)request, "Could not locate FeatureStore for '" + String.valueOf(elementName) + "'");
                }
                if (collection == null) continue;
                if (this.getInfo().isCiteCompliant()) {
                    this.checkFeatureCoordinatesRange(collection);
                }
                if ((defaultGeometry = ((SimpleFeatureType)store.getSchema()).getGeometryDescriptor()) != null && (target = defaultGeometry.getCoordinateReferenceSystem()) != null) {
                    collection = new ReprojectingFeatureCollection(collection, target);
                }
                LOGGER.finer("Use featureValidation to check contents of insert");
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                if (fids == null) {
                    fids = new LinkedList();
                    schema2fids.put(schema.getTypeName(), fids);
                }
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_INSERT, request, elementName, collection);
                event.setSource(Insert.WFS11.unadapt(insert));
                listener.dataStoreChange(event);
                fids.addAll(store.addFeatures((FeatureCollection)collection));
                SimpleFeatureCollection features = store.getFeatures((Filter)this.filterFactory.id(new HashSet(fids)));
                event = new TransactionEvent(TransactionEventType.POST_INSERT, request, elementName, features, Insert.WFS11.unadapt(insert));
                listener.dataStoreChange(event);
            }
            for (Object o : featureList) {
                SimpleFeature feature = (SimpleFeature)o;
                schema = feature.getFeatureType();
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                FeatureId fid = (FeatureId)fids.removeFirst();
                response.addInsertedFeature(insert.getHandle(), fid);
            }
        }
        catch (Exception e) {
            throw this.exceptionFactory.newWFSTransactionException("Insert error: " + e.getMessage(), e, insert.getHandle());
        }
        response.setTotalInserted(BigInteger.valueOf(inserted += (long)featureList.size()));
    }

    void checkFeatureCoordinatesRange(SimpleFeatureCollection collection) throws PointOutsideEnvelopeException {
        List types = ((SimpleFeatureType)collection.getSchema()).getAttributeDescriptors();
        try (SimpleFeatureIterator fi = collection.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                for (int i = 0; i < types.size(); ++i) {
                    Geometry geom;
                    GeometryDescriptor gat;
                    if (!(types.get(i) instanceof GeometryDescriptor) || (gat = (GeometryDescriptor)types.get(i)).getCoordinateReferenceSystem() == null || (geom = (Geometry)f.getAttribute(i)) == null) continue;
                    JTS.checkCoordinatesRange((Geometry)geom, (CoordinateReferenceSystem)gat.getCoordinateReferenceSystem());
                }
            }
        }
    }

    public Class<Insert> getElementClass() {
        return Insert.class;
    }

    @Override
    public QName[] getTypeNames(TransactionRequest request, TransactionElement element) throws WFSTransactionException {
        Insert insert = (Insert)element;
        ArrayList<QName> typeNames = new ArrayList<QName>();
        List features = insert.getFeatures();
        if (!features.isEmpty()) {
            for (Object next : features) {
                if (!(next instanceof SimpleFeature)) {
                    String version = request.getVersion();
                    String code = version == null || new Version(version).compareTo(WFSInfo.Version.V_20.getVersion()) >= 0 ? "InvalidValue" : "InvalidParameterValue";
                    throw new WFSException((RequestObject)request, "Could not parse input features", code);
                }
                SimpleFeature feature = (SimpleFeature)next;
                String name = feature.getFeatureType().getTypeName();
                String namespaceURI = feature.getFeatureType().getName().getNamespaceURI();
                typeNames.add(new QName(namespaceURI, name));
            }
        } else {
            LOGGER.finer("Insert was empty - does not need a FeatureSource");
        }
        return typeNames.toArray(new QName[typeNames.size()]);
    }
}

