/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs20.LockFeatureType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.LockFeatureResponse;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.InProcessLockingManager;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;

public class LockFeature {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    WFSInfo wfs;
    Catalog catalog;
    FilterFactory filterFactory;

    public LockFeature(WFSInfo wfs, Catalog catalog) {
        this(wfs, catalog, null);
    }

    public LockFeature(WFSInfo wfs, Catalog catalog, FilterFactory filterFactory) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.filterFactory = filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockFeatureResponse lockFeature(LockFeatureRequest request) throws WFSException {
        FeatureLock fLock = null;
        try {
            List<Lock> locks = request.getLocks();
            if (locks == null || locks.isEmpty()) {
                String msg = "A LockFeature request must contain at least one LOCK element";
                throw new WFSException((RequestObject)request, msg);
            }
            LOGGER.info("locks size is " + locks.size());
            fLock = this.newFeatureLock(request);
            LockFeatureResponse response = request.createResponse();
            response.setLockId(fLock.getAuthorization());
            for (Lock lock : locks) {
                FeatureCollection features;
                FeatureSource source;
                FeatureTypeInfo meta;
                LOGGER.info("curLock is " + String.valueOf(lock));
                QName typeName = lock.getTypeName();
                Filter filter = lock.getFilter();
                if (filter == null) {
                    filter = Filter.INCLUDE;
                }
                try {
                    meta = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
                    if (meta == null) {
                        throw new WFSException((RequestObject)request, "Unknown feature type " + typeName.getPrefix() + ":" + typeName.getLocalPart());
                    }
                    source = meta.getFeatureSource(null, null);
                    CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(source.getSchema(), request.getVersion());
                    filter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
                    features = source.getFeatures(filter);
                    if (source instanceof FeatureLocking) {
                        FeatureLocking locking = (FeatureLocking)source;
                        locking.setFeatureLock(fLock);
                    }
                }
                catch (IOException e) {
                    throw new WFSException((RequestObject)request, (Throwable)e);
                }
                int numberLocked = -1;
                try (FeatureIterator fi = features.features();){
                    while (fi.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)fi.next();
                        FeatureId fid = this.fid(feature.getID());
                        Id fidFilter = this.fidFilter(fid);
                        if (!(source instanceof FeatureLocking)) {
                            LOGGER.fine("Lock " + String.valueOf(fid) + " not supported by data store (authID:" + fLock.getAuthorization() + ")");
                            response.addNotLockedFeature(fid);
                            continue;
                        }
                        Query query = new Query(meta.getName(), (Filter)fidFilter, Integer.MAX_VALUE, Query.ALL_NAMES, lock.getHandle());
                        numberLocked = ((FeatureLocking)source).lockFeatures(query);
                        if (numberLocked == 1) {
                            LOGGER.fine("Lock " + String.valueOf(fid) + " (authID:" + fLock.getAuthorization() + ")");
                            response.addLockedFeature(fid);
                            continue;
                        }
                        if (numberLocked == 0) {
                            LOGGER.fine("Lock " + String.valueOf(fid) + " conflict (authID:" + fLock.getAuthorization() + ")");
                            response.addNotLockedFeature(fid);
                            continue;
                        }
                        LOGGER.warning("Lock " + numberLocked + " " + String.valueOf(fid) + " (authID:" + fLock.getAuthorization() + ") duplicated FeatureID!");
                        response.addLockedFeature(fid);
                    }
                }
                catch (IOException ioe) {
                    throw new WFSException((RequestObject)request, (Throwable)ioe);
                }
                if (numberLocked <= 0) continue;
                try (DefaultTransaction t = new DefaultTransaction();){
                    try {
                        t.addAuthorization(fLock.getAuthorization());
                        DataStore dataStore = (DataStore)source.getDataStore();
                        dataStore.getLockingManager().refresh(fLock.getAuthorization(), (Transaction)t);
                    }
                    finally {
                        t.commit();
                    }
                }
                catch (IOException e) {
                    throw new WFSException((RequestObject)request, (Throwable)e);
                }
            }
            boolean lockAll = !request.isLockActionSome();
            List<FeatureId> notLocked = response.getNotLockedFeatures();
            if (lockAll && notLocked != null && !notLocked.isEmpty()) {
                throw new WFSException((RequestObject)request, "Could not acquire locks for:" + String.valueOf(notLocked), "CannotLockAllFeatures");
            }
            return response;
        }
        catch (WFSException e) {
            if (fLock != null) {
                try {
                    this.release(fLock.getAuthorization());
                }
                catch (WFSException e1) {
                    LOGGER.log(Level.SEVERE, "Error occured releasing locks", (Throwable)((Object)e1));
                }
            }
            throw e;
        }
    }

    public void release(String lockId) throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (Object store : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStoreInfo meta = (DataStoreInfo)store;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    DataStore dataStore1;
                    dataStore = dataStore1 = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                try (DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());){
                    t.addAuthorization(lockId);
                    lockingManager.release(lockId, (Transaction)t);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public void releaseAll() throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (Object store : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStoreInfo meta = (DataStoreInfo)store;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    DataStore dataStore1;
                    dataStore = dataStore1 = (DataStore)da;
                }
                if (dataStore != null && (lockingManager = dataStore.getLockingManager()) != null) continue;
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public boolean exists(String lockId) throws WFSException {
        try {
            List dataStores = this.catalog.getDataStores();
            for (Object store : dataStores) {
                LockingManager lockingManager;
                DataAccess da;
                DataStoreInfo meta = (DataStoreInfo)store;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    DataStore dataStore1;
                    dataStore = dataStore1 = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null || !lockingManager.exists(lockId)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
    }

    public void refresh(String lockId, boolean throwOnRefreshFail) throws WFSException {
        boolean refresh = false;
        boolean lockFound = false;
        try {
            List dataStores = this.catalog.getDataStores();
            for (Object store : dataStores) {
                InProcessLockingManager ip;
                Set locks;
                LockingManager lockingManager;
                DataAccess da;
                DataStoreInfo meta = (DataStoreInfo)store;
                DataStore dataStore = null;
                if (meta.isEnabled() && (da = meta.getDataStore(null)) instanceof DataStore) {
                    DataStore dataStore1;
                    dataStore = dataStore1 = (DataStore)da;
                }
                if (dataStore == null || (lockingManager = dataStore.getLockingManager()) == null) continue;
                if (lockingManager instanceof InProcessLockingManager && (locks = (ip = (InProcessLockingManager)lockingManager).allLocks()) != null) {
                    lockFound |= locks.stream().anyMatch(l -> l.isMatch(lockId));
                }
                try (DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getWorkspace().getName());){
                    t.addAuthorization(lockId);
                    if (!lockingManager.refresh(lockId, (Transaction)t)) continue;
                    refresh = true;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            throw new WFSException(e);
        }
        if (!refresh && throwOnRefreshFail) {
            if (!lockFound) {
                throw new ServiceException("Unknown lock id", "InvalidLockId", "lockId");
            }
            throw new ServiceException("Lock has expired", "LockHasExpired", "lockId");
        }
    }

    private FeatureId fid(String fid) {
        return this.filterFactory.featureId(fid);
    }

    private Id fidFilter(FeatureId fid) {
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(fid);
        return this.filterFactory.id(ids);
    }

    protected FeatureLock newFeatureLock(LockFeatureRequest request) {
        int lockExpiry;
        BigInteger expiry;
        String handle = request.getHandle();
        if (handle == null || handle.equals("")) {
            handle = "GeoServer";
            request.setHandle(handle);
        }
        if ((expiry = request.getExpiry()) == null) {
            expiry = BigInteger.valueOf(0L);
            request.setExpiry(expiry);
        }
        if ((lockExpiry = expiry.intValue()) < 0) {
            return new FeatureLock(handle, (long)lockExpiry);
        }
        if (lockExpiry == 0) {
            return new FeatureLock(handle, 0L);
        }
        if (request.getAdaptee() instanceof LockFeatureType) {
            return new FeatureLock(handle, (long)(lockExpiry * 1000));
        }
        return new FeatureLock(handle, (long)(lockExpiry * 60 * 1000));
    }
}

