/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Property;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geoserver.wfs.request.Update;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.FeatureStore;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.Converters;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class UpdateElementHandler
extends AbstractTransactionElementHandler {
    static final Map<String, Class<?>> GML_PROPERTIES_BINDINGS = Map.ofEntries(Map.entry("name", String.class), Map.entry("description", String.class), Map.entry("boundedBy", Geometry.class), Map.entry("location", Geometry.class), Map.entry("metaDataProperty", String.class));
    static final Set<String> GML_NAMESPACES = Set.of("http://www.opengis.net/gml", "http://www.opengis.net/gml/3.2");
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public UpdateElementHandler(GeoServer gs) {
        super(gs);
    }

    @Override
    public void checkValidity(TransactionElement element, Map<QName, FeatureTypeInfo> typeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_UPDATE)) {
            throw new WFSException((RequestObject)element, "Transaction Update support is not enabled");
        }
        Update update = (Update)element;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        try {
            FeatureTypeInfo meta = typeInfos.values().iterator().next();
            FeatureType featureType = meta.getFeatureType();
            List<Property> props = update.getUpdateProperties();
            for (Property property : props) {
                String msg;
                if (property.getValue() == null) {
                    String propertyName = property.getName().getLocalPart();
                    AttributeDescriptor attributeType = null;
                    PropertyDescriptor pd = featureType.getDescriptor(propertyName);
                    if (pd instanceof AttributeDescriptor) {
                        AttributeDescriptor descriptor;
                        attributeType = descriptor = (AttributeDescriptor)pd;
                    }
                    if (attributeType != null && attributeType.getMinOccurs() > 0) {
                        msg = "Property '" + attributeType.getLocalName() + "' is mandatory but no value specified.";
                        throw new WFSException((RequestObject)element, msg, "MissingParameterValue");
                    }
                }
                QName name = property.getName();
                PropertyName propertyName = null;
                propertyName = name.getPrefix() != null && !"".equals(name.getPrefix()) ? ff.property(name.getPrefix() + ":" + name.getLocalPart()) : ff.property(name.getLocalPart());
                AttributeDescriptor descriptor = (AttributeDescriptor)propertyName.evaluate((Object)featureType, AttributeDescriptor.class);
                if (descriptor == null) {
                    if (this.getInfo().isCiteCompliant()) {
                        String namespace = name.getNamespaceURI();
                        Class<?> binding = GML_PROPERTIES_BINDINGS.get(name.getLocalPart());
                        if (GML_NAMESPACES.contains(namespace) && binding != null) {
                            this.validateValue(element, property, binding);
                        }
                    }
                    msg = "No such property: " + String.valueOf(name);
                    throw new WFSException((RequestObject)element, msg, "InvalidParameterValue");
                }
                this.validateValue(element, property, descriptor.getType().getBinding());
            }
        }
        catch (IOException e) {
            throw new WFSTransactionException("Could not locate feature type information for " + String.valueOf(update.getTypeName()), (Throwable)e, update.getHandle());
        }
    }

    private void validateValue(TransactionElement element, Property property, Class<?> binding) {
        String propertyName;
        Geometry geometry;
        Map map;
        String string;
        Object value = property.getValue();
        if (value == null || value instanceof String && (string = (String)value).trim().isEmpty() || value instanceof Map && (map = (Map)value).isEmpty()) {
            return;
        }
        if (value != null && value instanceof Geometry && !UpdateElementHandler.checkConsistentGeometryDimensions(geometry = (Geometry)value, binding)) {
            propertyName = property.getName().getLocalPart();
            WFSException e = new WFSException((RequestObject)element, "Incorrect geometry dimension for property " + propertyName, "InvalidValue");
            e.setLocator(propertyName);
            throw e;
        }
        Object converted = Converters.convert((Object)value, binding);
        if (converted == null) {
            propertyName = property.getName().getLocalPart();
            WFSException e = new WFSException((RequestObject)element, "Invalid value for property " + propertyName, "InvalidValue");
            e.setLocator(propertyName);
            throw e;
        }
    }

    static boolean checkConsistentGeometryDimensions(Geometry value, Class<?> binding) {
        if (value == null || binding == Geometry.class || binding == GeometryCollection.class) {
            return true;
        }
        switch (value.getDimension()) {
            case 0: {
                return binding.isAssignableFrom(Point.class) || binding.isAssignableFrom(MultiPoint.class);
            }
            case 1: {
                return binding.isAssignableFrom(LineString.class) || binding.isAssignableFrom(MultiLineString.class);
            }
            case 2: {
                return binding.isAssignableFrom(Polygon.class) || binding.isAssignableFrom(MultiPolygon.class);
            }
        }
        return false;
    }

    @Override
    public void execute(TransactionElement element, TransactionRequest request, Map<QName, FeatureStore> featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        HashSet<FeatureId> fids;
        block37: {
            Update update = (Update)element;
            QName elementName = update.getTypeName();
            String handle = update.getHandle();
            long updated = response.getTotalUpdated().longValue();
            String msg = "Could not locate FeatureStore for '" + String.valueOf(elementName) + "'";
            if (!featureStores.containsKey(elementName)) {
                throw new WFSTransactionException(msg, "InvalidParameterValue", element.getHandle());
            }
            SimpleFeatureStore store = DataUtilities.simple((FeatureStore)featureStores.get(elementName));
            if (store == null) {
                throw new WFSTransactionException(msg, "InvalidParameterValue", element.getHandle());
            }
            LOGGER.finer("Transaction Update:" + String.valueOf(update));
            try {
                Object filter = update.getFilter();
                CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(store.getSchema(), request.getVersion());
                filter = filter != null ? WFSReprojectionUtil.normalizeFilterCRS(filter, store.getSchema(), declaredCRS) : Filter.INCLUDE;
                List<Property> properties = update.getUpdateProperties();
                AttributeDescriptor[] types = new AttributeDescriptor[properties.size()];
                String[] names = new String[properties.size()];
                Object[] values = new Object[properties.size()];
                if (properties.isEmpty()) {
                    return;
                }
                for (int j = 0; j < properties.size(); ++j) {
                    Property property = properties.get(j);
                    QName propertyName = property.getName();
                    names[j] = this.cleanupXPath(propertyName.getLocalPart());
                    types[j] = ((SimpleFeatureType)store.getSchema()).getDescriptor(names[j]);
                    values[j] = property.getValue();
                    Object object = values[j];
                    if (!(object instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)object;
                    CoordinateReferenceSystem source = null;
                    if (geometry.getUserData() instanceof CoordinateReferenceSystem) {
                        source = (CoordinateReferenceSystem)geometry.getUserData();
                    } else {
                        geometry.setUserData((Object)declaredCRS);
                        source = declaredCRS;
                    }
                    CoordinateReferenceSystem target = null;
                    AttributeDescriptor attributeDescriptor = types[j];
                    if (attributeDescriptor instanceof GeometryDescriptor) {
                        GeometryDescriptor descriptor = (GeometryDescriptor)attributeDescriptor;
                        target = descriptor.getCoordinateReferenceSystem();
                    }
                    if (this.getInfo().isCiteCompliant()) {
                        JTS.checkCoordinatesRange((Geometry)geometry, (CoordinateReferenceSystem)(source != null ? source : target));
                    }
                    if (source == null || target == null || CRS.equalsIgnoreMetadata((Object)source, (Object)target)) continue;
                    try {
                        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target, (boolean)true);
                        GeometryCoordinateSequenceTransformer gtx = new GeometryCoordinateSequenceTransformer();
                        gtx.setMathTransform(tx);
                        values[j] = gtx.transform(geometry);
                        continue;
                    }
                    catch (Exception e) {
                        String message = "Failed to reproject geometry:" + e.getLocalizedMessage();
                        throw new WFSTransactionException(message, (Throwable)e);
                    }
                }
                fids = new HashSet<FeatureId>();
                LOGGER.finer("Preprocess to remember modification as a set of fids");
                SimpleFeatureCollection features = store.getFeatures(filter);
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_UPDATE, request, elementName, features);
                event.setSource(Update.WFS11.unadapt(update));
                listener.dataStoreChange(event);
                try (SimpleFeatureIterator preprocess = features.features();){
                    while (preprocess.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)preprocess.next();
                        fids.add(feature.getIdentifier());
                    }
                }
                catch (NoSuchElementException e) {
                    throw new WFSException((RequestObject)request, "Could not aquire FeatureIDs", (Throwable)e);
                }
                try {
                    store.modifyFeatures(names, values, filter);
                }
                catch (Exception e) {
                    throw this.exceptionFactory.newWFSTransactionException("Update error: " + e.getMessage(), e, "InvalidParameterValue");
                }
                finally {
                    if (request.getLockId() != null && store instanceof FeatureLocking && request.isReleaseActionSome()) {
                        SimpleFeatureLocking locking = (SimpleFeatureLocking)store;
                        locking.unLockFeatures(filter);
                    }
                }
                if (fids.isEmpty()) break block37;
                LOGGER.finer("Post process update for boundary update and featureValidation");
                HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
                FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                for (FeatureId fid : fids) {
                    featureIds.add(ff.featureId(fid.getID()));
                }
                Id modified = ff.id(featureIds);
                SimpleFeatureCollection changed = store.getFeatures((Filter)modified);
                HashSet<FeatureId> changedIds = new HashSet<FeatureId>();
                try (SimpleFeatureIterator iterator = changed.features();){
                    while (iterator.hasNext()) {
                        changedIds.add(((SimpleFeature)iterator.next()).getIdentifier());
                    }
                }
                response.addUpdatedFeatures(handle, changedIds);
                listener.dataStoreChange(new TransactionEvent(TransactionEventType.POST_UPDATE, request, elementName, changed, Update.WFS11.unadapt(update)));
            }
            catch (IOException | PointOutsideEnvelopeException ioException) {
                throw new WFSTransactionException(ioException, null, handle);
            }
        }
        response.setTotalUpdated(BigInteger.valueOf(updated += (long)fids.size()));
    }

    private String cleanupXPath(String name) {
        if (name.endsWith("[1]")) {
            return name.substring(0, name.length() - 3);
        }
        return name;
    }

    public Class<Update> getElementClass() {
        return Update.class;
    }

    @Override
    public QName[] getTypeNames(TransactionRequest request, TransactionElement element) throws WFSTransactionException {
        return new QName[]{element.getTypeName()};
    }
}

