/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geotools.util.logging.Logging;

public final class WFSGMLMimeTypeEnforcer
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(WFSGMLMimeTypeEnforcer.class);
    private final GeoServer geoserver;

    public WFSGMLMimeTypeEnforcer(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        Service service = operation.getService();
        if (service == null || service.getId() == null || !service.getId().equalsIgnoreCase("wfs")) {
            return response;
        }
        String responseMimeType = response.getMimeType(result, operation);
        if (!this.isGmlBased(responseMimeType)) {
            return response;
        }
        WFSInfo wfs = (WFSInfo)this.geoserver.getService(WFSInfo.class);
        GMLInfo gmlInfo = wfs.getGML().get((Object)WFSInfo.Version.negotiate(service.getVersion().toString()));
        if (gmlInfo == null || gmlInfo.getMimeTypeToForce().isEmpty()) {
            return response;
        }
        String mimeType = gmlInfo.getMimeTypeToForce().get();
        LOGGER.info("Overriding MIME type '%s' with '%s' for WFS operation '%s'.".formatted(responseMimeType, mimeType, operation.getId()));
        return new ResponseWrapper(response, mimeType);
    }

    private boolean isGmlBased(String candidateMimeType) {
        if (candidateMimeType == null) {
            return false;
        }
        candidateMimeType = candidateMimeType.toLowerCase();
        return candidateMimeType.contains("gml");
    }

    private static final class ResponseWrapper
    extends Response {
        private final Response response;
        private final String mimeType;

        public ResponseWrapper(Response response, String mimeType) {
            super(response.getBinding(), mimeType);
            this.response = response;
            this.mimeType = mimeType;
        }

        public String getMimeType(Object value, Operation operation) throws ServiceException {
            return this.mimeType;
        }

        public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
            this.response.write(value, output, operation);
        }

        public boolean canHandle(Operation operation) {
            return this.response.canHandle(operation);
        }

        public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
            return this.response.getHeaders(value, operation);
        }

        public String getPreferredDisposition(Object value, Operation operation) {
            return this.response.getPreferredDisposition(value, operation);
        }

        public String getAttachmentFileName(Object value, Operation operation) {
            return this.response.getAttachmentFileName(value, operation);
        }

        public String getCharset(Operation operation) {
            return this.response.getCharset(operation);
        }
    }
}

