/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.TypeInfoCollectionWrapper;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.response.WFSResponse;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public abstract class WFSGetFeatureOutputFormat
extends WFSResponse {
    static final Pattern XML_ELEMENT = Pattern.compile("[:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\x10000-\\xEFFFF][:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\\\x10000-\\\\xEFFFF\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*\\Z");
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public WFSGetFeatureOutputFormat(GeoServer gs, String outputFormat) {
        super(gs, FeatureCollectionResponse.class, outputFormat);
    }

    public WFSGetFeatureOutputFormat(GeoServer gs, Set<String> outputFormats) {
        super(gs, FeatureCollectionResponse.class, outputFormats);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureRequest req;
        if (("GetFeature".equalsIgnoreCase(operation.getId()) || "GetFeatureWithLock".equalsIgnoreCase(operation.getId())) && (req = GetFeatureRequest.adapt(operation.getParameters()[0])).isResultTypeResults()) {
            return this.canHandleInternal(operation);
        }
        return false;
    }

    public String getCapabilitiesElementName() {
        String of;
        String string = of = this.getOutputFormats().isEmpty() ? null : (String)this.getOutputFormats().iterator().next();
        if (of == null) {
            return null;
        }
        if (XML_ELEMENT.matcher(of).matches()) {
            return of;
        }
        LOGGER.severe("ERROR IN " + String.valueOf(((Object)((Object)this)).getClass()) + " IMPLEMENTATION.  getCapabilitiesElementName() should return a valid XML element name string for use in the WFS 1.0.0 capabilities document.");
        String name = ((Object)((Object)this)).getClass().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public List<String> getCapabilitiesElementNames() {
        String name = this.getCapabilitiesElementName();
        if (name == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    protected List<String> getAllCapabilitiesElementNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.getOutputFormats()) {
            if (!XML_ELEMENT.matcher(name).matches()) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public boolean canHandle(Version version) {
        return true;
    }

    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        if (value instanceof FeatureCollectionResponse) {
            FeatureCollectionResponse response = (FeatureCollectionResponse)value;
            this.write(response, output, operation);
        } else {
            this.write(FeatureCollectionResponse.adapt(value), output, operation);
        }
    }

    private <T> T getFeatureTypeInfoProperty(Catalog catalog, FeatureCollection features, Function<FeatureTypeInfo, T> callback) {
        FeatureTypeInfo fti;
        ResourceInfo meta = null;
        if (features instanceof TypeInfoCollectionWrapper.Complex) {
            TypeInfoCollectionWrapper.Complex fcollection = (TypeInfoCollectionWrapper.Complex)features;
            fti = fcollection.getFeatureTypeInfo();
            meta = catalog.getResourceByName(fti.getName(), ResourceInfo.class);
        } else {
            FeatureType featureType = features.getSchema();
            meta = catalog.getResourceByName(featureType.getName(), ResourceInfo.class);
        }
        if (meta instanceof FeatureTypeInfo) {
            FeatureTypeInfo info;
            fti = info = (FeatureTypeInfo)meta;
            return callback.apply(fti);
        }
        return null;
    }

    protected int getNumDecimals(List featureCollections, GeoServer geoServer, Catalog catalog) {
        int numDecimals = -1;
        for (Object featureCollection : featureCollections) {
            Integer ftiDecimals = this.getFeatureTypeInfoProperty(catalog, (FeatureCollection)featureCollection, fti -> fti.getNumDecimals());
            if (ftiDecimals == null || ftiDecimals <= 0) continue;
            numDecimals = numDecimals == -1 ? ftiDecimals : Math.max(numDecimals, ftiDecimals);
        }
        SettingsInfo settings = geoServer.getSettings();
        if (numDecimals == -1) {
            numDecimals = settings.getNumDecimals();
        }
        return numDecimals;
    }

    protected boolean getPadWithZeros(List featureCollections, GeoServer geoServer, Catalog catalog) {
        boolean padWithZeros = false;
        for (Object featureCollection : featureCollections) {
            Boolean pad = this.getFeatureTypeInfoProperty(catalog, (FeatureCollection)featureCollection, fti -> fti.getPadWithZeros());
            if (!Boolean.TRUE.equals(pad)) continue;
            padWithZeros = true;
        }
        return padWithZeros;
    }

    protected boolean getForcedDecimal(List featureCollections, GeoServer geoServer, Catalog catalog) {
        boolean forcedDecimal = false;
        for (Object featureCollection : featureCollections) {
            Boolean forced = this.getFeatureTypeInfoProperty(catalog, (FeatureCollection)featureCollection, fti -> fti.getForcedDecimal());
            if (!Boolean.TRUE.equals(forced)) continue;
            forcedDecimal = true;
        }
        return forcedDecimal;
    }

    protected boolean encodeMeasures(List featureCollections, Catalog catalog) {
        boolean encodeMeasures = true;
        for (Object featureCollection : featureCollections) {
            Boolean measures = this.getFeatureTypeInfoProperty(catalog, (FeatureCollection)featureCollection, fti -> fti.getEncodeMeasures());
            if (!Boolean.FALSE.equals(measures)) continue;
            encodeMeasures = false;
        }
        return encodeMeasures;
    }

    protected abstract void write(FeatureCollectionResponse var1, OutputStream var2, Operation var3) throws IOException, ServiceException;

    public String getAttachmentFileName(Object value, Operation operation) {
        Query query;
        FeatureCollectionResponse collectionResponse;
        GetFeatureRequest request = GetFeatureRequest.adapt(operation.getParameters()[0]);
        FeatureCollectionResponse response = value instanceof FeatureCollectionResponse ? (collectionResponse = (FeatureCollectionResponse)value) : FeatureCollectionResponse.adapt(value);
        String fileName = request.getFormatOptions() != null && request.getFormatOptions().containsKey("FILENAME") ? (String)request.getFormatOptions().get("FILENAME") : (response.getTypeNames() != null ? response.getTypeNames().stream().map(tn -> tn.getLocalPart()).collect(Collectors.joining("_")) : (response.getTypeName() != null ? response.getTypeName().getLocalPart() : (!request.getQueries().isEmpty() && request.getQueries().get(0) != null ? ((query = request.getQueries().get(0)).getTypeNames() != null ? query.getTypeNames().stream().map(tn -> tn.getLocalPart()).collect(Collectors.joining("_")) : response.getTypeName().getLocalPart()) : "features")));
        if (fileName.contains(".")) {
            return fileName;
        }
        return fileName + "." + this.getExtension(response);
    }

    protected String getExtension(FeatureCollectionResponse response) {
        String mimeType = this.getMimeType(null, null);
        if (mimeType != null) {
            if (mimeType.contains("gml")) {
                return "xml";
            }
            if (mimeType.contains("json")) {
                return "json";
            }
            String[] typeParts = mimeType.split(";");
            return typeParts[0].split("/")[0];
        }
        return "bin";
    }
}

