/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.WfsFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.kvp.WFSKvpRequestReader;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.xml.sax.helpers.NamespaceSupport;

public class DescribeFeatureTypeKvpRequestReader
extends WFSKvpRequestReader {
    private final Catalog catalog;

    public DescribeFeatureTypeKvpRequestReader(Catalog catalog) {
        super(DescribeFeatureTypeType.class, (EFactory)WfsFactory.eINSTANCE);
        this.catalog = catalog;
    }

    public DescribeFeatureTypeKvpRequestReader(Catalog catalog, Class<?> requestBean, EFactory factory) {
        super(requestBean, factory);
        this.catalog = catalog;
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        DescribeFeatureTypeRequest req = DescribeFeatureTypeRequest.adapt(request = super.read(request, kvp, rawKvp));
        if (!req.isSetOutputFormat()) {
            switch (WFSInfo.Version.negotiate(req.getVersion())) {
                case V_10: {
                    req.setOutputFormat("XMLSCHEMA");
                    break;
                }
                case V_11: {
                    req.setOutputFormat("text/xml; subtype=gml/3.1.1");
                    break;
                }
                default: {
                    req.setOutputFormat("application/gml+xml; version=3.2");
                }
            }
        }
        if (req instanceof DescribeFeatureTypeRequest.WFS20 && kvp.containsKey("typenames")) {
            List typenames = (List)kvp.get("typenames");
            req.getTypeNames().clear();
            req.getTypeNames().addAll((Collection)typenames.get(0));
        }
        NamespaceSupport namespaces = null;
        if (kvp.containsKey("NAMESPACE") || kvp.containsKey("NAMESPACES")) {
            if (kvp.get("NAMESPACE") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespace");
            } else if (kvp.get("NAMESPACES") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespaces");
            } else {
                LOGGER.warning("There's a namespace parameter but it seems it wasn't parsed to a " + NamespaceSupport.class.getName() + ": " + String.valueOf(kvp.get("namespace")));
            }
        }
        if (namespaces != null) {
            List<QName> typeNames = req.getTypeNames();
            ArrayList<QName> newList = new ArrayList<QName>(typeNames.size());
            for (QName name : typeNames) {
                String localPart = name.getLocalPart();
                String prefix = name.getPrefix();
                if (StringUtils.isBlank((CharSequence)prefix)) {
                    prefix = namespaces.getPrefix(name.getNamespaceURI());
                }
                String namespaceURI = name.getNamespaceURI();
                if ("".equals(prefix)) {
                    namespaceURI = namespaces.getURI("");
                } else if ("".equals(namespaceURI) && namespaces.getURI(prefix) != null) {
                    namespaceURI = namespaces.getURI(prefix);
                }
                if (this.catalog.getNamespaceByURI(namespaceURI) != null) {
                    prefix = this.catalog.getNamespaceByURI(namespaceURI).getPrefix();
                }
                newList.add(new QName(namespaceURI, localPart, prefix));
            }
            req.setTypeNames(newList);
        }
        return request;
    }
}

