/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.FeatureCollectionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.feature.FeatureCollection;

public abstract class FeatureCollectionResponse
extends RequestObject {
    protected boolean getFeatureById = false;
    protected Supplier<BigInteger> lazyTotalNumberOfFeatures = null;

    public static FeatureCollectionResponse adapt(Object adaptee) {
        if (adaptee instanceof net.opengis.wfs.FeatureCollectionType) {
            net.opengis.wfs.FeatureCollectionType type = (net.opengis.wfs.FeatureCollectionType)adaptee;
            return new WFS11((EObject)type);
        }
        if (adaptee instanceof FeatureCollectionType) {
            FeatureCollectionType type = (FeatureCollectionType)adaptee;
            return new WFS20((EObject)type);
        }
        return null;
    }

    protected FeatureCollectionResponse(EObject adaptee) {
        super(adaptee);
    }

    public String getLockId() {
        return this.eGet(this.adaptee, "lockId", String.class);
    }

    public void setLockId(String lockId) {
        this.eSet(this.adaptee, "lockId", lockId);
    }

    public Calendar getTimeStamp() {
        return this.eGet(this.adaptee, "timeStamp", Calendar.class);
    }

    public void setTimeStamp(Calendar timeStamp) {
        this.eSet(this.adaptee, "timeStamp", timeStamp);
    }

    public abstract FeatureCollectionResponse create();

    public abstract BigInteger getNumberOfFeatures();

    public abstract void setNumberOfFeatures(BigInteger var1);

    public void setLazyTotalNumberOfFeatures(Supplier<BigInteger> totalNumberOfFeatures) {
        this.lazyTotalNumberOfFeatures = totalNumberOfFeatures;
    }

    public BigInteger getTotalNumberOfFeatures() {
        if (this.lazyTotalNumberOfFeatures != null) {
            return this.lazyTotalNumberOfFeatures.get();
        }
        return null;
    }

    public void setTotalNumberOfFeatures(BigInteger totalHits) {
        this.lazyTotalNumberOfFeatures = () -> totalHits;
    }

    public abstract void setPrevious(String var1);

    public abstract String getPrevious();

    public abstract void setNext(String var1);

    public abstract String getNext();

    public abstract List<FeatureCollection> getFeatures();

    public abstract void setFeatures(List<FeatureCollection> var1);

    public abstract Object unadapt(Class<?> var1);

    public List<FeatureCollection> getFeature() {
        return this.getFeatures();
    }

    public void setGetFeatureById(boolean getFeatureById) {
        this.getFeatureById = getFeatureById;
    }

    public boolean isGetFeatureById() {
        return this.getFeatureById;
    }

    public static class WFS11
    extends FeatureCollectionResponse {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public FeatureCollectionResponse create() {
            return FeatureCollectionResponse.adapt(((WfsFactory)this.getFactory()).createFeatureCollectionType());
        }

        @Override
        public BigInteger getNumberOfFeatures() {
            return this.eGet(this.adaptee, "numberOfFeatures", BigInteger.class);
        }

        @Override
        public void setNumberOfFeatures(BigInteger n) {
            this.eSet(this.adaptee, "numberOfFeatures", n);
        }

        @Override
        public String getPrevious() {
            return null;
        }

        @Override
        public void setPrevious(String previous) {
        }

        @Override
        public String getNext() {
            return null;
        }

        @Override
        public void setNext(String next) {
        }

        @Override
        public List<FeatureCollection> getFeatures() {
            return this.eGet(this.adaptee, "feature", List.class);
        }

        @Override
        public void setFeatures(List<FeatureCollection> features) {
            this.eSet(this.adaptee, "feature", features);
        }

        @Override
        public Object unadapt(Class<?> target) {
            if (target.equals(net.opengis.wfs.FeatureCollectionType.class)) {
                return this.adaptee;
            }
            if (target.equals(FeatureCollectionType.class)) {
                net.opengis.wfs.FeatureCollectionType source = (net.opengis.wfs.FeatureCollectionType)this.adaptee;
                FeatureCollectionType result = Wfs20Factory.eINSTANCE.createFeatureCollectionType();
                result.getMember().addAll((Collection)source.getFeature());
                result.setNumberReturned(source.getNumberOfFeatures());
                result.setLockId(source.getLockId());
                result.setTimeStamp(source.getTimeStamp());
                return result;
            }
            throw new WFSException("Cannot transform " + String.valueOf(this.adaptee) + " to the specified target class " + String.valueOf(target));
        }
    }

    public static class WFS20
    extends FeatureCollectionResponse {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public FeatureCollectionResponse create() {
            return FeatureCollectionResponse.adapt(((Wfs20Factory)this.getFactory()).createFeatureCollectionType());
        }

        @Override
        public BigInteger getNumberOfFeatures() {
            return this.eGet(this.adaptee, "numberReturned", BigInteger.class);
        }

        @Override
        public void setNumberOfFeatures(BigInteger n) {
            this.eSet(this.adaptee, "numberReturned", n);
        }

        @Override
        public BigInteger getTotalNumberOfFeatures() {
            if (this.lazyTotalNumberOfFeatures != null) {
                return (BigInteger)this.lazyTotalNumberOfFeatures.get();
            }
            BigInteger result = this.eGet(this.adaptee, "numberMatched", BigInteger.class);
            if (result != null && result.signum() < 0) {
                return null;
            }
            return result;
        }

        @Override
        public void setTotalNumberOfFeatures(BigInteger n) {
            this.eSet(this.adaptee, "numberMatched", n);
            this.lazyTotalNumberOfFeatures = () -> {
                BigInteger result = this.eGet(this.adaptee, "numberMatched", BigInteger.class);
                if (result != null && result.signum() < 0) {
                    return null;
                }
                return result;
            };
        }

        @Override
        public String getPrevious() {
            return this.eGet(this.adaptee, "previous", String.class);
        }

        @Override
        public void setPrevious(String previous) {
            this.eSet(this.adaptee, "previous", previous);
        }

        @Override
        public String getNext() {
            return this.eGet(this.adaptee, "next", String.class);
        }

        @Override
        public void setNext(String next) {
            this.eSet(this.adaptee, "next", next);
        }

        @Override
        public List<FeatureCollection> getFeatures() {
            return this.eGet(this.adaptee, "member", List.class);
        }

        @Override
        public void setFeatures(List<FeatureCollection> features) {
            this.eSet(this.adaptee, "member", features);
        }

        @Override
        public Object unadapt(Class<?> target) {
            if (target.equals(FeatureCollectionType.class)) {
                this.eSet(this.adaptee, "numberMatched", this.getTotalNumberOfFeatures());
                return this.adaptee;
            }
            if (target.equals(net.opengis.wfs.FeatureCollectionType.class)) {
                FeatureCollectionType source = (FeatureCollectionType)this.adaptee;
                net.opengis.wfs.FeatureCollectionType result = WfsFactory.eINSTANCE.createFeatureCollectionType();
                result.getFeature().addAll((Collection)source.getMember());
                result.setNumberOfFeatures(source.getNumberReturned());
                result.setLockId(source.getLockId());
                result.setTimeStamp(source.getTimeStamp());
                return result;
            }
            throw new WFSException("Cannot transform " + String.valueOf(this.adaptee) + " to the specified target class " + String.valueOf(target));
        }
    }
}

