/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.AllSomeType;
import net.opengis.wfs20.ResolveValueType;
import net.opengis.wfs20.ResultTypeType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.xsd.EMFUtils;

public abstract class GetFeatureRequest
extends RequestObject {
    public static GetFeatureRequest adapt(Object request) {
        if (request instanceof GetFeatureType) {
            GetFeatureType type = (GetFeatureType)request;
            return new WFS11((EObject)type);
        }
        if (request instanceof net.opengis.wfs20.GetFeatureType) {
            net.opengis.wfs20.GetFeatureType type = (net.opengis.wfs20.GetFeatureType)request;
            return new WFS20((EObject)type);
        }
        return null;
    }

    protected GetFeatureRequest(EObject adaptee) {
        super(adaptee);
    }

    public BigInteger getStartIndex() {
        return this.eGet(this.adaptee, "startIndex", BigInteger.class);
    }

    public void setStartIndex(BigInteger startIndex) {
        this.eSet(this.adaptee, "startIndex", startIndex);
    }

    public List<Map<String, String>> getViewParams() {
        return this.eGet(this.adaptee, "viewParams", List.class);
    }

    public void setViewParams(List<Map<String, String>> viewParams) {
        List l = this.eGet(this.adaptee, "viewParams", List.class);
        l.clear();
        l.addAll(viewParams);
    }

    public abstract List<Query> getQueries();

    public abstract List<Object> getAdaptedQueries();

    public abstract boolean isQueryTypeNamesUnset();

    public abstract BigInteger getMaxFeatures();

    public abstract void setMaxFeatures(BigInteger var1);

    public abstract String getTraverseXlinkDepth();

    public abstract boolean isResultTypeResults();

    public abstract boolean isResultTypeHits();

    public abstract boolean isLockRequest();

    public abstract boolean isLockActionSome();

    public abstract Query createQuery();

    public abstract LockFeatureRequest createLockRequest();

    public abstract FeatureCollectionResponse createResponse();

    public abstract ResolveValueType getResolve();

    public abstract BigInteger getResolveTimeOut();

    public BigInteger getExpiry() {
        return this.eGet(this.adaptee, "expiry", BigInteger.class);
    }

    public void setExpiry(BigInteger expiry) {
        this.eSet(this.adaptee, "expiry", expiry);
    }

    public static class WFS11
    extends GetFeatureRequest {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<Query> getQueries() {
            ArrayList<Query> list = new ArrayList<Query>();
            for (Object o : this.getAdaptedQueries()) {
                list.add(new Query.WFS11((EObject)o));
            }
            return list;
        }

        @Override
        public List<Object> getAdaptedQueries() {
            return this.eGet(this.adaptee, "query", List.class);
        }

        @Override
        public boolean isQueryTypeNamesUnset() {
            return EMFUtils.isUnset((List)this.eGet(this.adaptee, "query", List.class), (String)"typeName");
        }

        @Override
        public BigInteger getMaxFeatures() {
            return this.eGet(this.adaptee, "maxFeatures", BigInteger.class);
        }

        @Override
        public void setMaxFeatures(BigInteger maxFeatures) {
            this.eSet(this.adaptee, "maxFeatures", maxFeatures);
        }

        @Override
        public String getTraverseXlinkDepth() {
            return this.eGet(this.adaptee, "traverseXlinkDepth", String.class);
        }

        @Override
        public boolean isResultTypeResults() {
            return ((GetFeatureType)this.adaptee).getResultType() == net.opengis.wfs.ResultTypeType.RESULTS_LITERAL;
        }

        @Override
        public boolean isResultTypeHits() {
            return ((GetFeatureType)this.adaptee).getResultType() == net.opengis.wfs.ResultTypeType.HITS_LITERAL;
        }

        @Override
        public boolean isLockRequest() {
            return this.adaptee instanceof GetFeatureWithLockType;
        }

        @Override
        public boolean isLockActionSome() {
            return false;
        }

        @Override
        public Query createQuery() {
            return new Query.WFS11((EObject)((WfsFactory)this.getFactory()).createQueryType());
        }

        @Override
        public LockFeatureRequest createLockRequest() {
            return new LockFeatureRequest.WFS11((EObject)((WfsFactory)this.getFactory()).createLockFeatureType());
        }

        @Override
        public FeatureCollectionResponse createResponse() {
            return new FeatureCollectionResponse.WFS11((EObject)((WfsFactory)this.getFactory()).createFeatureCollectionType());
        }

        @Override
        public ResolveValueType getResolve() {
            return ResolveValueType.ALL;
        }

        @Override
        public BigInteger getResolveTimeOut() {
            BigInteger seconds = this.eGet(this.adaptee, "traverseXlinkExpiry", BigInteger.class);
            return seconds == null ? null : BigInteger.valueOf(60L).multiply(seconds);
        }
    }

    public static class WFS20
    extends GetFeatureRequest {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<Query> getQueries() {
            List<Object> adaptedQueries = this.getAdaptedQueries();
            return WFS20.getQueries(adaptedQueries);
        }

        public static List<Query> getQueries(List<?> adaptedQueries) {
            ArrayList<Query> list = new ArrayList<Query>();
            for (Object o : adaptedQueries) {
                list.add(new Query.WFS20((EObject)o));
            }
            return list;
        }

        @Override
        public List<Object> getAdaptedQueries() {
            return this.eGet(this.adaptee, "abstractQueryExpression", List.class);
        }

        @Override
        public boolean isQueryTypeNamesUnset() {
            return EMFUtils.isUnset((List)this.eGet(this.adaptee, "abstractQueryExpression", List.class), (String)"typeNames");
        }

        @Override
        public BigInteger getMaxFeatures() {
            return this.eGet(this.adaptee, "count", BigInteger.class);
        }

        @Override
        public void setMaxFeatures(BigInteger maxFeatures) {
            this.eSet(this.adaptee, "count", maxFeatures);
        }

        @Override
        public String getTraverseXlinkDepth() {
            Object obj = this.eGet(this.adaptee, "resolveDepth", Object.class);
            return obj != null ? obj.toString() : null;
        }

        @Override
        public boolean isResultTypeResults() {
            return ((net.opengis.wfs20.GetFeatureType)this.adaptee).getResultType() == ResultTypeType.RESULTS;
        }

        @Override
        public boolean isResultTypeHits() {
            return ((net.opengis.wfs20.GetFeatureType)this.adaptee).getResultType() == ResultTypeType.HITS;
        }

        @Override
        public boolean isLockRequest() {
            return this.adaptee instanceof net.opengis.wfs20.GetFeatureWithLockType;
        }

        @Override
        public boolean isLockActionSome() {
            return ((net.opengis.wfs20.GetFeatureWithLockType)this.adaptee).getLockAction() == AllSomeType.SOME;
        }

        @Override
        public Query createQuery() {
            return new Query.WFS20((EObject)((Wfs20Factory)this.getFactory()).createQueryType());
        }

        @Override
        public LockFeatureRequest createLockRequest() {
            return new LockFeatureRequest.WFS20((EObject)((Wfs20Factory)this.getFactory()).createLockFeatureType());
        }

        @Override
        public FeatureCollectionResponse createResponse() {
            return new FeatureCollectionResponse.WFS20((EObject)((Wfs20Factory)this.getFactory()).createFeatureCollectionType());
        }

        @Override
        public ResolveValueType getResolve() {
            return this.eGet(this.adaptee, "resolve", ResolveValueType.class);
        }

        @Override
        public BigInteger getResolveTimeOut() {
            return this.eGet(this.adaptee, "resolveTimeOut", BigInteger.class);
        }
    }
}

