/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.XlinkPropertyNameType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;

public abstract class Query
extends RequestObject {
    public static Query adapt(Object query) {
        if (query instanceof QueryType) {
            QueryType type = (QueryType)query;
            return new WFS11((EObject)type);
        }
        if (query instanceof net.opengis.wfs20.QueryType) {
            net.opengis.wfs20.QueryType type = (net.opengis.wfs20.QueryType)query;
            return new WFS20((EObject)type);
        }
        return null;
    }

    protected Query(EObject adaptee) {
        super(adaptee);
    }

    public URI getSrsName() {
        return this.eGet(this.adaptee, "srsName", URI.class);
    }

    public void setSrsName(URI srs) {
        this.eSet(this.adaptee, "srsName", srs);
    }

    public String getFeatureVersion() {
        return this.eGet(this.adaptee, "featureVersion", String.class);
    }

    @Override
    public abstract List<QName> getTypeNames();

    public abstract List<String> getAliases();

    public abstract List<String> getPropertyNames();

    public abstract void setPropertyNames(List<String> var1);

    @Override
    public abstract Filter getFilter();

    public abstract List<SortBy> getSortBy();

    public abstract void setSortBy(List<SortBy> var1);

    public abstract List<XlinkPropertyNameType> getXlinkPropertyNames();

    public static class WFS11
    extends Query {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<QName> getTypeNames() {
            return this.eGet(this.adaptee, "typeName", List.class);
        }

        @Override
        public List<String> getAliases() {
            return new ArrayList<String>();
        }

        @Override
        public List<String> getPropertyNames() {
            return this.eGet(this.adaptee, "propertyName", List.class);
        }

        @Override
        public void setPropertyNames(List<String> names) {
            this.eSet(this.adaptee, "propertyNames", names);
        }

        @Override
        public Filter getFilter() {
            return this.eGet(this.adaptee, "filter", Filter.class);
        }

        @Override
        public List<SortBy> getSortBy() {
            return this.eGet(this.adaptee, "sortBy", List.class);
        }

        @Override
        public void setSortBy(List<SortBy> sortBy) {
            this.eSet(this.adaptee, "sortBy", sortBy);
        }

        @Override
        public List<XlinkPropertyNameType> getXlinkPropertyNames() {
            return this.eGet(this.adaptee, "xlinkPropertyName", List.class);
        }
    }

    public static class WFS20
    extends Query {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public List<QName> getTypeNames() {
            return this.eGet(this.adaptee, "typeNames", List.class);
        }

        @Override
        public void setTypeNames(List<QName> typeNames) {
            List l = this.eGet(this.adaptee, "typeNames", List.class);
            l.clear();
            l.addAll(typeNames);
        }

        @Override
        public List<String> getAliases() {
            return this.eGet(this.adaptee, "aliases", List.class);
        }

        @Override
        public List<String> getPropertyNames() {
            List propertyNames = this.eGet(this.adaptee, "abstractProjectionClause", List.class);
            ArrayList<String> l = new ArrayList<String>();
            for (QName name : propertyNames) {
                l.add(name.getLocalPart());
            }
            return l;
        }

        @Override
        public void setPropertyNames(List<String> names) {
            List qnames = names.stream().map(n -> new QName((String)n)).collect(Collectors.toList());
            this.eSet(this.adaptee, "abstractProjectionClause", qnames);
        }

        @Override
        public Filter getFilter() {
            return this.eGet(this.adaptee, "abstractSelectionClause", Filter.class);
        }

        @Override
        public List<SortBy> getSortBy() {
            return this.eGet(this.adaptee, "abstractSortingClause", List.class);
        }

        @Override
        public void setSortBy(List<SortBy> sortBy) {
            this.eSet(this.adaptee, "abstractSortingClause", sortBy);
        }

        @Override
        public List<XlinkPropertyNameType> getXlinkPropertyNames() {
            return Collections.emptyList();
        }
    }
}

