/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class CurveTypeWrapper
implements FeatureType {
    FeatureType delegate;

    public CurveTypeWrapper(FeatureType delegate) {
        this.delegate = delegate;
    }

    public boolean isIdentified() {
        return this.delegate.isIdentified();
    }

    public GeometryDescriptor getGeometryDescriptor() {
        GeometryDescriptor gd = this.delegate.getGeometryDescriptor();
        return this.wrapGeometryDescriptor(gd);
    }

    private GeometryDescriptor wrapGeometryDescriptor(GeometryDescriptor gd) {
        GeometryType type = gd.getType();
        Class binding = type.getBinding();
        if (MultiLineString.class.isAssignableFrom(binding)) {
            GeometryTypeImpl curvedType = new GeometryTypeImpl(type.getName(), MultiCurvedGeometry.class, type.getCoordinateReferenceSystem(), type.isIdentified(), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
            return new GeometryDescriptorImpl((GeometryType)curvedType, gd.getName(), gd.getMinOccurs(), gd.getMaxOccurs(), gd.isNillable(), gd.getDefaultValue());
        }
        if (LineString.class.isAssignableFrom(binding)) {
            GeometryTypeImpl curvedType = new GeometryTypeImpl(type.getName(), CurvedGeometry.class, type.getCoordinateReferenceSystem(), type.isIdentified(), type.isAbstract(), type.getRestrictions(), type.getSuper(), type.getDescription());
            return new GeometryDescriptorImpl((GeometryType)curvedType, gd.getName(), gd.getMinOccurs(), gd.getMaxOccurs(), gd.isNillable(), gd.getDefaultValue());
        }
        return gd;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem();
    }

    public AttributeType getSuper() {
        return this.delegate.getSuper();
    }

    public Class<Collection<Property>> getBinding() {
        return this.delegate.getBinding();
    }

    public Collection<PropertyDescriptor> getDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        Collection descriptors = this.delegate.getDescriptors();
        for (PropertyDescriptor pd : descriptors) {
            if (pd instanceof GeometryDescriptor) {
                GeometryDescriptor descriptor = (GeometryDescriptor)pd;
                pd = this.wrapGeometryDescriptor(descriptor);
            }
            result.add(pd);
        }
        return result;
    }

    public PropertyDescriptor getDescriptor(Name name) {
        return this.delegate.getDescriptor(name);
    }

    public PropertyDescriptor getDescriptor(String name) {
        return this.delegate.getDescriptor(name);
    }

    public Name getName() {
        return this.delegate.getName();
    }

    public boolean isInline() {
        return this.delegate.isInline();
    }

    public boolean isAbstract() {
        return this.delegate.isAbstract();
    }

    public List<Filter> getRestrictions() {
        return this.delegate.getRestrictions();
    }

    public InternationalString getDescription() {
        return this.delegate.getDescription();
    }

    public Map<Object, Object> getUserData() {
        return this.delegate.getUserData();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurveTypeWrapper other = (CurveTypeWrapper)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }
}

