/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.CurveTypeWrapper;
import org.geoserver.wfs.xml.GML2Profile;
import org.geoserver.wfs.xml.GML3Profile;
import org.geoserver.wfs.xml.RestrictionToXSDConstrainingFacetVisitor;
import org.geoserver.wfs.xml.SchemaCleanerCallback;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geoserver.wfs.xml.XSProfile;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.Schema;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.NameImpl;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.v3_2.GML;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xs.XS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Schemas;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public abstract class FeatureTypeSchemaBuilder {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;
    GeoServer gs;
    protected List<Object> profiles;
    protected String gmlNamespace;
    protected String gmlSchemaLocation;
    protected String baseType;
    protected String substitutionGroup;
    protected Map<String, String> describeFeatureTypeParams;
    protected String gmlPrefix;
    protected Configuration xmlConfiguration;
    protected volatile XSDElementDeclaration featureSubGroupElement;

    protected FeatureTypeSchemaBuilder(GeoServer gs) {
        this.gs = gs;
        this.catalog = gs.getCatalog();
        this.resourceLoader = gs.getCatalog().getResourceLoader();
        this.profiles = new ArrayList<Object>();
        this.profiles.add(new XSProfile());
    }

    public Map<String, String> getDescribeFeatureTypeParams() {
        return this.describeFeatureTypeParams;
    }

    public Configuration getXmlConfiguration() {
        return this.xmlConfiguration;
    }

    public XSDSchema build(FeatureTypeInfo featureTypeInfo, String baseUrl) throws IOException {
        return this.build(new FeatureTypeInfo[]{featureTypeInfo}, baseUrl);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl) throws IOException {
        return this.build(featureTypeInfos, baseUrl, true);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl, int resolveAppSchemaImports) throws IOException {
        return this.build(featureTypeInfos, baseUrl, resolveAppSchemaImports != 0, true);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl, boolean scheduleSchemaCleanup) throws IOException {
        return this.build(featureTypeInfos, baseUrl, false, scheduleSchemaCleanup);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl, boolean resolveAppSchemaImports, boolean scheduleSchemaCleanup) throws IOException {
        XSDSchema schema = this.buildSchemaInternal(featureTypeInfos, baseUrl, resolveAppSchemaImports);
        if (schema != null && scheduleSchemaCleanup) {
            SchemaCleanerCallback.addSchema(schema);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XSDSchema buildSchemaInternal(FeatureTypeInfo[] featureTypeInfos, String baseUrl, boolean resolveAppSchemaImports) throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema schema = factory.createXSDSchema();
        schema.setSchemaForSchemaQNamePrefix("xsd");
        schema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setElementFormDefault(XSDForm.get((int)0));
        HashMap<String, ArrayList<FeatureTypeInfo>> ns2featureTypeInfos = new HashMap<String, ArrayList<FeatureTypeInfo>>();
        for (FeatureTypeInfo typeInfo : featureTypeInfos) {
            String prefix = typeInfo.getNamespace().getPrefix();
            ArrayList<FeatureTypeInfo> l = (ArrayList<FeatureTypeInfo>)ns2featureTypeInfos.get(prefix);
            if (l == null) {
                l = new ArrayList<FeatureTypeInfo>();
            }
            l.add(typeInfo);
            ns2featureTypeInfos.put(prefix, l);
        }
        if (baseUrl == null) {
            baseUrl = ((WFSInfo)this.gs.getService(WFSInfo.class)).getSchemaBaseURL();
        }
        if (ns2featureTypeInfos.entrySet().isEmpty()) {
            this.importGMLSchema(schema, factory, baseUrl);
            schema.setTargetNamespace(this.gmlSchema().getTargetNamespace());
        } else if (ns2featureTypeInfos.entrySet().size() == 1) {
            String targetPrefix = (String)ns2featureTypeInfos.keySet().iterator().next();
            String targetNamespace = this.catalog.getNamespaceByPrefix(targetPrefix).getURI();
            schema.setTargetNamespace(targetNamespace);
            schema.getQNamePrefixToNamespaceMap().put(targetPrefix, targetNamespace);
            boolean simple = this.isSimpleFeature(featureTypeInfos);
            if (!simple) {
                this.addRequiredNamespaces(featureTypeInfos, schema);
            }
            try {
                FeatureType featureType = featureTypeInfos[0].getFeatureType();
                Object schemaUri = featureType.getUserData().get("schemaURI");
                if (schemaUri != null && schemaUri instanceof Map) {
                    TreeMap schemaURIs = new TreeMap((Map)schemaUri);
                    if (!this.findTypeInSchema(featureTypeInfos[0], schema, factory)) {
                        HashMap<String, String> imports = new HashMap<String, String>();
                        HashSet<String> includes = new HashSet<String>();
                        for (String namespace : schemaURIs.keySet()) {
                            this.addReference(schema, factory, namespace, (String)schemaURIs.get(namespace), imports, includes);
                        }
                    }
                    return schema;
                }
            }
            catch (IOException e) {
                logger.warning("Unable to get schema location for feature type '" + featureTypeInfos[0].prefixedName() + "'. Reason: '" + e.getMessage() + "'. Building the schema manually instead.");
            }
            this.importGMLSchema(schema, factory, baseUrl);
            schema.getQNamePrefixToNamespaceMap().put(this.gmlPrefix, this.gmlNamespace);
            for (FeatureTypeInfo featureTypeInfo : featureTypeInfos) {
                try {
                    this.buildSchemaContent(featureTypeInfo, schema, factory, baseUrl);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not build xml schema for type: " + featureTypeInfo.getName(), e);
                }
            }
        } else {
            if (!this.isSimpleFeature(featureTypeInfos)) {
                this.addRequiredNamespaces(featureTypeInfos, schema);
            }
            NamespaceInfo ns = featureTypeInfos[0].getNamespace();
            if (!(this instanceof GML2)) {
                schema.setTargetNamespace(ns.getURI());
            }
            HashMap<String, String> imports = new HashMap<String, String>();
            HashSet<String> includes = new HashSet<String>();
            for (Map.Entry stringListEntry : ns2featureTypeInfos.entrySet()) {
                String prefix = (String)stringListEntry.getKey();
                List types = (List)stringListEntry.getValue();
                StringBuilder typeNames = new StringBuilder();
                for (FeatureTypeInfo type : types) {
                    FeatureType featureType = type.getFeatureType();
                    Object schemaUri = featureType.getUserData().get("schemaURI");
                    if (schemaUri instanceof Map) {
                        TreeMap schemaURIs = new TreeMap((Map)schemaUri);
                        for (String namespace : schemaURIs.keySet()) {
                            this.addReference(schema, factory, namespace, (String)schemaURIs.get(namespace), imports, includes);
                        }
                        continue;
                    }
                    typeNames.append(type.prefixedName()).append(",");
                }
                if (typeNames.length() <= 0) continue;
                typeNames.setLength(typeNames.length() - 1);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.describeFeatureTypeParams);
                params.put("typeName", typeNames.toString().trim());
                String schemaLocation = ResponseUtils.buildURL((String)baseUrl, (String)"wfs", params, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                String namespace = this.catalog.getNamespaceByPrefix(prefix).getURI();
                schema.getQNamePrefixToNamespaceMap().put(prefix, namespace);
                XSDImport imprt = factory.createXSDImport();
                imprt.setNamespace(namespace);
                imprt.setSchemaLocation(schemaLocation);
                XSDSchema resolved = null;
                if (resolveAppSchemaImports) {
                    ArrayList<FeatureTypeInfo> featureTypes = new ArrayList<FeatureTypeInfo>();
                    for (EList typeName : typeNames.toString().split(",")) {
                        featureTypes.add(this.catalog.getFeatureTypeByName((String)typeName));
                    }
                    resolved = this.build(featureTypes.toArray(new FeatureTypeInfo[featureTypes.size()]), baseUrl);
                    schema.getQNamePrefixToNamespaceMap().put("gml", this.gmlNamespace);
                    if (this.getWfsSchema() != null) {
                        schema.getQNamePrefixToNamespaceMap().put("wfs", this.getWfsSchema().getTargetNamespace());
                    }
                }
                if (resolved != null) {
                    imprt.setResolvedSchema(resolved);
                }
                schema.getContents().add((Object)imprt);
                if (resolved == null) continue;
                XSDSchemaImpl rs = (XSDSchemaImpl)resolved;
                EList eList = rs.eAdapters();
                synchronized (eList) {
                    rs.imported(imprt);
                }
            }
        }
        return schema;
    }

    private void addRequiredNamespaces(FeatureTypeInfo[] featureTypeInfos, XSDSchema schema) {
        WorkspaceInfo localWorkspace = LocalWorkspace.get();
        if (localWorkspace != null) {
            LocalWorkspace.remove();
        }
        try {
            Map schemaNamespacesMap = schema.getQNamePrefixToNamespaceMap();
            List catalogNamespaces = this.catalog.getNamespaces();
            for (FeatureTypeInfo featureTypeInfo : featureTypeInfos) {
                Object mapObject = featureTypeInfo.getFeatureType().getUserData().get("declaredNamespacesMap");
                if (!(mapObject instanceof Map)) continue;
                Map featureTypeNamespaces = (Map)mapObject;
                for (Map.Entry entry : featureTypeNamespaces.entrySet()) {
                    String uri = (String)entry.getValue();
                    if (schemaNamespacesMap.containsValue(uri)) continue;
                    Optional<NamespaceInfo> nsFromCatalog = catalogNamespaces.stream().filter(nsi -> Objects.equals(nsi.getURI(), uri)).findFirst();
                    String prefix = nsFromCatalog.map(NamespaceInfo::getPrefix).orElse((String)entry.getKey());
                    schemaNamespacesMap.put(prefix, uri);
                }
            }
            if (!schemaNamespacesMap.containsValue("http://www.w3.org/1999/xlink")) {
                Optional<NamespaceInfo> xlinkNSFromCatalog = catalogNamespaces.stream().filter(x -> "http://www.w3.org/1999/xlink".equals(x.getURI())).findFirst();
                schemaNamespacesMap.put(xlinkNSFromCatalog.map(NamespaceInfo::getPrefix).orElse("xlink"), "http://www.w3.org/1999/xlink");
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to add namespaces", e);
            throw new UncheckedIOException(e);
        }
        finally {
            LocalWorkspace.set((WorkspaceInfo)localWorkspace);
        }
    }

    private boolean isSimpleFeature(FeatureTypeInfo[] featureTypeInfos) {
        boolean simple = true;
        for (int i = 0; i < featureTypeInfos.length && simple; ++i) {
            try {
                simple = featureTypeInfos[i].getFeatureType() instanceof SimpleFeatureType;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return simple;
    }

    protected void importGMLSchema(XSDSchema schema, XSDFactory factory, String baseUrl) {
        XSDImport imprt = factory.createXSDImport();
        imprt.setNamespace(this.gmlNamespace);
        imprt.setSchemaLocation(ResponseUtils.buildSchemaURL((String)baseUrl, (String)this.gmlSchemaLocation));
        XSDSchema gmlSchema = this.gmlSchema();
        imprt.setResolvedSchema(gmlSchema);
        schema.getContents().add((Object)imprt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void addReference(XSDSchema schema, XSDFactory factory, String namespace, String schemaLocation, Map<String, String> imports, Set<String> includes) {
        if (this.getWfsSchema() != null && imports.get(this.getWfsSchema().getTargetNamespace()) == null) {
            Class<Schemas> clazz = Schemas.class;
            // MONITORENTER : org.geotools.xsd.Schemas.class
            schema.getQNamePrefixToNamespaceMap().put("wfs", this.getWfsSchema().getTargetNamespace());
            XSDImport wfsImport = factory.createXSDImport();
            wfsImport.setNamespace(this.getWfsSchema().getTargetNamespace());
            wfsImport.setSchemaLocation(this.getWfsSchema().getSchemaLocation());
            wfsImport.setResolvedSchema(this.getWfsSchema());
            schema.getContents().add((Object)wfsImport);
            XSDSchemaImpl wfsSchema = (XSDSchemaImpl)this.getWfsSchema();
            EList eList = wfsSchema.eAdapters();
            // MONITORENTER : eList
            wfsSchema.imported(wfsImport);
            // MONITOREXIT : eList
            imports.put(this.getWfsSchema().getTargetNamespace(), this.getWfsSchema().getSchemaLocation());
            // MONITOREXIT : clazz
        }
        if (namespace.equals(schema.getTargetNamespace())) {
            if (includes.contains(schemaLocation)) {
                logger.finer("Skipped generation of duplicate include for  schemaLocation=\"" + schemaLocation + " while generating schema for " + schema.getTargetNamespace());
                return;
            }
            this.addInclude(schema, factory, schemaLocation);
            includes.add(schemaLocation);
            return;
        }
        if (imports.get(namespace) == null) {
            this.addImport(schema, factory, namespace, schemaLocation);
            imports.put(namespace, schemaLocation);
            return;
        }
        if (imports.get(namespace).equals(schemaLocation)) {
            logger.finer("Skipped generation of duplicate import for namespace=\"" + namespace + "\" schemaLocation=\"" + schemaLocation + " while generating schema for " + schema.getTargetNamespace());
            return;
        }
        logger.warning("Skipped generation of conflicting import for namespace=\"" + namespace + "\" schemaLocation=\"" + schemaLocation + " while generating schema for " + schema.getTargetNamespace() + " (some XML processors will ignore all imports for a namespace after the first)");
    }

    private void addInclude(XSDSchema schema, XSDFactory factory, String schemaLocation) {
        XSDInclude xsdInclude = factory.createXSDInclude();
        xsdInclude.setSchemaLocation(schemaLocation);
        schema.getContents().add((Object)xsdInclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImport(XSDSchema schema, XSDFactory factory, String namespace, String schemaLocation) {
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            XSDImport xsdImport = factory.createXSDImport();
            xsdImport.setNamespace(namespace);
            xsdImport.setSchemaLocation(schemaLocation);
            schema.getContents().add((Object)xsdImport);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected XSDSchema getWfsSchema() {
        return null;
    }

    public XSDSchema addApplicationTypes(XSDSchema wfsSchema) throws IOException {
        List featureTypeInfos = this.catalog.getFeatureTypes();
        for (FeatureTypeInfo meta : featureTypeInfos) {
            if (!meta.enabled()) continue;
            XSDSchema schema = this.buildSchemaInternal(new FeatureTypeInfo[]{meta}, null, false);
            String prefix = meta.getNamespace().getPrefix();
            String namespaceURI = meta.getNamespace().getURI();
            wfsSchema.getQNamePrefixToNamespaceMap().put(prefix, namespaceURI);
            for (XSDTypeDefinition xsdTypeDefinition : schema.getTypeDefinitions()) {
                wfsSchema.getTypeDefinitions().add((Object)xsdTypeDefinition);
            }
            for (XSDElementDeclaration xsdElementDeclaration : schema.getElementDeclarations()) {
                wfsSchema.getElementDeclarations().add((Object)xsdElementDeclaration);
            }
            for (Map.Entry entry : schema.getQNamePrefixToNamespaceMap().entrySet()) {
                if (wfsSchema.getQNamePrefixToNamespaceMap().containsKey(entry.getKey())) continue;
                wfsSchema.getQNamePrefixToNamespaceMap().put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return wfsSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean findTypeInSchema(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory) throws IOException {
        ws = featureTypeMeta.getStore().getWorkspace().getName();
        schemaFile = this.resourceLoader.get("workspaces/" + ws + "/" + (ds = featureTypeMeta.getStore().getName()) + "/" + (name = featureTypeMeta.getName()) + "/schema.xsd");
        if (schemaFile.getType() != Resource.Type.RESOURCE) ** GOTO lbl-1000
        if (FeatureTypeSchemaBuilder.logger.isLoggable(Level.FINE)) {
            FeatureTypeSchemaBuilder.logger.fine("Found customized schema.xsd: " + schemaFile.path());
        }
        resolvers = Schemas.findSchemaLocationResolvers((Configuration)this.xmlConfiguration);
        locators = new ArrayList<1>();
        locators.add(new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                if (FeatureTypeSchemaBuilder.this.gmlNamespace.equals(namespaceURI)) {
                    return FeatureTypeSchemaBuilder.this.gmlSchema();
                }
                return null;
            }
        });
        ftSchema = null;
        try {
            ftSchema = Schemas.parse((String)schemaFile.file().getAbsolutePath(), locators, (List)resolvers, Collections.emptyList(), (EntityResolver)this.catalog.getResourcePool().getEntityResolver());
        }
        catch (IOException e) {
            FeatureTypeSchemaBuilder.logger.log(Level.WARNING, "Unable to parse schema: " + schemaFile.file().getAbsolutePath(), e);
        }
        if (ftSchema != null) {
            if (ftSchema.getSchemaForSchemaQNamePrefix() != null) {
                schema.setSchemaForSchemaQNamePrefix(ftSchema.getSchemaForSchemaQNamePrefix());
            }
            contents = ftSchema.getContents();
            hasElement = false;
            i = contents.iterator();
        } else lbl-1000:
        // 2 sources

        {
            return false;
        }
        while (i.hasNext()) {
            content /* !! */  = (XSDSchemaContent)i.next();
            content /* !! */ .setElement(null);
            if (content /* !! */  instanceof XSDImport && this.gmlNamespace.equals((imprt = (XSDImport)content /* !! */ ).getNamespace())) {
                i.remove();
            }
            if (content /* !! */  instanceof XSDElementDeclaration) {
                declaration = (XSDElementDeclaration)content /* !! */ ;
                if (this.contains((XSDNamedComponent)declaration, (List)schema.getElementDeclarations())) {
                    i.remove();
                }
            } else if (content /* !! */  instanceof XSDTypeDefinition && this.contains((XSDNamedComponent)(definition = (XSDTypeDefinition)content /* !! */ ), (List)schema.getTypeDefinitions())) {
                i.remove();
            }
            if (hasElement || !(content /* !! */  instanceof XSDElementDeclaration) || !name.equals((element = (XSDElementDeclaration)content /* !! */ ).getName()) || !featureTypeMeta.getNamespace().getURI().equals(element.getTargetNamespace())) continue;
            hasElement = true;
        }
        if (hasElement) ** GOTO lbl59
        element = factory.createXSDElementDeclaration();
        element.setName(featureTypeMeta.getName());
        element.setTargetNamespace(featureTypeMeta.getNamespace().getURI());
        content /* !! */  = Schemas.class;
        synchronized (Schemas.class) {
            element.setSubstitutionGroupAffiliation(this.getFeatureElement());
            // ** MonitorExit[content /* !! */ ] (shouldn't be in output)
            candidates = new ArrayList<XSDComplexTypeDefinition>();
            var15_16 = ftSchema.getTypeDefinitions().iterator();
            block5: while (true) {
                if (var15_16.hasNext()) {
                    type = (XSDTypeDefinition)var15_16.next();
                    if (!(type instanceof XSDComplexTypeDefinition)) continue;
                } else {
                    if (candidates.size() != 1) {
                        throw new IllegalStateException("Could not determine feature type for generated element. Must specify explicitly in schema.xsd.");
                    }
                    element.setTypeDefinition((XSDTypeDefinition)candidates.get(0));
                    schema.getContents().add((Object)element);
lbl59:
                    // 2 sources

                    schema.getContents().addAll((Collection)contents);
                    schema.updateElement();
                    Schemas.dispose((XSDSchema)ftSchema);
                    return true;
                }
                definition = (XSDComplexTypeDefinition)type;
                base = type.getBaseType();
                while (true) {
                    if (base == null) continue block5;
                    if (this.baseType.equals(base.getName()) && this.gmlNamespace.equals(base.getTargetNamespace())) {
                        candidates.add(definition);
                        continue block5;
                    }
                    if (base.equals(base.getBaseType())) ** break;
                    base = base.getBaseType();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSDElementDeclaration getFeatureElement() {
        if (this.featureSubGroupElement == null) {
            FeatureTypeSchemaBuilder featureTypeSchemaBuilder = this;
            synchronized (featureTypeSchemaBuilder) {
                if (this.featureSubGroupElement == null) {
                    this.featureSubGroupElement = this.gmlSchema().resolveElementDeclaration(this.gmlNamespace, this.substitutionGroup);
                }
            }
        }
        return this.featureSubGroupElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildSchemaContent(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory, String baseUrl) throws IOException {
        if (this.findTypeInSchema(featureTypeMeta, schema, factory)) return;
        FeatureType featureType = featureTypeMeta.getFeatureType();
        if (featureTypeMeta.isCircularArcPresent() && this.getClass().equals(GML3.class)) {
            featureType = new CurveTypeWrapper(featureType);
        }
        XSDComplexTypeDefinition xsdComplexType = this.buildComplexSchemaContent((ComplexType)featureType, schema, factory);
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(featureTypeMeta.getName());
        element.setTargetNamespace(featureTypeMeta.getNamespace().getURI());
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            element.setSubstitutionGroupAffiliation(this.getFeatureElement());
            // ** MonitorExit[var8_8] (shouldn't be in output)
            element.setTypeDefinition((XSDTypeDefinition)xsdComplexType);
            schema.getContents().add((Object)element);
            schema.updateElement();
            return;
        }
    }

    private XSDComplexTypeDefinition buildComplexSchemaContent(ComplexType complexType, XSDSchema schema, XSDFactory factory) {
        XSDComplexTypeDefinition xsdComplexType = factory.createXSDComplexTypeDefinition();
        xsdComplexType.setName(complexType.getName().getLocalPart() + "Type");
        xsdComplexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        xsdComplexType.setBaseTypeDefinition(this.resolveTypeInSchema(schema, (Name)new NameImpl(this.gmlNamespace, this.baseType)));
        XSDModelGroup group = factory.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        HashMap<XSDElementDeclaration, InternationalString> annotationCache = new HashMap<XSDElementDeclaration, InternationalString>();
        HashMap<XSDElementDeclaration, List> restrictionsCache = new HashMap<XSDElementDeclaration, List>();
        for (PropertyDescriptor pd : complexType.getDescriptors()) {
            ComplexType type;
            GMLInfo gml;
            AttributeDescriptor attribute;
            if (!(pd instanceof AttributeDescriptor) || this.filterAttributeType(attribute = (AttributeDescriptor)pd) && ((gml = this.getGMLConfig((WFSInfo)this.gs.getService(WFSInfo.class))) == null || !gml.getOverrideGMLAttributes().booleanValue())) continue;
            XSDElementDeclaration element2 = factory.createXSDElementDeclaration();
            element2.setName(attribute.getLocalName());
            element2.setNillable(attribute.isNillable());
            AttributeType attributeType = attribute.getType();
            Name typeName = attributeType.getName();
            if (!typeName.getLocalPart().equals(XS.ANYTYPE.getLocalPart()) || !typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                if (attributeType instanceof ComplexType) {
                    type = (ComplexType)attributeType;
                    if (schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart()) == null) {
                        this.buildComplexSchemaContent(type, schema, factory);
                    }
                } else {
                    Class binding = attributeType.getBinding();
                    typeName = this.findTypeName(binding);
                    if (typeName == null) {
                        logger.finer("Fallback mapping: attribute " + String.valueOf(attribute.getName()) + " to String");
                        typeName = this.findTypeName(String.class);
                        if (typeName == null) {
                            throw new NullPointerException("Could not find a type for property: " + String.valueOf(attribute.getName()) + " of type: " + binding.getName());
                        }
                    }
                }
            }
            type = this.resolveTypeInSchema(schema, typeName);
            element2.setTypeDefinition((XSDTypeDefinition)type);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element2);
            group.getContents().add((Object)particle);
            if (attributeType.getDescription() != null) {
                annotationCache.put(element2, attributeType.getDescription());
            }
            if (attributeType.getRestrictions() == null) continue;
            restrictionsCache.put(element2, attributeType.getRestrictions());
        }
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        xsdComplexType.setContent((XSDComplexTypeContent)particle);
        schema.getContents().add((Object)xsdComplexType);
        annotationCache.forEach((element, description) -> {
            XSDAnnotation annotation = factory.createXSDAnnotation();
            element.setAnnotation(annotation);
            Element documentation = annotation.createUserInformation(null);
            documentation.appendChild(documentation.getOwnerDocument().createTextNode(description.toString()));
            annotation.getElement().appendChild(documentation);
        });
        RestrictionToXSDConstrainingFacetVisitor restrictionsVisitor = new RestrictionToXSDConstrainingFacetVisitor(factory);
        restrictionsCache.forEach((element, restrictions) -> {
            if (!restrictions.isEmpty()) {
                XSDSimpleTypeDefinition simple = factory.createXSDSimpleTypeDefinition();
                simple.setBaseTypeDefinition(element.getTypeDefinition().getSimpleType());
                EList facets = simple.getFacetContents();
                restrictions.stream().map(filter -> this.facetsFromFilter((Filter)filter, restrictionsVisitor)).forEach(arg_0 -> facets.addAll(arg_0));
                if (!facets.isEmpty()) {
                    element.setAnonymousTypeDefinition((XSDTypeDefinition)simple);
                }
            }
        });
        return xsdComplexType;
    }

    private List<XSDConstrainingFacet> facetsFromFilter(Filter filter, RestrictionToXSDConstrainingFacetVisitor restrictionsVisitor) {
        Object visitedFilter = filter.accept((FilterVisitor)restrictionsVisitor, new ArrayList());
        if (filter.equals(visitedFilter)) {
            return List.of();
        }
        return (List)visitedFilter;
    }

    XSDTypeDefinition resolveTypeInSchema(XSDSchema schema, Name typeName) {
        XSDTypeDefinition type = null;
        for (XSDTypeDefinition td : schema.getTypeDefinitions()) {
            if (!typeName.getNamespaceURI().equals(td.getTargetNamespace()) || !typeName.getLocalPart().equals(td.getName())) continue;
            type = td;
            break;
        }
        if (type == null) {
            type = schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart());
        }
        return type;
    }

    boolean contains(XSDNamedComponent c, List l) {
        boolean contains = false;
        Iterator i = l.iterator();
        while (!contains && i.hasNext()) {
            XSDNamedComponent e = (XSDNamedComponent)i.next();
            if (!e.getName().equals(c.getName())) continue;
            if (e.getTargetNamespace() == null) {
                contains = c.getTargetNamespace() == null;
                continue;
            }
            contains = e.getTargetNamespace().equals(c.getTargetNamespace());
        }
        return contains;
    }

    Name findTypeName(Class<?> binding) {
        for (Object profile : this.profiles) {
            Name name = null;
            if (profile instanceof TypeMappingProfile) {
                TypeMappingProfile mappingProfile = (TypeMappingProfile)profile;
                name = mappingProfile.name(binding);
            } else if (profile instanceof Schema) {
                Schema schema = (Schema)profile;
                for (Map.Entry e : schema.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(binding)) continue;
                    name = at.getName();
                    break;
                }
                if (name == null) {
                    for (AttributeType at : schema.values()) {
                        if (!binding.isAssignableFrom(at.getBinding())) continue;
                        name = at.getName();
                        break;
                    }
                }
            }
            if (name == null) continue;
            return name;
        }
        return null;
    }

    protected abstract XSDSchema gmlSchema();

    protected abstract GMLInfo getGMLConfig(WFSInfo var1);

    protected boolean filterAttributeType(AttributeDescriptor attribute) {
        return "name".equals(attribute.getLocalName()) || "description".equals(attribute.getLocalName()) || "boundedBy".equals(attribute.getLocalName());
    }

    public static final class GML2
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml2Schema;

        public GML2(GeoServer gs) {
            super(gs);
            this.profiles.add(new GML2Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/2.1.2/feature.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.0.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new GMLConfiguration();
        }

        @Override
        protected XSDSchema gmlSchema() {
            if (gml2Schema == null) {
                XSDSchema result;
                try {
                    result = this.xmlConfiguration.getXSD().getSchema();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                gml2Schema = result;
            }
            return gml2Schema;
        }

        @Override
        protected GMLInfo getGMLConfig(WFSInfo wfs) {
            return wfs.getGML().get((Object)WFSInfo.Version.V_10);
        }
    }

    public static class GML3
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml3Schema;

        public GML3(GeoServer gs) {
            super(gs);
            this.profiles.add(this.createTypeMappingProfile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/3.1.1/base/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.1.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new org.geotools.gml3.GMLConfiguration();
        }

        Object createTypeMappingProfile() {
            return new GML3Profile();
        }

        @Override
        protected XSDSchema gmlSchema() {
            if (gml3Schema == null) {
                gml3Schema = this.createGml3Schema();
            }
            return gml3Schema;
        }

        private XSDSchema createGml3Schema() {
            try {
                return this.xmlConfiguration.getXSD().getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "metaDataProperty".equals(attribute.getLocalName()) || "location".equals(attribute.getLocalName());
        }

        @Override
        protected GMLInfo getGMLConfig(WFSInfo wfs) {
            return wfs.getGML().get((Object)WFSInfo.Version.V_11);
        }
    }

    public static final class GML32NoWfsSchemaImport
    extends GML32 {
        public GML32NoWfsSchemaImport(GeoServer gs) {
            super(gs);
        }

        @Override
        protected XSDSchema getWfsSchema() {
            return null;
        }
    }

    public static class GML32
    extends GML3 {
        private static volatile XSDSchema gml32Schema;

        public GML32(GeoServer gs) {
            super(gs);
            this.gmlNamespace = "http://www.opengis.net/gml/3.2";
            this.gmlPrefix = "gml";
            this.gmlSchemaLocation = "gml/3.2.1/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "AbstractFeature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "2.0.0", "service", "WFS", "outputFormat", "application/gml+xml; version=3.2"});
            this.xmlConfiguration = new org.geotools.gml3.v3_2.GMLConfiguration();
        }

        @Override
        Object createTypeMappingProfile() {
            return GML.getInstance().getTypeMappingProfile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected XSDSchema gmlSchema() {
            if (gml32Schema != null) return gml32Schema;
            Class<FeatureTypeSchemaBuilder> clazz = FeatureTypeSchemaBuilder.class;
            synchronized (FeatureTypeSchemaBuilder.class) {
                if (gml32Schema != null) return gml32Schema;
                gml32Schema = this.createGml32Schema();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return gml32Schema;
            }
        }

        XSDSchema createGml32Schema() {
            try {
                return GML.getInstance().getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void importGMLSchema(XSDSchema schema, XSDFactory factory, String baseUrl) {
            Class<Schemas> clazz = Schemas.class;
            synchronized (Schemas.class) {
                try {
                    XSDImport imprt = factory.createXSDImport();
                    imprt.setNamespace(this.gmlNamespace);
                    imprt.setSchemaLocation(ResponseUtils.buildSchemaURL((String)baseUrl, (String)this.gmlSchemaLocation));
                    imprt.setResolvedSchema(GML.getInstance().getSchema());
                    schema.getContents().add((Object)imprt);
                    schema.getQNamePrefixToNamespaceMap().put("wfs", "http://www.opengis.net/wfs/2.0");
                    XSDSchemaImpl xsdSchema = (XSDSchemaImpl)WFS.getInstance().getSchema();
                    EList eList = xsdSchema.eAdapters();
                    synchronized (eList) {
                        xsdSchema.imported(imprt);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        @Override
        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "descriptionReference".equals(attribute.getLocalName()) || "identifier".equals(attribute.getLocalName());
        }

        @Override
        protected XSDSchema getWfsSchema() {
            try {
                return WFS.getInstance().getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

