/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import net.opengis.wfs20.FeatureCollectionType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.xml.ApplicationSchemaConfiguration2;
import org.geoserver.wfs.xml.ApplicationSchemaXSD2;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.api.feature.Feature;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.w3c.dom.Document;

public class GML32OutputFormat
extends GML3OutputFormat {
    public static final String[] MIME_TYPES = new String[]{"application/gml+xml; version=3.2", "text/xml; subtype=gml/3.2"};
    public static final List<String> FORMATS = new ArrayList<String>();
    GeoServer geoServer;
    protected static DOMSource xslt;

    public GML32OutputFormat(GeoServer geoServer, WFSConfiguration configuration) {
        super(new HashSet<String>(FORMATS), geoServer, configuration);
        this.geoServer = geoServer;
    }

    protected GML32OutputFormat(GeoServer geoServer, Set<String> formats, WFSConfiguration configuration) {
        super(formats, geoServer, configuration);
        this.geoServer = geoServer;
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return MIME_TYPES[0];
    }

    @Override
    protected Configuration customizeConfiguration(Configuration configuration, Map<String, Set<ResourceInfo>> resources, Object request) {
        FeatureTypeSchemaBuilder.GML32 schemaBuilder = new FeatureTypeSchemaBuilder.GML32(this.geoServer);
        ApplicationSchemaXSD2 xsd = new ApplicationSchemaXSD2(schemaBuilder);
        xsd.setBaseURL(GetFeatureRequest.adapt(request).getBaseURL());
        xsd.setResources(resources);
        org.geotools.wfs.v2_0.WFSConfiguration wfs = new org.geotools.wfs.v2_0.WFSConfiguration();
        ((GMLConfiguration)wfs.getDependency(GMLConfiguration.class)).setSrsSyntax(this.getInfo().getGML().get((Object)WFSInfo.Version.V_20).getSrsNameStyle().toSrsSyntax());
        ApplicationSchemaConfiguration2 config = new ApplicationSchemaConfiguration2(xsd, (Configuration)wfs);
        config.getProperties().addAll(configuration.getProperties());
        return config;
    }

    @Override
    protected Encoder createEncoder(Configuration configuration, Map<String, Set<ResourceInfo>> resources, Object request) {
        return new Encoder(configuration);
    }

    @Override
    protected void setAdditionalSchemaLocations(Encoder encoder, GetFeatureRequest request, WFSInfo wfs) {
        String loc = wfs.isCanonicalSchemaLocation() ? "http://schemas.opengis.net/gml/3.2.1/gml.xsd" : ResponseUtils.buildSchemaURL((String)request.getBaseUrl(), (String)"gml/3.2.1/gml.xsd");
        encoder.setSchemaLocation("http://www.opengis.net/gml/3.2", loc);
    }

    @Override
    protected void encode(FeatureCollectionResponse results, OutputStream output, Encoder encoder) throws IOException {
        if (results.isGetFeatureById()) {
            List<FeatureCollection> features = results.getFeatures();
            FeatureCollection fc = features.get(0);
            Feature next = DataUtilities.first((FeatureCollection)fc);
            if (next == null) {
                throw new WFSException((EObject)null, "No feature matching the requested id found", "NotFound");
            }
            encoder.encode((Object)next, GML.AbstractFeature, output);
        } else {
            encoder.encode(results.unadapt(FeatureCollectionType.class), WFS.FeatureCollection, output);
        }
    }

    @Override
    protected String getWfsNamespace() {
        return "http://www.opengis.net/wfs/2.0";
    }

    @Override
    protected String getCanonicalWfsSchemaLocation() {
        return "http://schemas.opengis.net/wfs/2.0/wfs.xsd";
    }

    @Override
    protected String getRelativeWfsSchemaLocation() {
        return "wfs/2.0/wfs.xsd";
    }

    @Override
    protected DOMSource getXSLT() {
        return xslt;
    }

    protected void setNumDecimals(Configuration configuration, int numDecimals) {
        GMLConfiguration gml = (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
        if (gml != null) {
            gml.setNumDecimals(numDecimals);
        }
    }

    static {
        FORMATS.add("gml32");
        FORMATS.addAll(Arrays.asList(MIME_TYPES));
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document xsdDocument = null;
        try {
            xsdDocument = docFactory.newDocumentBuilder().parse(GML3OutputFormat.class.getResourceAsStream("/ChangeNumberOfFeature32.xslt"));
            xslt = new DOMSource(xsdDocument);
        }
        catch (Exception e) {
            xslt = null;
            LOGGER.log(Level.INFO, e.getMessage(), e);
        }
    }
}

