/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.filter.visitor.AbstractFilterVisitor;

public class RestrictionToXSDConstrainingFacetVisitor
extends AbstractFilterVisitor {
    private final XSDFactory factory;

    RestrictionToXSDConstrainingFacetVisitor(XSDFactory factory) {
        this.factory = factory;
    }

    public Object visit(Or filter, Object extraData) {
        return this.visitChildren(filter.getChildren(), extraData);
    }

    private Object visitChildren(List<Filter> children, Object extraData) {
        children.stream().map(c -> c.accept((FilterVisitor)this, extraData)).forEach(facetsLists -> ((ArrayList)extraData).addAll((Collection)facetsLists));
        return extraData;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        XSDMinInclusiveFacet minFacet = this.factory.createXSDMinInclusiveFacet();
        minFacet.setValue((Object)filter.getLowerBoundary().toString());
        minFacet.setLexicalValue(filter.getLowerBoundary().toString());
        XSDMaxInclusiveFacet maxFacet = this.factory.createXSDMaxInclusiveFacet();
        maxFacet.setValue((Object)filter.getUpperBoundary().toString());
        maxFacet.setLexicalValue(filter.getUpperBoundary().toString());
        ((ArrayList)extraData).addAll(List.of(minFacet, maxFacet));
        return extraData;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        XSDEnumerationFacet enumerationFacet = this.factory.createXSDEnumerationFacet();
        enumerationFacet.setLexicalValue(filter.getExpression2().toString());
        ((ArrayList)extraData).add(enumerationFacet);
        return extraData;
    }
}

