/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.CatalogFeatureTypeCache;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.WFSHandlerFactory;
import org.geoserver.wfs.xml.WFSURIHandler;
import org.geoserver.wfs.xml.gml3.AbstractGeometryTypeBinding;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.SrsSyntax;
import org.geotools.util.Converters;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.OptionalComponentParameter;
import org.geotools.xsd.Parser;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.BasicComponentParameter;
import org.picocontainer.defaults.SetterInjectionComponentAdapter;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.NamespaceSupport;

public class WFSXmlUtils {
    public static final String ENTITY_EXPANSION_LIMIT = "org.geoserver.wfs.xml.entityExpansionLimit";
    public static final String XLINK_DEFAULT_PREFIX = "xlink";

    public static void initRequestParser(Parser parser, WFSInfo wfs, GeoServer geoServer, Map kvp) {
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        if (wfs.isCiteCompliant()) {
            strict = Boolean.TRUE;
        }
        parser.setValidating(strict.booleanValue());
        WFSURIHandler.addToParser(geoServer, parser);
        Catalog catalog = geoServer.getCatalog();
        parser.getNamespaces().add((NamespaceSupport)new CatalogNamespaceSupport(catalog));
    }

    public static Object parseRequest(Parser parser, Reader reader, WFSInfo wfs) throws Exception {
        InputSource source = new InputSource(reader);
        source.setEncoding(wfs.getGeoServer().getSettings().getCharset());
        return parser.parse(source);
    }

    public static void checkValidationErrors(Parser parser, XmlRequestReader requestReader) {
        if (!"Transaction".equalsIgnoreCase(requestReader.getElement().getLocalPart()) && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
    }

    public static void initWfsConfiguration(Configuration config, GeoServer gs, FeatureTypeSchemaBuilder schemaBuilder) {
        MutablePicoContainer context = config.getContext();
        CatalogFeatureTypeCache featureTypeCache = new CatalogFeatureTypeCache(gs.getCatalog());
        context.registerComponentInstance(FeatureTypeCache.class, (Object)featureTypeCache);
        context.registerComponentInstance((Object)new WFSHandlerFactory(gs.getCatalog(), schemaBuilder));
    }

    public static void registerAbstractGeometryTypeBinding(Configuration config, Map<QName, Object> bindings, QName qName) {
        bindings.put(qName, new SetterInjectionComponentAdapter((Object)qName, AbstractGeometryTypeBinding.class, new Parameter[]{new OptionalComponentParameter(CoordinateReferenceSystem.class), new DirectObjectParameter(config, Configuration.class), new DirectObjectParameter(WFSXmlUtils.getSrsSyntax(config), SrsSyntax.class)}));
    }

    public static SrsSyntax getSrsSyntax(Configuration obj) {
        for (Configuration dep : obj.getDependencies()) {
            if (dep instanceof GMLConfiguration) {
                GMLConfiguration configuration = (GMLConfiguration)dep;
                return configuration.getSrsSyntax();
            }
            if (!(dep instanceof org.geotools.gml3.GMLConfiguration)) continue;
            org.geotools.gml3.GMLConfiguration configuration = (org.geotools.gml3.GMLConfiguration)dep;
            return configuration.getSrsSyntax();
        }
        return null;
    }

    public static void setSrsSyntax(Configuration obj, SrsSyntax srsSyntax) {
        for (Configuration dep : obj.getDependencies()) {
            GMLConfiguration configuration;
            if (dep instanceof GMLConfiguration) {
                configuration = (GMLConfiguration)dep;
                configuration.setSrsSyntax(srsSyntax);
            }
            if (!(dep instanceof org.geotools.gml3.GMLConfiguration)) continue;
            configuration = (org.geotools.gml3.GMLConfiguration)dep;
            configuration.setSrsSyntax(srsSyntax);
        }
    }

    public static Integer getEntityExpansionLimitConfiguration() {
        return Optional.ofNullable(GeoServerExtensions.getProperty((String)ENTITY_EXPANSION_LIMIT)).map(p -> (Integer)Converters.convert((Object)p, Integer.class)).orElse(100);
    }

    static class DirectObjectParameter
    extends BasicComponentParameter {
        Object obj;
        Class<?> clazz;

        public DirectObjectParameter(Object obj, Class<?> clazz) {
            super(clazz);
            this.obj = obj;
            this.clazz = clazz;
        }

        public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
            if (this.clazz.isAssignableFrom(expectedType)) {
                return true;
            }
            return super.isResolvable(container, adapter, expectedType);
        }

        public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
            if (this.clazz.isAssignableFrom(expectedType)) {
                return this.obj;
            }
            return super.resolveInstance(container, adapter, expectedType);
        }
    }
}

