/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class BufferedImageAdapter
implements RenderedImage {
    private BufferedImage image;

    public BufferedImageAdapter(BufferedImage image) {
        this.image = image;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getTileWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return 0;
    }

    @Override
    public int getTileGridYOffset() {
        return 0;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        if (tileX != 0 || tileY != 0) {
            return null;
        }
        return this.image.getTile(tileX, tileY);
    }

    @Override
    public Raster getData() {
        WritableRaster raster = this.image.getRaster();
        if (raster.getParent() != null) {
            return this.image.getData(new Rectangle(0, 0, raster.getWidth(), raster.getHeight()));
        }
        return raster;
    }

    @Override
    public Raster getData(Rectangle rect) {
        return this.image.getData(rect);
    }

    @Override
    public WritableRaster copyData(WritableRaster raster) {
        return this.image.copyData(raster);
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return new Vector<RenderedImage>();
    }

    @Override
    public Object getProperty(String name) {
        return this.image.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.image.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.image.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getMinX() {
        return this.image.getMinX();
    }

    @Override
    public int getMinY() {
        return this.image.getMinY();
    }
}

