/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.OperationNode;
import org.eclipse.imagen.OperationRegistry;
import org.eclipse.imagen.PropertyGenerator;
import org.eclipse.imagen.PropertySource;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.media.util.PropertyUtil;
import org.eclipse.imagen.util.ImagingException;
import org.eclipse.imagen.util.ImagingListener;

public final class ConcurrentOperationRegistry
extends OperationRegistry {
    static String JAI_REGISTRY_FILE = "META-INF/org.eclipse.imagen.registryFile.jai";
    static String USR_REGISTRY_FILE = "META-INF/registryFile.jaiext";
    static final String VENDOR_NAME = "Vendor";
    static final String JAI_PRODUCT_NULL = "org.eclipse.imagen";
    private static final Logger LOGGER = Logger.getLogger(ConcurrentOperationRegistry.class.toString());
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    OperationCollection collection;

    public static OperationRegistry initializeRegistry() {
        try {
            InputStream url = PropertyUtil.getFileFromClasspath((String)JAI_REGISTRY_FILE);
            if (url == null) {
                throw new RuntimeException("Could not find the main registry file");
            }
            ConcurrentOperationRegistry registry = new ConcurrentOperationRegistry();
            if (url != null) {
                registry.updateFromStream(url);
            }
            registry.registerServices(null);
            List descriptors = registry.getDescriptors("rendered");
            OperationCollection input = new OperationCollection(registry);
            input.createMapFromDescriptors(descriptors);
            return registry;
        }
        catch (IOException ioe) {
            ImagingListener listener = ImageN.getDefaultInstance().getImagingListener();
            String message = "Error occurred while initializing ImageN";
            listener.errorOccurred(message, (Throwable)new ImagingException(message, (Throwable)ioe), OperationRegistry.class, false);
            return null;
        }
    }

    public String toString() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String string = super.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public void writeToStream(OutputStream out) throws IOException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            super.writeToStream(out);
        }
        finally {
            readLock.unlock();
        }
    }

    public void initializeFromStream(InputStream in) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.initializeFromStream(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void updateFromStream(InputStream in) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.updateFromStream(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.readExternal(in);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            super.writeExternal(out);
        }
        finally {
            readLock.unlock();
        }
    }

    public void removeRegistryMode(String modeName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.removeRegistryMode(modeName);
        }
        finally {
            writeLock.unlock();
        }
    }

    public String[] getRegistryModes() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getRegistryModes();
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDescriptor(RegistryElementDescriptor descriptor) {
        block10: {
            Lock writeLock = this.lock.writeLock();
            boolean changed = false;
            try {
                writeLock.lock();
                super.registerDescriptor(descriptor);
                changed = true;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Registered descriptor for the operation: " + descriptor.getName());
                }
                if (this.collection != null && changed && descriptor instanceof OperationDescriptor) {
                    OperationItem item = new OperationItem((OperationDescriptor)descriptor);
                    this.collection.substituteSingleOp(item);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Added descriptor for the operation: " + descriptor.getName() + " to the registry operation list");
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("A descriptor is already registered against the name")) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, e.getMessage());
                    }
                    break block10;
                }
                throw new RuntimeException(e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDescriptor(RegistryElementDescriptor descriptor) {
        Lock writeLock = this.lock.writeLock();
        boolean changed = false;
        try {
            writeLock.lock();
            super.unregisterDescriptor(descriptor);
            changed = true;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Unregistered descriptor for the operation: " + descriptor.getName());
            }
            if (this.collection != null && changed && descriptor instanceof OperationDescriptor) {
                OperationItem item = new OperationItem((OperationDescriptor)descriptor);
                this.collection.removeSingleOp(item);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Removed descriptor for the operation: " + descriptor.getName() + " from the registry operation list");
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryElementDescriptor getDescriptor(Class descriptorClass, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(descriptorClass, descriptorName);
            return registryElementDescriptor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescriptors(Class descriptorClass) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list = super.getDescriptors(descriptorClass);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDescriptorNames(Class descriptorClass) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getDescriptorNames(descriptorClass);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryElementDescriptor getDescriptor(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(modeName, descriptorName);
            return registryElementDescriptor;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescriptors(String modeName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list = super.getDescriptors(modeName);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDescriptorNames(String modeName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getDescriptorNames(modeName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProductPreference(String modeName, String descriptorName, String preferredProductName, String otherProductName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.setProductPreference(modeName, descriptorName, preferredProductName, otherProductName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetProductPreference(String modeName, String descriptorName, String preferredProductName, String otherProductName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unsetProductPreference(modeName, descriptorName, preferredProductName, otherProductName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProductPreferences(String modeName, String descriptorName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearProductPreferences(modeName, descriptorName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getProductPreferences(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[][] stringArray = super.getProductPreferences(modeName, descriptorName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOrderedProductList(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Vector vector = super.getOrderedProductList(modeName, descriptorName);
            return vector;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFactory(String modeName, String descriptorName, String productName, Object factory) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.registerFactory(modeName, descriptorName, productName, factory);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Registered factory for the operation: " + descriptorName);
            }
            if (this.collection != null && modeName.equalsIgnoreCase("rendered")) {
                this.collection.substituteFactory(factory, descriptorName, productName);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Added factory for the operation: " + descriptorName + " to the registry operation list");
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFactory(String modeName, String descriptorName, String productName, Object factory) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unregisterFactory(modeName, descriptorName, productName, factory);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Unregistered factory for the operation: " + descriptorName);
            }
            if (this.collection != null && modeName.equalsIgnoreCase("rendered")) {
                this.collection.removeFactory(factory, descriptorName, productName);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Removed factory for the operation: " + descriptorName + " from the registry operation list");
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFactoryPreference(String modeName, String descriptorName, String productName, Object preferredOp, Object otherOp) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.setFactoryPreference(modeName, descriptorName, productName, preferredOp, otherOp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetFactoryPreference(String modeName, String descriptorName, String productName, Object preferredOp, Object otherOp) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unsetFactoryPreference(modeName, descriptorName, productName, preferredOp, otherOp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFactoryPreferences(String modeName, String descriptorName, String productName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearFactoryPreferences(modeName, descriptorName, productName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getFactoryPreferences(String modeName, String descriptorName, String productName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object[][] objectArray = super.getFactoryPreferences(modeName, descriptorName, productName);
            return objectArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOrderedFactoryList(String modeName, String descriptorName, String productName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            List list = super.getOrderedFactoryList(modeName, descriptorName, productName);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFactoryIterator(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Iterator iterator = super.getFactoryIterator(modeName, descriptorName);
            return iterator;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFactory(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object object = super.getFactory(modeName, descriptorName);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFactory(String modeName, String descriptorName, Object[] args) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Object object = super.invokeFactory(modeName, descriptorName, args);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyGenerator(String modeName, String descriptorName, PropertyGenerator generator) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.addPropertyGenerator(modeName, descriptorName, generator);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyGenerator(String modeName, String descriptorName, PropertyGenerator generator) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.removePropertyGenerator(modeName, descriptorName, generator);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyPropertyFromSource(String modeName, String descriptorName, String propertyName, int sourceIndex) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.copyPropertyFromSource(modeName, descriptorName, propertyName, sourceIndex);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressProperty(String modeName, String descriptorName, String propertyName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.suppressProperty(modeName, descriptorName, propertyName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressAllProperties(String modeName, String descriptorName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.suppressAllProperties(modeName, descriptorName);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void clearPropertyState(String modeName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearPropertyState(modeName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGeneratedPropertyNames(String modeName, String descriptorName) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            String[] stringArray = super.getGeneratedPropertyNames(modeName, descriptorName);
            return stringArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySource getPropertySource(String modeName, String descriptorName, Object op, Vector sources) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            PropertySource propertySource = super.getPropertySource(modeName, descriptorName, op, sources);
            return propertySource;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertySource getPropertySource(OperationNode op) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            PropertySource propertySource = super.getPropertySource(op);
            return propertySource;
        }
        finally {
            readLock.unlock();
        }
    }

    public void registerServices(ClassLoader cl) throws IOException {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.registerServices(cl);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void unregisterOperationDescriptor(String operationName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.unregisterOperationDescriptor(operationName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOperationPreferences(String operationName, String productName) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            super.clearOperationPreferences(operationName, productName);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void setOperationCollection(OperationCollection coll) {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.collection = coll;
        }
        finally {
            writeLock.unlock();
        }
    }

    OperationCollection getOperationCollection() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            OperationCollection operationCollection = this.collection;
            return operationCollection;
        }
        finally {
            readLock.unlock();
        }
    }

    public Collection<OperationItem> getOperations() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Collection<OperationItem> collection = this.collection.getOperations();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    static class OperationCollection {
        private Map<String, OperationItem> map = new ConcurrentHashMap<String, OperationItem>();
        private OperationRegistry registry;

        public OperationCollection(OperationRegistry registry, Map<String, OperationItem> map) {
            this.map = map;
            this.registry = registry;
        }

        public OperationCollection(OperationRegistry registry) {
            this.registry = registry;
        }

        public OperationCollection copy() {
            Collection<OperationItem> values = this.map.values();
            OperationCollection newColl = new OperationCollection(this.registry);
            for (OperationItem item : values) {
                newColl.add(new OperationItem(item));
            }
            return newColl;
        }

        public void createMapFromDescriptors(List<OperationDescriptor> listDesc) {
            for (OperationDescriptor desc : listDesc) {
                OperationItem value = this.createItem(desc);
                this.map.put(desc.getName(), value);
            }
        }

        public OperationCollection filter(String vendor) {
            Collection<OperationItem> values = this.map.values();
            OperationCollection filtered = new OperationCollection(this.registry);
            for (OperationItem item : values) {
                if (!item.getVendor().equalsIgnoreCase(vendor)) continue;
                filtered.map.put(item.getName(), item);
            }
            return filtered;
        }

        public void add(OperationItem item) {
            this.map.put(item.getName(), item);
        }

        public void add(Map<String, OperationItem> items) {
            this.map.putAll(items);
        }

        public OperationItem get(String decriptorname) {
            return this.map.get(decriptorname);
        }

        public Collection<OperationItem> getOperations() {
            return this.map.values();
        }

        public OperationItem createItem(OperationDescriptor desc) {
            OperationItem value = new OperationItem(desc);
            List list = this.registry.getOrderedFactoryList("rendered", desc.getName(), value.getVendor());
            if (list != null) {
                for (Object factory : list) {
                    value.setFactory(factory);
                }
            }
            return value;
        }

        void substituteOperations(OperationCollection changedOps) {
            Map<String, OperationItem> mapChanged = changedOps.map;
            Collection<OperationItem> items = mapChanged.values();
            for (OperationItem item : items) {
                this.substituteDescriptors(item);
                this.map.put(item.getName(), item);
            }
        }

        private void substituteDescriptors(OperationItem changedOp) {
            OperationItem operationItem = this.map.get(changedOp.getName());
            boolean present = operationItem != null && !operationItem.getVendor().equalsIgnoreCase(changedOp.getVendor());
            Object factory = changedOp.getCurrentFactory();
            if (present) {
                boolean registerFactory;
                Object currentFactory = operationItem.getCurrentFactory();
                boolean bl = registerFactory = factory == null || currentFactory != null && !currentFactory.getClass().isAssignableFrom(factory.getClass());
                if (currentFactory == null || registerFactory) {
                    // empty if block
                }
                this.registry.unregisterDescriptor((RegistryElementDescriptor)operationItem.getDescriptor());
                this.registry.registerDescriptor((RegistryElementDescriptor)changedOp.getDescriptor());
                if (factory != null) {
                    this.registry.registerFactory("rendered", changedOp.getDescriptor().getName(), changedOp.getVendor(), changedOp.getCurrentFactory());
                }
            } else if (operationItem == null) {
                this.registry.registerDescriptor((RegistryElementDescriptor)changedOp.getDescriptor());
                if (changedOp.getCurrentFactory() != null) {
                    this.registry.registerFactory("rendered", changedOp.getDescriptor().getName(), changedOp.getVendor(), changedOp.getCurrentFactory());
                }
            }
        }

        public void substituteSingleOp(OperationItem changedOp) {
            this.map.put(changedOp.getName(), changedOp);
        }

        public void substituteFactory(Object factory, String descriptorName, String vendor) {
            boolean present;
            OperationItem item = this.map.get(descriptorName);
            boolean bl = present = item != null && item.getVendor().equalsIgnoreCase(vendor);
            if (present) {
                if (factory.getClass().getName().contains("Mlib")) {
                    item.setMlibFactory(factory);
                    item.setMlibPreference(true);
                } else {
                    item.setFactory(factory);
                    item.setMlibPreference(false);
                }
            } else {
                RegistryElementDescriptor desc = this.registry.getDescriptor("rendered", descriptorName);
                if (desc != null && desc instanceof OperationDescriptor) {
                    try {
                        OperationItem itemNew = new OperationItem((OperationDescriptor)desc);
                        if (factory.getClass().getName().contains("Mlib")) {
                            itemNew.setMlibFactory(factory);
                            itemNew.setMlibPreference(true);
                        } else {
                            itemNew.setFactory(factory);
                            itemNew.setMlibPreference(false);
                        }
                        this.map.put(descriptorName, itemNew);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unable to register the Factory for the following descriptor: " + descriptorName, e);
                    }
                } else {
                    throw new IllegalArgumentException("Unable to register the Factory for the following descriptor: " + descriptorName);
                }
            }
        }

        public void removeSingleOp(OperationItem operationItem) {
            this.map.remove(operationItem.getName());
        }

        public void removeFactory(Object factory, String descriptorName, String productName) {
            boolean present;
            OperationItem item = this.map.get(descriptorName);
            boolean bl = present = item != null && item.getVendor().equalsIgnoreCase(productName);
            if (present) {
                item.setFactory(null);
                item.setMlibFactory(null);
                item.setMlibPreference(false);
            } else {
                RegistryElementDescriptor desc = this.registry.getDescriptor("rendered", descriptorName);
                if (desc != null && desc instanceof OperationDescriptor) {
                    OperationItem itemNew = new OperationItem((OperationDescriptor)desc);
                    this.map.put(descriptorName, itemNew);
                } else {
                    throw new IllegalArgumentException("Unable to unregister the Factory for the following descriptor: " + descriptorName);
                }
            }
        }
    }

    public static class OperationItem {
        private OperationDescriptor op;
        private String vendor;
        private String opName;
        private Object factory;
        private Object mlibFactory;
        private boolean isMediaLibPreferred;

        public OperationItem(OperationDescriptor op) {
            this.op = op;
            this.opName = op.getName();
            this.vendor = op.getResourceBundle(null).getString(ConcurrentOperationRegistry.VENDOR_NAME);
            this.isMediaLibPreferred = false;
        }

        public OperationItem(OperationItem item) {
            this.op = item.getDescriptor();
            this.opName = item.getName();
            this.vendor = item.getVendor();
            this.factory = item.getFactory();
            this.mlibFactory = item.getMlibFactory();
            this.isMediaLibPreferred = item.isMediaLibPreferred;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getName() {
            return this.opName;
        }

        public OperationDescriptor getDescriptor() {
            return this.op;
        }

        public Object getCurrentFactory() {
            if (this.mlibFactory != null && this.isMediaLibPreferred) {
                return this.mlibFactory;
            }
            return this.factory;
        }

        public Object getFactory() {
            return this.factory;
        }

        public Object getMlibFactory() {
            return this.mlibFactory;
        }

        public OperationDescriptor getOp() {
            return this.op;
        }

        public boolean isMediaLibPreferred() {
            return this.isMediaLibPreferred;
        }

        public void setFactory(Object factory) {
            this.factory = factory;
        }

        public void setMlibFactory(Object factory) {
            this.mlibFactory = factory;
        }

        public void setMlibPreference(boolean preferred) {
            this.isMediaLibPreferred = preferred;
        }
    }
}

