/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.RegistryElementDescriptor;
import org.eclipse.imagen.RegistryMode;
import org.eclipse.imagen.media.ConcurrentOperationRegistry;

class RegistryFileParser {
    private static final Logger LOGGER = Logger.getLogger(RegistryFileParser.class.toString());
    private URL url;
    private InputStream is;
    private ClassLoader classLoader;
    private BufferedReader reader;
    private static String[][] aliases = new String[][]{{"odesc", "descriptor"}, {"rif", "rendered"}, {"crif", "renderable"}, {"cif", "collection"}};
    private boolean headerLinePrinted = false;

    static Map<String, ConcurrentOperationRegistry.OperationItem> parseFile(ClassLoader cl, URL url) throws IOException {
        return new RegistryFileParser(cl, url).parseFile();
    }

    private RegistryFileParser(ClassLoader cl, URL url) throws IOException {
        this.is = url.openStream();
        this.url = null;
        this.classLoader = cl;
        this.reader = new BufferedReader(new InputStreamReader(this.is));
    }

    private String mapName(String key) {
        for (int i = 0; i < aliases.length; ++i) {
            if (!key.equalsIgnoreCase(aliases[i][0])) continue;
            return aliases[i][1];
        }
        return key;
    }

    private Object getInstance(String className) {
        try {
            Class<?> descriptorClass = null;
            String errorMsg = null;
            if (this.classLoader != null) {
                try {
                    descriptorClass = Class.forName(className, true, this.classLoader);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    errorMsg = e.getMessage();
                }
            }
            if (descriptorClass == null) {
                try {
                    descriptorClass = Class.forName(className);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    errorMsg = e.getMessage();
                }
            }
            if (descriptorClass == null) {
                try {
                    descriptorClass = Class.forName(className, true, ClassLoader.getSystemClassLoader());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    errorMsg = e.getMessage();
                }
            }
            if (descriptorClass == null) {
                this.registryFileError(errorMsg);
                return null;
            }
            return descriptorClass.newInstance();
        }
        catch (Exception e) {
            this.registryFileError(e.getMessage());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    Map<String, ConcurrentOperationRegistry.OperationItem> parseFile() throws IOException {
        String[] keys;
        HashMap<String, ConcurrentOperationRegistry.OperationItem> operations = new HashMap<String, ConcurrentOperationRegistry.OperationItem>();
        while ((keys = this.getNextLine()) != null) {
            String key = this.mapName(keys[0]);
            if (key.equalsIgnoreCase("descriptor")) {
                RegistryElementDescriptor red = (RegistryElementDescriptor)this.getInstance(keys[1]);
                if (red == null || !(red instanceof OperationDescriptor)) continue;
                OperationDescriptor desc = (OperationDescriptor)red;
                operations.put(desc.getName(), new ConcurrentOperationRegistry.OperationItem(desc));
                continue;
            }
            RegistryMode mode = RegistryMode.getMode((String)key);
            if (mode != null) {
                Object factory = this.getInstance(keys[1]);
                if (!mode.getName().equalsIgnoreCase("rendered") || factory == null) continue;
                ((ConcurrentOperationRegistry.OperationItem)operations.get(keys[3])).setFactory(factory);
                continue;
            }
            if (key.equalsIgnoreCase("registryMode") || key.equalsIgnoreCase("pref") || key.equalsIgnoreCase("productPref")) continue;
            this.registryFileError("Can not parse line");
        }
        this.reader.close();
        this.is.close();
        return operations;
    }

    private String[] getNextLine() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("\\s")) {
                return this.getNextLine();
            }
            String[] split = line.split("\\s");
            String[] corrected = new String[split.length];
            int count = 0;
            for (int i = 0; i < split.length; ++i) {
                if (split[i].equals("\\s") || split[i].isEmpty()) continue;
                corrected[count] = split[i];
                ++count;
            }
            return corrected;
        }
        return null;
    }

    private void registryFileError(String msg) {
        if (!this.headerLinePrinted) {
            if (this.url != null) {
                this.errorMsg("Error while parsing ImageN registry file " + this.url.getPath(), null);
            }
            this.headerLinePrinted = true;
        }
        if (msg != null) {
            this.errorMsg(msg, null);
        }
    }

    private void errorMsg(String key, Object[] args) {
        MessageFormat mf = new MessageFormat(key);
        mf.setLocale(Locale.getDefault());
        LOGGER.log(Level.SEVERE, mf.format(args));
    }
}

