/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.numeric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.imagen.media.numeric.CompareOp;

public class SampleStats {
    public static double max(Double[] values, boolean ignoreNaN) {
        if (values == null || values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return values[0];
        }
        TreeSet<Double> set = new TreeSet<Double>();
        set.addAll(Arrays.asList(values));
        if (ignoreNaN) {
            set.remove(Double.NaN);
        }
        return (Double)set.last();
    }

    public static double mean(Double[] values, boolean ignoreNaN) {
        if (values == null || values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return values[0];
        }
        double sum = 0.0;
        int n = 0;
        for (Double val : values) {
            if (val.isNaN()) {
                if (ignoreNaN) continue;
                return Double.NaN;
            }
            sum += val.doubleValue();
            ++n;
        }
        return sum / (double)n;
    }

    public static double min(Double[] values, boolean ignoreNaN) {
        if (values == null || values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return values[0];
        }
        TreeSet<Double> set = new TreeSet<Double>();
        set.addAll(Arrays.asList(values));
        if (ignoreNaN) {
            set.remove(Double.NaN);
        }
        return (Double)set.first();
    }

    public static double median(Double[] values, boolean ignoreNaN) {
        if (values == null) {
            return Double.NaN;
        }
        ArrayList<Double> nonNaNValues = new ArrayList<Double>();
        nonNaNValues.addAll(Arrays.asList(values));
        if (ignoreNaN) {
            while (nonNaNValues.remove(Double.NaN)) {
            }
        }
        if (nonNaNValues.isEmpty()) {
            return Double.NaN;
        }
        if (nonNaNValues.size() == 1) {
            return (Double)nonNaNValues.get(0);
        }
        if (nonNaNValues.size() == 2) {
            return ((Double)nonNaNValues.get(0) + (Double)nonNaNValues.get(1)) / 2.0;
        }
        Collections.sort(nonNaNValues);
        int midHi = nonNaNValues.size() / 2;
        int midLo = midHi - 1;
        boolean even = nonNaNValues.size() % 2 == 0;
        Double result = 0.0;
        int k = 0;
        for (Double val : nonNaNValues) {
            if (k == midHi) {
                if (!even) {
                    return val;
                }
                result = result + val;
                return result / 2.0;
            }
            if (even && k == midLo) {
                result = result + val;
            }
            ++k;
        }
        return 0.0;
    }

    public static double mode(Double[] values, boolean ignoreNaN) {
        if (values == null) {
            return Double.NaN;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        list.addAll(Arrays.asList(values));
        if (ignoreNaN) {
            while (list.remove(Double.NaN)) {
            }
        }
        if (list.isEmpty()) {
            return Double.NaN;
        }
        if (list.size() == 1) {
            return (Double)list.get(0);
        }
        Collections.sort(list);
        ArrayList<Double> uniqueValues = new ArrayList<Double>();
        ArrayList<Integer> freq = new ArrayList<Integer>();
        Double curVal = (Double)list.get(0);
        int curFreq = 1;
        int maxFreq = 1;
        for (int i = 1; i < list.size(); ++i) {
            if (CompareOp.aequal(curVal, (Double)list.get(i))) {
                ++curFreq;
                continue;
            }
            uniqueValues.add(curVal);
            freq.add(curFreq);
            curVal = (Double)list.get(i);
            if (curFreq > maxFreq) {
                maxFreq = curFreq;
            }
            curFreq = 1;
        }
        uniqueValues.add(curVal);
        freq.add(curFreq);
        if (curFreq > maxFreq) {
            maxFreq = curFreq;
        }
        ArrayList<Integer> maxFreqIndices = new ArrayList<Integer>();
        int k = 0;
        for (Integer f : freq) {
            if (f == maxFreq) {
                maxFreqIndices.add(k);
            }
            ++k;
        }
        if (maxFreqIndices.size() == 1) {
            return (Double)uniqueValues.get((Integer)maxFreqIndices.get(0));
        }
        boolean even = maxFreqIndices.size() % 2 == 0;
        int i = maxFreqIndices.size() / 2;
        if (even) {
            --i;
        }
        return (Double)uniqueValues.get((Integer)maxFreqIndices.get(i));
    }

    public static double range(Double[] values, boolean ignoreNaN) {
        if (values == null || values.length == 0) {
            return Double.NaN;
        }
        if (values.length == 1) {
            return 0.0;
        }
        TreeSet<Double> set = new TreeSet<Double>();
        set.addAll(Arrays.asList(values));
        if (ignoreNaN) {
            set.remove(Double.NaN);
        }
        return (Double)set.last() - (Double)set.first();
    }

    public static double variance(Double[] values, boolean ignoreNaN) {
        if (values.length < 2) {
            return Double.NaN;
        }
        double mOld = 0.0;
        double s = 0.0;
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            double mNew;
            if (Double.isNaN(values[i])) {
                if (ignoreNaN) continue;
                return Double.NaN;
            }
            if (++n == 1) {
                mNew = mOld = values[i].doubleValue();
                continue;
            }
            mNew = mOld + (values[i] - mOld) / (double)n;
            s += (values[i] - mOld) * (values[i] - mNew);
            mOld = mNew;
        }
        if (n > 1) {
            return s / (double)(n - 1);
        }
        if (n == 1) {
            return 0.0;
        }
        return Double.NaN;
    }

    public static double sdev(Double[] values, boolean ignoreNaN) {
        double var = SampleStats.variance(values, ignoreNaN);
        return Double.isNaN(var) ? Double.NaN : Math.sqrt(var);
    }

    public static double sum(Double[] values, boolean ignoreNaN) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) {
                if (ignoreNaN) continue;
                return Double.NaN;
            }
            sum += values[i].doubleValue();
        }
        return sum;
    }
}

