/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.range;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.media.range.RangeFactory;

public abstract class Range {
    private static final Logger LOGGER = Logger.getLogger(Range.class.toString());
    private static final int PRIME_NUMBER = 37;
    protected boolean isMinIncluded;
    protected boolean isMaxIncluded;

    Range(boolean isMinIncluded, boolean isMaxIncluded) {
        this.isMaxIncluded = isMaxIncluded;
        this.isMinIncluded = isMinIncluded;
    }

    public boolean contains(byte value) {
        return this.containsN(value);
    }

    public boolean contains(short value) {
        return this.containsN(value);
    }

    public boolean contains(int value) {
        return this.containsN(value);
    }

    public boolean contains(float value) {
        return this.containsN(Float.valueOf(value));
    }

    public boolean contains(double value) {
        return this.containsN(value);
    }

    public boolean contains(long value) {
        return this.containsN(value);
    }

    public <T extends Number> boolean containsN(T value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Wrong data type tested: Input: " + String.valueOf(value.getClass()) + ", output: " + String.valueOf(this.getDataType().getClassValue()));
        }
        int dataType = this.getDataType().getDataType();
        switch (dataType) {
            case 0: {
                return this.contains(value.byteValue());
            }
            case 1: 
            case 2: {
                return this.contains(value.shortValue());
            }
            case 3: {
                return this.contains(value.intValue());
            }
            case 4: {
                return this.contains(value.floatValue());
            }
            case 5: {
                return this.contains(value.doubleValue());
            }
            case 6: {
                return this.contains(value.longValue());
            }
        }
        throw new IllegalArgumentException("Wrong data type");
    }

    public boolean contains(Range other) {
        boolean maxEquals;
        boolean maxContains;
        if (this.isNaN() && !other.isNaN()) {
            return false;
        }
        if (other.isNaN()) {
            return this.isNanIncluded();
        }
        double min1 = this.getMin().doubleValue();
        double max1 = this.getMax().doubleValue();
        double min2 = other.getMin().doubleValue();
        double max2 = other.getMax().doubleValue();
        boolean minContains = min1 < min2;
        boolean bl = maxContains = max1 > max2;
        if (minContains && maxContains) {
            return true;
        }
        boolean minEquals = min1 == min2;
        boolean bl2 = maxEquals = max1 == max2;
        if (!minContains && minEquals) {
            boolean bl3 = minContains = this.isMinIncluded() && other.isMinIncluded();
        }
        if (!maxContains && maxEquals) {
            boolean bl4 = maxContains = this.isMaxIncluded() && other.isMaxIncluded();
        }
        return minContains && maxContains;
    }

    public boolean intersects(Range other) {
        boolean minCheck;
        if (this.contains(other) || other.contains(this)) {
            return true;
        }
        double min1 = this.getMin().doubleValue();
        double max1 = this.getMax().doubleValue();
        double min2 = other.getMin().doubleValue();
        double max2 = other.getMax().doubleValue();
        boolean bl = this.isMinIncluded() && other.isMaxIncluded() ? min1 <= max2 : (minCheck = min1 < max2);
        boolean maxCheck = this.isMaxIncluded() && other.isMinIncluded() ? max1 >= min2 : max1 > min2;
        return minCheck && maxCheck;
    }

    public abstract Range intersection(Range var1);

    public abstract Range union(Range var1);

    public abstract DataType getDataType();

    public abstract boolean isPoint();

    public abstract Number getMax();

    public abstract Number getMin();

    public abstract Number getMax(boolean var1);

    public abstract Number getMin(boolean var1);

    public boolean isNanIncluded() {
        return true;
    }

    public boolean isNaN() {
        return false;
    }

    public boolean isMaxIncluded() {
        return this.isMaxIncluded;
    }

    public boolean isMinIncluded() {
        return this.isMinIncluded;
    }

    protected void setMinIncluded(boolean isMinIncluded) {
        this.isMinIncluded = isMinIncluded;
    }

    protected void setMaxIncluded(boolean isMaxIncluded) {
        this.isMaxIncluded = isMaxIncluded;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range r1 = (Range)obj;
        if (r1.getDataType() != this.getDataType()) {
            return false;
        }
        if (r1.isPoint() != this.isPoint()) {
            return false;
        }
        if (r1.isMaxIncluded() != this.isMaxIncluded()) {
            return false;
        }
        if (r1.isPoint() != this.isMinIncluded()) {
            return false;
        }
        if (r1.getMin().doubleValue() != this.getMin().doubleValue()) {
            return false;
        }
        if (r1.getMax().doubleValue() != this.getMax().doubleValue()) {
            return false;
        }
        return r1.isNanIncluded() == this.isNanIncluded();
    }

    public int compare(Range other) {
        if (this.equals(other)) {
            return 0;
        }
        double min1 = this.getMin().doubleValue();
        double min2 = other.getMin().doubleValue();
        double max1 = this.getMax().doubleValue();
        double max2 = other.getMax().doubleValue();
        if (!RangeFactory.equals(min1, min2)) {
            if (min1 < min2) {
                return -1;
            }
            return 1;
        }
        if (this.isMinIncluded() && other.isMinIncluded()) {
            if (RangeFactory.equals(max1, max2)) {
                if (this.isMaxIncluded() && other.isMaxIncluded()) {
                    return 0;
                }
                if (this.isMaxIncluded()) {
                    return 1;
                }
                return -1;
            }
            if (max1 < max2) {
                return -1;
            }
            return 1;
        }
        if (this.isMinIncluded()) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int result = 37;
        result += ((Object)((Object)this.getDataType())).getClass().hashCode();
        result = Range.hash(this.isMaxIncluded, result);
        result = Range.hash(this.isMinIncluded, result);
        result = Range.hash(this.getMax().doubleValue(), result);
        result = Range.hash(this.getMin().doubleValue(), result);
        return result;
    }

    public static int hash(boolean value, int seed) {
        return seed * 37 + (value ? 1231 : 1237);
    }

    public static int hash(double value, int seed) {
        return Range.hash(Double.doubleToLongBits(value), seed);
    }

    public static int hash(long value, int seed) {
        return seed * 37 + ((int)value ^ (int)(value >>> 32));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        if (this.isMinIncluded()) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        sb.append(this.getMin()).append(", ").append(this.getMax());
        if (this.isMaxIncluded()) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        return sb.toString();
    }

    public static enum DataType {
        BYTE(Byte.class, 0),
        USHORT(Short.class, 1),
        SHORT(Short.class, 2),
        INTEGER(Integer.class, 3),
        FLOAT(Float.class, 4),
        DOUBLE(Double.class, 5),
        LONG(Long.class, 6);

        private Class<? extends Number> classType;
        private int dataType;

        private DataType(Class<? extends Number> classType, int dataType) {
            this.classType = classType;
            this.dataType = dataType;
        }

        public Class<? extends Number> getClassValue() {
            return this.classType;
        }

        public int getDataType() {
            return this.dataType;
        }

        public static int dataTypeFromClass(Class<?> classType) {
            if (classType == BYTE.getClassValue()) {
                return BYTE.getDataType();
            }
            if (classType == SHORT.getClassValue()) {
                return SHORT.getDataType();
            }
            if (classType == INTEGER.getClassValue()) {
                return INTEGER.getDataType();
            }
            if (classType == FLOAT.getClassValue()) {
                return FLOAT.getDataType();
            }
            if (classType == DOUBLE.getClassValue()) {
                return DOUBLE.getDataType();
            }
            if (classType == LONG.getClassValue()) {
                return LONG.getDataType();
            }
            throw new IllegalArgumentException("This class does not belong to the already existing classes");
        }

        public static Class<? extends Number> classFromType(int dataType) {
            switch (dataType) {
                case 0: {
                    return Byte.class;
                }
                case 1: 
                case 2: {
                    return Short.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Float.class;
                }
                case 5: {
                    return Double.class;
                }
                case 6: {
                    return Long.class;
                }
            }
            return null;
        }
    }
}

