/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.range;

import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.utilities.ImageUtilities;

public class RangeLong
extends Range {
    public static RangeLong FULL_RANGE = new RangeLong(Long.MIN_VALUE, true, Long.MAX_VALUE, true);
    private final long minValue;
    private final long maxValue;
    private final boolean isPoint;

    RangeLong(long minValue, boolean minIncluded, long maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMaxIncluded(true);
            this.setMinIncluded(true);
        }
    }

    @Override
    public boolean contains(long value) {
        boolean lower;
        if (this.isPoint) {
            return this.minValue == value;
        }
        if (this.isMinIncluded()) {
            lower = value < this.minValue;
        } else {
            boolean bl = lower = value <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
        return !lower && !upper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.LONG;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Long getMax() {
        return this.maxValue;
    }

    @Override
    public Long getMin() {
        return this.minValue;
    }

    @Override
    public Long getMax(boolean isMaxIncluded) {
        long value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (long)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public Long getMin(boolean isMinIncluded) {
        long value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (long)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public RangeLong union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return (RangeLong)RangeFactory.convert(other, Range.DataType.LONG);
        }
        long min2 = other.getMin().longValue();
        long max2 = other.getMax().longValue();
        long finalMin = this.minValue;
        long finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeLong(finalMin, minIncluded, finalMax, maxIncluded);
    }

    @Override
    public RangeLong intersection(Range other) {
        if (other.getDataType() == this.getDataType()) {
            if (other.contains(this)) {
                return this;
            }
            if (this.contains(other)) {
                return (RangeLong)RangeFactory.convert(other, Range.DataType.LONG);
            }
        }
        long minOther = other.getMin().longValue();
        long maxOther = other.getMax().longValue();
        long finalMin = this.minValue;
        long finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (minOther > this.minValue) {
            finalMin = minOther;
            minIncluded = other.isMinIncluded();
        } else if (minOther == this.minValue) {
            minIncluded &= other.isMinIncluded();
        }
        if (maxOther < this.maxValue) {
            finalMax = maxOther;
            maxIncluded = other.isMaxIncluded();
        } else if (maxOther == this.maxValue) {
            maxIncluded &= other.isMaxIncluded();
        }
        if (finalMax < finalMin || finalMax == finalMin && !minIncluded && !maxIncluded) {
            return null;
        }
        return new RangeLong(finalMin, minIncluded, finalMax, maxIncluded);
    }
}

