/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.range;

import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.utilities.ImageUtilities;

public class RangeShort
extends Range {
    public static RangeShort FULL_RANGE = new RangeShort(Short.MIN_VALUE, true, Short.MAX_VALUE, true);
    private final short minValue;
    private final short maxValue;
    private final boolean isPoint;

    RangeShort(short minValue, boolean minIncluded, short maxValue, boolean maxIncluded) {
        super(minIncluded, maxIncluded);
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.setMinIncluded(true);
            this.setMaxIncluded(true);
        }
    }

    @Override
    public boolean contains(short value) {
        boolean lower;
        if (this.isPoint) {
            return this.minValue == value;
        }
        if (this.isMinIncluded()) {
            lower = value < this.minValue;
        } else {
            boolean bl = lower = value <= this.minValue;
        }
        boolean upper = this.isMaxIncluded() ? value > this.maxValue : value >= this.maxValue;
        return !lower && !upper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.SHORT;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Short getMax() {
        return this.maxValue;
    }

    @Override
    public Short getMin() {
        return this.minValue;
    }

    @Override
    public Short getMax(boolean isMaxIncluded) {
        short value = this.maxValue;
        if (isMaxIncluded != this.isMaxIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMaxIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public Short getMin(boolean isMinIncluded) {
        short value = this.minValue;
        if (isMinIncluded != this.isMinIncluded()) {
            value = (short)ImageUtilities.rool(this.getDataType().getClassValue(), value, isMinIncluded ? -1 : 1);
        }
        return value;
    }

    @Override
    public RangeShort union(Range other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return (RangeShort)RangeFactory.convert(other, 2);
        }
        short min2 = other.getMin().shortValue();
        short max2 = other.getMax().shortValue();
        short finalMin = this.minValue;
        short finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (min2 < this.minValue) {
            finalMin = min2;
            minIncluded = other.isMinIncluded();
        } else if (min2 == this.minValue) {
            minIncluded |= other.isMinIncluded();
        }
        if (max2 > this.maxValue) {
            finalMax = max2;
            maxIncluded = other.isMaxIncluded();
        } else if (max2 == this.maxValue) {
            maxIncluded |= other.isMaxIncluded();
        }
        return new RangeShort(finalMin, minIncluded, finalMax, maxIncluded);
    }

    @Override
    public RangeShort intersection(Range other) {
        if (other.getDataType() == this.getDataType()) {
            if (other.contains(this)) {
                return this;
            }
            if (this.contains(other)) {
                return (RangeShort)RangeFactory.convert(other, 2);
            }
        }
        int minOther = other.getMin().intValue();
        int maxOther = other.getMax().intValue();
        int finalMin = this.minValue;
        int finalMax = this.maxValue;
        boolean minIncluded = this.isMinIncluded();
        boolean maxIncluded = this.isMaxIncluded();
        if (minOther > this.minValue) {
            finalMin = minOther;
            minIncluded = other.isMinIncluded();
        } else if (minOther == this.minValue) {
            minIncluded &= other.isMinIncluded();
        }
        if (maxOther < this.maxValue) {
            finalMax = maxOther;
            maxIncluded = other.isMaxIncluded();
        } else if (maxOther == this.maxValue) {
            maxIncluded &= other.isMaxIncluded();
        }
        if (finalMax < finalMin || finalMax == finalMin && !minIncluded && !maxIncluded) {
            return null;
        }
        return new RangeShort((short)finalMin, minIncluded, (short)finalMax, maxIncluded);
    }
}

