/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.RenderedImage;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.eclipse.imagen.media.swing.ImagePane;

public class ImageFrame
extends JFrame {
    private JTextField statusBar;
    private StringBuilder sb;

    public static void showImage(RenderedImage img, String title) {
        ImageFrame.showImage(img, title, true);
    }

    public static void showImage(final RenderedImage img, final String title, boolean exitOnClose) {
        if (SwingUtilities.isEventDispatchThread()) {
            ImageFrame.doShowImage(img, title);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageFrame.doShowImage(img, title);
                }
            });
        }
    }

    private static void doShowImage(RenderedImage img, String title) {
        ImageFrame f = new ImageFrame(img, title);
        f.setVisible(true);
    }

    public ImageFrame(RenderedImage img, String title) {
        this(img, null, title);
    }

    public ImageFrame(RenderedImage displayImg, RenderedImage dataImg, String title) {
        this.setTitle(title);
        this.setDefaultCloseOperation(3);
        this.setLocationByPlatform(true);
        ImagePane pane = new ImagePane(this, displayImg, dataImg);
        this.getContentPane().add((Component)pane, "Center");
        this.sb = new StringBuilder();
        this.statusBar = new JTextField();
        this.statusBar.setEditable(false);
        this.statusBar.setMinimumSize(new Dimension(100, 30));
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
        this.setSize(500, 500);
    }

    void setCursorInfo(Point imagePos, int[] imageValues) {
        Number[] values = new Integer[imageValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = imageValues[i];
        }
        this.doSetCursorInfo(imagePos, values, "%d");
    }

    void setCursorInfo(Point imagePos, double[] imageValues) {
        Number[] values = new Double[imageValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Double(imageValues[i]);
        }
        this.doSetCursorInfo(imagePos, values, "%.4f");
    }

    private void doSetCursorInfo(Point imagePos, Number[] imageValues, String fmt) {
        this.sb.setLength(0);
        this.sb.append("x:").append(imagePos.x).append(" y:").append(imagePos.y);
        int len = imageValues.length;
        if (len == 1) {
            this.sb.append("  value:");
        } else {
            this.sb.append("  values:");
        }
        for (int i = 0; i < len; ++i) {
            this.sb.append(" ").append(String.format(fmt, imageValues[i]));
        }
        this.setStatusText(this.sb.toString());
    }

    public void setStatusText(String text) {
        this.statusBar.setText(text);
    }
}

