/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.Transaction;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.data.postgis.SimplificationMethod;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;
import org.postgresql.jdbc.SslMode;

public class PostgisNGDataStoreFactory
extends JDBCDataStoreFactory {
    static final Logger LOGGER = Logging.getLogger(PostgisNGDataStoreFactory.class);
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"postgis", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)5432);
    public static final DataAccessFactory.Param SCHEMA = new DataAccessFactory.Param("schema", String.class, "Schema", false, (Object)"public");
    public static final DataAccessFactory.Param CREATE_DB_IF_MISSING = new DataAccessFactory.Param("create database", Boolean.class, "Creates the database if it does not exist yet", false, (Object)false, new Object[]{"level", "advanced"});
    public static final DataAccessFactory.Param CREATE_PARAMS = new DataAccessFactory.Param("create database params", String.class, "Extra specifications appended to the CREATE DATABASE command", false, (Object)"", new Object[]{"level", "advanced"});
    public static final DataAccessFactory.Param PREPARED_STATEMENTS = new DataAccessFactory.Param("preparedStatements", Boolean.class, "Use prepared statements", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param ENCODE_FUNCTIONS = new DataAccessFactory.Param("encode functions", Boolean.class, "set to true to have a set of filter functions be translated directly in SQL. Due to differences in the type systems the result might not be the same as evaluating them in memory, including the SQL failing with errors while the in memory version works fine. However this allows to push more of the filter into the database, increasing performance.the postgis table.", false, (Object)Boolean.TRUE, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param SIMPLIFY = new DataAccessFactory.Param("Support on the fly geometry simplification", Boolean.class, "When enabled, operations such as map rendering will pass a hint that will enable the usage of a simplification function", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param SIMPLIFICATION_METHOD = new DataAccessFactory.Param("Method used to simplify geometries", SimplificationMethod.class, "Allows choosing the PostGIS simplification function to use, between ST_Simplify and ST_SimplifyPreserveTopology", false, (Object)SimplificationMethod.FAST, (Map)new KVP(new Object[]{"options", Arrays.asList(SimplificationMethod.values())}));
    public static final DataAccessFactory.Param SSL_MODE = new DataAccessFactory.Param("SSL mode", SslMode.class, "The connection SSL mode", false, (Object)SslMode.DISABLE, (Map)new KVP(new Object[]{"options", Arrays.asList(SslMode.values())}));
    public static final DataAccessFactory.Param REWRITE_BATCHED_INSERTS = new DataAccessFactory.Param("reWriteBatchedInserts", Boolean.class, "This will change batch inserts from INSERT INTO foo (col1, col2, col3) VALUES (1, 2, 3) to INSERT INTO foo (col1, col2, col3) VALUES (1, 2, 3), (4, 5, 6) . When setting this parameter to true, you should also set the parameter BATCH_INSERT_SIZE = 1000. Enabling this parameter and setting BATCH_INSERT_SIZE too low may result in decreased insert performance.", false, (Object)Boolean.FALSE);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore, Map<String, ?> params) {
        PostGISDialect dialect;
        block3: {
            dialect = new PostGISDialect(dataStore);
            try {
                if (Boolean.TRUE.equals(PREPARED_STATEMENTS.lookUp(params))) {
                    return new PostGISPSDialect(dataStore, dialect);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to lookup prepared statement parameter, continuing with non prepared dialect", e);
            }
        }
        return dialect;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new PostGISDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)PostgisNGDataStoreFactory.DBTYPE.sample;
    }

    public String getDisplayName() {
        return "PostGIS";
    }

    public String getDescription() {
        return "PostGIS Database";
    }

    protected String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    protected boolean checkDBType(Map<String, ?> params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.postgis.PostgisDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "postgisng");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        Boolean simplify;
        PostGISDialect dialect;
        SQLDialect genericDialect = dataStore.getSQLDialect();
        if (genericDialect instanceof PostGISPSDialect) {
            PostGISPSDialect sDialect = (PostGISPSDialect)genericDialect;
            dialect = sDialect.getDelegate();
        } else {
            dialect = (PostGISDialect)dataStore.getSQLDialect();
        }
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        Boolean encodeFunctions = (Boolean)ENCODE_FUNCTIONS.lookUp(params);
        dialect.setFunctionEncodingEnabled(encodeFunctions == null || encodeFunctions != false);
        Boolean usePs = (Boolean)PREPARED_STATEMENTS.lookUp(params);
        if (Boolean.TRUE.equals(usePs)) {
            dataStore.setSQLDialect((SQLDialect)new PostGISPSDialect(dataStore, dialect));
        }
        dialect.setSimplifyEnabled((simplify = (Boolean)SIMPLIFY.lookUp(params)) == null || simplify != false);
        SimplificationMethod simplificationMethod = (SimplificationMethod)((Object)SIMPLIFICATION_METHOD.lookUp(params));
        dialect.setTopologyPreserved(SimplificationMethod.PRESERVETOPOLOGY.equals((Object)simplificationMethod));
        Boolean encodeBBOXAsEnvelope = false;
        String largeGeometriesOptimized = System.getProperty("org.geotools.data.postgis.largeGeometriesOptimize");
        if (largeGeometriesOptimized != null) {
            encodeBBOXAsEnvelope = largeGeometriesOptimized.toLowerCase().equals("true");
        }
        dialect.setEncodeBBOXFilterAsEnvelope(Boolean.TRUE.equals(encodeBBOXAsEnvelope));
        Connection cx = dataStore.getConnection(Transaction.AUTO_COMMIT);
        try {
            LOGGER.finest("escaping backslashes: " + dialect.isEscapeBackslash());
        }
        finally {
            dataStore.closeSafe(cx);
        }
        return dataStore;
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.put(PostgisNGDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(PostgisNGDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(PostgisNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(PostgisNGDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(PostgisNGDataStoreFactory.PORT.key, PORT);
        parameters.put(PostgisNGDataStoreFactory.SSL_MODE.key, SSL_MODE);
        parameters.put(PostgisNGDataStoreFactory.PREPARED_STATEMENTS.key, PREPARED_STATEMENTS);
        parameters.put(PostgisNGDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(PostgisNGDataStoreFactory.ENCODE_FUNCTIONS.key, ENCODE_FUNCTIONS);
        parameters.put(PostgisNGDataStoreFactory.SIMPLIFY.key, SIMPLIFY);
        parameters.put(PostgisNGDataStoreFactory.SIMPLIFICATION_METHOD.key, SIMPLIFICATION_METHOD);
        parameters.put(PostgisNGDataStoreFactory.CREATE_DB_IF_MISSING.key, CREATE_DB_IF_MISSING);
        parameters.put(PostgisNGDataStoreFactory.CREATE_PARAMS.key, CREATE_PARAMS);
        parameters.put(PostgisNGDataStoreFactory.REWRITE_BATCHED_INSERTS.key, REWRITE_BATCHED_INSERTS);
    }

    protected String getValidationQuery() {
        return "select now()";
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        String host = (String)HOST.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        boolean reWriteBatchedInserts = Boolean.TRUE.equals(REWRITE_BATCHED_INSERTS.lookUp(params));
        String url = "jdbc:postgresql://" + host + ":" + port + "/" + db + "?reWriteBatchedInserts=" + reWriteBatchedInserts;
        SslMode mode = (SslMode)((Object)SSL_MODE.lookUp(params));
        if (mode != null) {
            url = url + "&sslmode=" + String.valueOf((Object)mode) + "&binaryTransferEnable=bytea";
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource(Map<String, ?> params, SQLDialect dialect) throws IOException {
        DataSource ds;
        block21: {
            ds = super.createDataSource(params, dialect);
            JDBCDataStore store = new JDBCDataStore();
            if (!Boolean.TRUE.equals(CREATE_DB_IF_MISSING.lookUp(params))) break block21;
            Connection cx = null;
            boolean canConnect = true;
            try {
                cx = ds.getConnection();
            }
            catch (SQLException e) {
                canConnect = false;
            }
            finally {
                store.closeSafe(cx);
            }
            if (canConnect) break block21;
            String host = (String)HOST.lookUp(params);
            int port = (Integer)PORT.lookUp(params);
            String db = (String)DATABASE.lookUp(params);
            String user = (String)USER.lookUp(params);
            String password = (String)PASSWD.lookUp(params);
            Statement st = null;
            try {
                String url = "jdbc:postgresql://" + host + ":" + port + "/template1";
                cx = this.getConnection(user, password, url);
                String createParams = (String)CREATE_PARAMS.lookUp(params);
                String sql = "CREATE DATABASE \"" + db + "\" " + (createParams == null ? "" : createParams);
                st = cx.createStatement();
                st.execute(sql);
            }
            catch (SQLException e) {
                try {
                    throw new IOException("Failed to create the target database", e);
                }
                catch (Throwable throwable) {
                    store.closeSafe(st);
                    store.closeSafe(cx);
                    throw throwable;
                }
            }
            store.closeSafe(st);
            store.closeSafe(cx);
            ResultSet rs = null;
            try {
                String url = "jdbc:postgresql://" + host + ":" + port + "/" + db;
                cx = DriverManager.getConnection(url, user, password);
                st = cx.createStatement();
                try {
                    rs = st.executeQuery("select PostGIS_version()");
                }
                catch (SQLException e) {
                    st.execute("create extension postgis");
                }
                finally {
                    store.closeSafe(rs);
                }
            }
            catch (SQLException e) {
                throw new IOException("Failed to create the target database", e);
            }
            finally {
                store.closeSafe(st);
                store.closeSafe(cx);
            }
            ds = super.createDataSource(params, dialect);
        }
        return ds;
    }

    private Connection getConnection(String user, String password, String url) throws SQLException {
        Connection cx = user != null ? DriverManager.getConnection(url, user, password) : DriverManager.getConnection(url);
        return cx;
    }

    public void dropDatabase(Map<String, Object> params) throws IOException {
        JDBCDataStore store = new JDBCDataStore();
        String host = (String)HOST.lookUp(params);
        int port = (Integer)PORT.lookUp(params);
        String db = (String)DATABASE.lookUp(params);
        String user = (String)USER.lookUp(params);
        String password = (String)PASSWD.lookUp(params);
        Connection cx = null;
        Statement st = null;
        try {
            String url = "jdbc:postgresql://" + host + ":" + port + "/template1";
            cx = this.getConnection(user, password, url);
            String sql = "DROP DATABASE \"" + db + "\"";
            st = cx.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            try {
                throw new IOException("Failed to drop the target database", e);
            }
            catch (Throwable throwable) {
                store.closeSafe(st);
                store.closeSafe(cx);
                throw throwable;
            }
        }
        store.closeSafe(st);
        store.closeSafe(cx);
    }
}

