/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class MultiSurfaceTypeBinding
extends AbstractComplexBinding {
    protected GeometryFactory gf;
    protected CoordinateSequenceFactory cs;
    protected ArcParameters arcParameters;

    public MultiSurfaceTypeBinding(GeometryFactory gFactory) {
        this.gf = gFactory;
    }

    public MultiSurfaceTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory, ArcParameters arcParameters) {
        this(gFactory);
        this.cs = csFactory;
        this.arcParameters = arcParameters;
    }

    public QName getTarget() {
        return GML.MultiSurfaceType;
    }

    public Class getType() {
        return MultiSurface.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List surfaces = node.getChildValues(Polygon.class);
        if (node.hasChild(Polygon[].class)) {
            surfaces.addAll(Arrays.asList((Polygon[])node.getChildValue(Polygon[].class)));
        }
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gf, null);
        return factory.createMultiSurface(surfaces);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("surfaceMember".equals(name.getLocalPart())) {
            if (object instanceof MultiPolygon) {
                MultiPolygon multiSurface = (MultiPolygon)object;
                Polygon[] members = new Polygon[multiSurface.getNumGeometries()];
                for (int i = 0; i < members.length; ++i) {
                    members[i] = (Polygon)multiSurface.getGeometryN(i);
                }
                GML3EncodingUtils.setChildIDs((Geometry)multiSurface);
                return members;
            }
            return object;
        }
        return null;
    }
}

