/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.GetMapRequest;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.map.Layer;

public abstract class AbstractGeoSearchDecorator
implements KmlDecoratorFactory.KmlDecorator {
    protected String getFeatureTypeURL(KmlEncodingContext context) throws IOException {
        GeoServer gs = context.getWms().getGeoServer();
        Catalog catalog = gs.getCatalog();
        Layer layer = context.getCurrentLayer();
        FeatureSource featureSource = layer.getFeatureSource();
        Name typeName = featureSource.getSchema().getName();
        String nsUri = typeName.getNamespaceURI();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        String featureTypeName = typeName.getLocalPart();
        GetMapRequest request = context.getRequest();
        String baseURL = request.getBaseUrl();
        String prefix = ns.getPrefix();
        return ResponseUtils.buildURL((String)baseURL, (String)ResponseUtils.appendPath((String[])new String[]{"rest", prefix, featureTypeName}), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }
}

