/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.iterator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import java.util.Iterator;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.IteratorFactory;
import org.geoserver.kml.utils.KMLFeatureAccessor;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;

public abstract class AbstractFolderIteratorFactory
implements IteratorFactory<Feature> {
    protected KmlEncodingContext context;
    protected List<KmlDecoratorFactory.KmlDecorator> decorators;

    public AbstractFolderIteratorFactory(KmlEncodingContext context) {
        this.context = context;
        this.decorators = context.getDecoratorsForClass(Folder.class);
    }

    public abstract class AbstractFolderGenerator
    implements Iterator<Feature> {
        Iterator layerIterator;

        public AbstractFolderGenerator() {
            this.layerIterator = AbstractFolderIteratorFactory.this.context.getMapContent().layers().iterator();
        }

        @Override
        public Feature next() {
            if (this.hasNext()) {
                Layer layer = (Layer)this.layerIterator.next();
                AbstractFolderIteratorFactory.this.context.setCurrentLayer(layer);
                Folder folder = new Folder();
                int index = AbstractFolderIteratorFactory.this.context.getMapContent().layers().indexOf(layer);
                MapLayerInfo layerInfo = (MapLayerInfo)AbstractFolderIteratorFactory.this.context.getMapContent().getRequest().getLayers().get(index);
                folder.setName(layerInfo.getLabel());
                if (layerInfo.getDescription() != null && !layerInfo.getDescription().isEmpty()) {
                    folder.setDescription(layerInfo.getDescription());
                }
                if (layer instanceof FeatureLayer) {
                    try {
                        WMSMapContent mapContent = AbstractFolderIteratorFactory.this.context.getMapContent();
                        SimpleFeatureCollection fc = new KMLFeatureAccessor().loadFeatureCollection(layer, mapContent, AbstractFolderIteratorFactory.this.context.getWms(), mapContent.getScaleDenominator());
                        AbstractFolderIteratorFactory.this.context.setCurrentFeatureCollection(fc);
                    }
                    catch (Exception e) {
                        if (e instanceof ServiceException) {
                            ServiceException exception1 = (ServiceException)((Object)e);
                            throw exception1;
                        }
                        if (e instanceof HttpErrorCodeException) {
                            HttpErrorCodeException exception = (HttpErrorCodeException)((Object)e);
                            throw exception;
                        }
                        throw new ServiceException("Failed to load vector data during KML generation", (Throwable)e);
                    }
                }
                for (KmlDecoratorFactory.KmlDecorator decorator : AbstractFolderIteratorFactory.this.decorators) {
                    folder = (Folder)decorator.decorate((Feature)folder, AbstractFolderIteratorFactory.this.context);
                    if (folder != null) continue;
                }
                this.encodeFolderContents(layer, folder);
                return folder;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.layerIterator.hasNext();
        }

        protected abstract void encodeFolderContents(Layer var1, Folder var2);
    }
}

