/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.regionate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.regionate.CachedHierarchyRegionatingStrategy;
import org.geoserver.kml.regionate.Tile;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ExternalSortRegionatingStrategy
extends CachedHierarchyRegionatingStrategy {
    static final SimpleFeatureType IDX_FEATURE_TYPE;
    static Map<Class<?>, String> CLASS_MAPPINGS;
    String attribute;
    FeatureSource fs;
    String hsqlType;

    public ExternalSortRegionatingStrategy(GeoServer gs) {
        super(gs);
    }

    @Override
    protected final String getDatabaseName(WMSMapContent con, Layer layer) throws Exception {
        this.fs = layer.getFeatureSource();
        SimpleFeatureType ft = (SimpleFeatureType)this.fs.getSchema();
        this.checkAttribute(con, ft);
        return super.getDatabaseName(con, layer) + "_" + this.attribute;
    }

    @Override
    protected final String getDatabaseName(FeatureTypeInfo cfg) throws Exception {
        return super.getDatabaseName(cfg) + "_" + this.checkAttribute(cfg);
    }

    protected void checkAttribute(WMSMapContent con, SimpleFeatureType ft) {
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = this.checkAttribute(this.featureType);
        }
        if (this.attribute == null) {
            throw new ServiceException("Regionating attribute has not been specified");
        }
        AttributeDescriptor ad = ft.getDescriptor(this.attribute);
        if (ad == null) {
            throw new ServiceException("Could not find regionating attribute " + this.attribute + " in layer " + this.featureType.getName());
        }
        this.hsqlType = this.getHSQLDataType(ad);
        if (this.hsqlType == null) {
            throw new ServiceException("Attribute type " + String.valueOf(ad.getType()) + " is not supported for external sorting on " + this.featureType.getName() + "#" + this.attribute);
        }
    }

    protected String checkAttribute(FeatureTypeInfo cfg) {
        return MapLayerInfo.getRegionateAttribute((FeatureTypeInfo)cfg);
    }

    @Override
    public FeatureIterator getSortedFeatures(GeometryDescriptor geom, ReferencedEnvelope latLongEnvelope, ReferencedEnvelope nativeEnvelope, Connection cacheConn) throws Exception {
        try (Statement st = cacheConn.createStatement();){
            try {
                st.executeQuery("SELECT * FROM FEATUREIDX LIMIT 1");
            }
            catch (SQLException e) {
                this.buildIndex(cacheConn);
            }
        }
        return new IndexFeatureIterator(cacheConn, latLongEnvelope);
    }

    protected String getHSQLDataType(AttributeDescriptor ad) {
        if (String.class.equals((Object)ad.getType().getBinding())) {
            int length = FeatureTypes.getFieldLength((PropertyDescriptor)ad);
            if (length <= 0) {
                length = 255;
            }
            return "VARCHAR(" + length + ")";
        }
        return CLASS_MAPPINGS.get(ad.getType().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildIndex(Connection conn) throws Exception {
        try (Statement st = conn.createStatement();){
            st.execute("CREATE CACHED TABLE FEATUREIDX(X DOUBLE, Y DOUBLE, FID VARCHAR(64), ORDER_FIELD " + this.hsqlType + ")");
            st.execute("CREATE INDEX FEATUREIDX_COORDS ON FEATUREIDX(X, Y)");
            st.execute("CREATE INDEX FEATUREIDX_ORDER_FIELD ON FEATUREIDX(ORDER_FIELD)");
        }
        try (PreparedStatement ps = conn.prepareStatement("INSERT INTO FEATUREIDX(X, Y, FID, ORDER_FIELD) VALUES (?, ?, ?, ?)");){
            GeometryDescriptor geom = this.fs.getSchema().getGeometryDescriptor();
            CoordinateReferenceSystem nativeCrs = geom.getCoordinateReferenceSystem();
            Query q = new Query();
            if (geom.getLocalName().equals(this.attribute)) {
                q.setPropertyNames(new String[]{geom.getLocalName()});
            } else {
                q.setPropertyNames(new String[]{this.attribute, geom.getLocalName()});
            }
            MathTransform tx = null;
            double[] coords = new double[2];
            if (!CRS.equalsIgnoreMetadata((Object)nativeCrs, (Object)Tile.WGS84)) {
                tx = CRS.findMathTransform((CoordinateReferenceSystem)nativeCrs, (CoordinateReferenceSystem)Tile.WGS84, (boolean)true);
            }
            conn.setAutoCommit(false);
            try (FeatureIterator fi = this.fs.getFeatures(q).features();){
                while (fi.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fi.next();
                    Geometry g = (Geometry)f.getDefaultGeometry();
                    if (g.isEmpty()) continue;
                    Point centroid = g.getCentroid();
                    if (Double.isNaN(centroid.getX()) || Double.isNaN(centroid.getY())) {
                        LOGGER.warning("Could not calculate centroid for feature " + f.getID() + "; g =  " + g.toText());
                        continue;
                    }
                    coords[0] = centroid.getX();
                    coords[1] = centroid.getY();
                    if (tx != null) {
                        tx.transform(coords, 0, coords, 0, 1);
                    }
                    ps.setDouble(1, coords[0]);
                    ps.setDouble(2, coords[1]);
                    ps.setString(3, f.getID());
                    ps.setObject(4, this.getSortAttributeValue(f));
                    ps.execute();
                }
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    protected Object getSortAttributeValue(SimpleFeature f) {
        return f.getAttribute(this.attribute);
    }

    static {
        CLASS_MAPPINGS = new LinkedHashMap();
        CLASS_MAPPINGS.put(Boolean.class, "BOOLEAN");
        CLASS_MAPPINGS.put(Byte.class, "TINYINT");
        CLASS_MAPPINGS.put(Short.class, "SMALLINT");
        CLASS_MAPPINGS.put(Character.class, "CHAR");
        CLASS_MAPPINGS.put(Integer.class, "INT");
        CLASS_MAPPINGS.put(Long.class, "BIGINT");
        CLASS_MAPPINGS.put(BigInteger.class, "BIGINT");
        CLASS_MAPPINGS.put(BigDecimal.class, "DECIMAL");
        CLASS_MAPPINGS.put(Float.class, "REAL");
        CLASS_MAPPINGS.put(Double.class, "DOUBLE");
        CLASS_MAPPINGS.put(java.util.Date.class, "DATE");
        CLASS_MAPPINGS.put(Date.class, "DATE");
        CLASS_MAPPINGS.put(Time.class, "TIME");
        CLASS_MAPPINGS.put(Timestamp.class, "TIMESTAMP");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.crs(Tile.WGS84);
        tb.add("point", Point.class);
        tb.setName("FeatureCentroids");
        IDX_FEATURE_TYPE = tb.buildFeatureType();
    }

    public static class IndexFeatureIterator
    implements FeatureIterator {
        SimpleFeatureBuilder builder;
        GeometryFactory gf;
        Statement st;
        ResultSet rs;
        boolean nextCalled;
        boolean next;

        public IndexFeatureIterator(Connection cacheConn, ReferencedEnvelope envelope) throws Exception {
            try {
                this.st = cacheConn.createStatement();
                String sql = "SELECT X, Y, FID \nFROM FEATUREIDX\nWHERE X > " + Math.nextDown(envelope.getMinX()) + "\nAND X < " + Math.nextUp(envelope.getMaxX()) + "\nAND Y > " + Math.nextDown(envelope.getMinY()) + "\nAND Y < " + Math.nextUp(envelope.getMaxY()) + "\nORDER BY ORDER_FIELD DESC";
                this.rs = this.st.executeQuery(sql);
            }
            catch (SQLException e) {
                this.close();
            }
            this.builder = new SimpleFeatureBuilder(IDX_FEATURE_TYPE);
            this.gf = new GeometryFactory();
        }

        public void close() {
            JDBCUtils.close((ResultSet)this.rs);
            JDBCUtils.close((Statement)this.st);
        }

        public boolean hasNext() {
            if (!this.nextCalled) {
                try {
                    this.next = this.rs.next();
                    this.nextCalled = true;
                }
                catch (SQLException e) {
                    this.close();
                    throw new RuntimeException("Error while accessing next db record", e);
                }
            }
            return this.next;
        }

        public Feature next() throws NoSuchElementException {
            if (!this.nextCalled) {
                this.hasNext();
            }
            this.nextCalled = false;
            try {
                double x = this.rs.getDouble(1);
                double y = this.rs.getDouble(2);
                this.builder.add((Object)this.gf.createPoint(new Coordinate(x, y)));
                return this.builder.buildFeature(this.rs.getString(3));
            }
            catch (SQLException e) {
                this.close();
                throw new RuntimeException("Problems reading the geometry index");
            }
        }
    }
}

