/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.kml.utils.KmlCentroidOptions;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LengthIndexedLine;

public class KmlCentroidBuilder {
    static Logger LOG = Logging.getLogger(KmlCentroidBuilder.class);

    public Coordinate geometryCentroid(Geometry g) {
        return this.geometryCentroid(g, null, null);
    }

    public Coordinate geometryCentroid(Geometry g, Envelope bbox, KmlCentroidOptions opts) {
        if (opts == null) {
            opts = KmlCentroidOptions.DEFAULT;
        }
        if (opts.isClip()) {
            if (bbox != null) {
                g = this.clipGeometry(g, bbox);
            } else {
                LOG.warning("Clip option specified for kml centroids, but no bbox available");
            }
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)g;
            g = this.selectRepresentativeGeometry(collection);
        }
        if (g == null) {
            return null;
        }
        if (g instanceof Point) {
            return g.getCoordinate();
        }
        if (g instanceof LineString) {
            LineString line = (LineString)g;
            LengthIndexedLine lil = new LengthIndexedLine((Geometry)line);
            return lil.extractPoint(line.getLength() / 2.0);
        }
        if (g instanceof Polygon) {
            Polygon polygon = (Polygon)g;
            if (opts.isContain()) {
                try {
                    Point p = RendererUtilities.sampleForInternalPoint((Polygon)polygon, null, null, null, (double)-1.0, (int)opts.getSamples());
                    if (p != null && !p.isEmpty()) {
                        return p.getCoordinate();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to calculate central point for polygon", e);
                }
            }
        }
        return g.getCentroid().getCoordinate();
    }

    private Geometry selectRepresentativeGeometry(GeometryCollection g) {
        GeometryCollection gc = g;
        if (gc.isEmpty()) {
            return null;
        }
        Geometry first = gc.getGeometryN(0);
        if (gc.getNumGeometries() == 1 || g instanceof MultiPoint) {
            return first;
        }
        double maxAreaSoFar = first.getEnvelope().getArea();
        Geometry geometryToReturn = first;
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry curr = gc.getGeometryN(t);
            double area = curr.getEnvelope().getArea();
            if (!(area > maxAreaSoFar)) continue;
            maxAreaSoFar = area;
            geometryToReturn = curr;
        }
        return geometryToReturn;
    }

    private Geometry clipGeometry(Geometry g, Envelope bbox) {
        return new GeometryClipper(bbox).clipSafe(g, true, 0.0);
    }
}

