/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wfs.kvp.BBoxKvpParser;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class LookAtOptions {
    private static final Logger LOGGER = Logging.getLogger(LookAtOptions.class);
    private static final GeometryFactory gfac = new GeometryFactory();
    private static final String KEY_BBOX = "LOOKATBBOX";
    private static final String KEY_LOOKAT = "LOOKATGEOM";
    private static final String KEY_ALTITUDE = "ALTITUDE";
    private static final String KEY_HEADING = "HEADING";
    private static final String KEY_TILT = "TILT";
    private static final String KEY_RANGE = "RANGE";
    private static final String KEY_ALTITUDEMODE = "ALTITUDEMODE";
    private Geometry lookAt;
    private Double altitude;
    private Double heading;
    private Double tilt;
    private Double range;
    private AltitudeMode altitudeMode;

    public LookAtOptions() {
        this(Collections.emptyMap());
    }

    public LookAtOptions(Map<String, Object> options) {
        this.lookAt = this.parseLookAtBBOX(options.get(KEY_BBOX));
        if (this.lookAt == null) {
            this.lookAt = this.parseLookAt(options.get(KEY_LOOKAT));
        }
        this.altitude = this.parseDouble(options.get(KEY_ALTITUDE));
        this.heading = this.parseDouble(options.get(KEY_HEADING));
        this.tilt = this.parseDouble(options.get(KEY_TILT));
        this.range = this.parseDouble(options.get(KEY_RANGE));
        this.altitudeMode = this.parseAltitudeMode(options.get(KEY_ALTITUDEMODE));
    }

    private Geometry parseLookAtBBOX(Object object) {
        Polygon bbox = null;
        if (null != object) {
            try {
                BBoxKvpParser parser = new BBoxKvpParser();
                Envelope env = (Envelope)parser.parse(String.valueOf(object));
                bbox = JTS.toGeometry((Envelope)env);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
        }
        return bbox;
    }

    private Geometry parseLookAt(Object object) {
        Geometry geom;
        block3: {
            geom = null;
            if (object != null) {
                String geomWKT = String.valueOf(object);
                try {
                    WKTReader2 reader = new WKTReader2(gfac);
                    geom = reader.read(geomWKT);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block3;
                    LOGGER.info("Error parsing LOOKATGEOM KML format option: " + e.getMessage() + ". Argument WKT: '" + geomWKT + "'");
                }
            }
        }
        return geom;
    }

    private Double parseDouble(Object object) {
        Double parsed;
        block3: {
            parsed = null;
            if (object != null) {
                try {
                    parsed = Double.valueOf(String.valueOf(object));
                }
                catch (NumberFormatException ignored) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.fine("Not a number in KML format options: '" + String.valueOf(object) + "'");
                }
            }
        }
        return parsed;
    }

    private AltitudeMode parseAltitudeMode(Object object) {
        AltitudeMode mode;
        block3: {
            mode = AltitudeMode.CLAMP_TO_GROUND;
            if (object != null) {
                try {
                    mode = AltitudeMode.fromValue((String)String.valueOf(object));
                }
                catch (IllegalArgumentException ignore) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block3;
                    LOGGER.info("Illegal value for KML format option 'altitudeMode': '" + String.valueOf(object) + "'. Expected one of " + Arrays.toString(AltitudeMode.values()));
                }
            }
        }
        return mode;
    }

    public Geometry getLookAt() {
        return this.lookAt;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Double getHeading() {
        return this.heading;
    }

    public Double getTilt() {
        return this.tilt;
    }

    public Double getRange() {
        return this.range;
    }

    public AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }
}

