/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.stats.StatsFactory;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.util.ProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.JenksNaturalBreaksFunction;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.process.ProcessException;
import org.geotools.process.classify.ClassificationMethod;
import org.geotools.process.classify.ClassificationStats;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

@DescribeProcess(title="featureClassStats", description="Calculates statistics from feature values classified into bins/classes.")
public class FeatureClassStats
implements VectorProcess {
    static Logger LOG = Logging.getLogger(FeatureClassStats.class);
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();

    @DescribeResult(name="results", description="The classified results")
    public Results execute(@DescribeParameter(name="features", description="The feature collection to analyze") FeatureCollection features, @DescribeParameter(name="attribute", description="The feature attribute to analyze") String attribute, @DescribeParameter(name="stats", description="The statistics to calculate for each class", collectionType=Statistics.StatsType.class) List<Statistics.StatsType> statTypes, @DescribeParameter(name="classes", description="The number of breaks/classes", min=0) Integer classes, @DescribeParameter(name="method", description="The classification method", min=0) ClassificationMethod method, @DescribeParameter(name="noData", description="The attribute value to be omitted from any calculation", min=0) Double noData, ProgressListener progressListener) throws ProcessException, IOException {
        if (features == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "features"));
        }
        if (attribute == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "attribute"));
        }
        PropertyDescriptor property = features.getSchema().getDescriptor(attribute);
        if (property == null) {
            throw new ProcessException("No such feature attribute '" + attribute + "'");
        }
        if (!Number.class.isAssignableFrom(property.getType().getBinding())) {
            throw new ProcessException("Feature attribute '" + attribute + "' is not numeric");
        }
        if (classes == null) {
            classes = 10;
        }
        if (classes < 1) {
            throw new ProcessException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "classes", classes));
        }
        if (method == null) {
            method = ClassificationMethod.EQUAL_INTERVAL;
        }
        if (statTypes == null || statTypes.isEmpty()) {
            statTypes = Collections.singletonList(Statistics.StatsType.MEAN);
        }
        ClassificationFunction cf = null;
        switch (method) {
            case EQUAL_INTERVAL: {
                cf = new EqualIntervalFunction();
                break;
            }
            case QUANTILE: {
                cf = new QuantileFunction();
                break;
            }
            case NATURAL_BREAKS: {
                cf = new JenksNaturalBreaksFunction();
                break;
            }
            default: {
                throw new ProcessException("Unknown method: " + String.valueOf((Object)method));
            }
        }
        cf.setParameters(Arrays.asList(filterFactory.property(attribute), filterFactory.literal((Object)classes)));
        RangedClassifier rc = (RangedClassifier)cf.evaluate(features);
        ArrayList<Range> ranges = new ArrayList<Range>();
        RangeStatistics[] sampleStats = new RangeStatistics[rc.getSize()];
        for (int i = 0; i < rc.getSize(); ++i) {
            ranges.add((Range)RangeFactory.create((double)((Double)rc.getMin(i)), (boolean)true, (double)((Double)rc.getMax(i)), (i == rc.getSize() - 1 ? 1 : 0) != 0));
            RangeStatistics rangeStatistics = new RangeStatistics(statTypes);
            if (noData != null) {
                rangeStatistics.setNodata(noData);
            }
            sampleStats[i] = rangeStatistics;
        }
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                Object f = it.next();
                Object val = f.getProperty(attribute).getValue();
                if (val == null) continue;
                Double dubVal = (Double)Converters.convert((Object)val, Double.class);
                if (dubVal == null) {
                    LOG.warning(String.format("Unable to convert value %s (attribute '%s') to Double, skipping", val, attribute));
                    continue;
                }
                int slot = rc.classify((Object)dubVal);
                sampleStats[slot].addSample(dubVal);
            }
        }
        return new Results(ranges, statTypes, sampleStats);
    }

    private static class RangeStatistics {
        private final List<Statistics> stats;
        private final List<Statistics.StatsType> statTypes;
        private Double noData;

        public RangeStatistics(List<Statistics.StatsType> statTypes) {
            this.statTypes = statTypes;
            this.stats = statTypes.stream().map(t -> StatsFactory.createSimpleStatisticsObjectFromInt((int)t.getStatsId())).collect(Collectors.toList());
        }

        public List<Statistics> getStats() {
            return this.stats;
        }

        public void addSample(double value) {
            if (Double.isNaN(value) || this.noData != null && this.noData.equals(value)) {
                return;
            }
            for (Statistics stat : this.stats) {
                stat.addSample(value);
            }
        }

        public void setNodata(Double noData) {
            this.noData = noData;
        }

        public Long getNumAccepted() {
            return this.stats.get(0).getNumSamples();
        }

        public Double getStatisticValue(Statistics.StatsType stat) {
            int idx = this.statTypes.indexOf(stat);
            if (idx < 0 || idx >= this.stats.size()) {
                throw new IllegalArgumentException("Unknown statistic: " + String.valueOf(stat));
            }
            Statistics statistics = this.stats.get(idx);
            return ((Number)statistics.getResult()).doubleValue();
        }
    }

    public static class Results
    implements ClassificationStats {
        private final List<Statistics.StatsType> statsTypes;
        List<Range> ranges;
        RangeStatistics[] sampleStats;

        public Results(List<Range> ranges, List<Statistics.StatsType> statsTypes, RangeStatistics[] sampleStats) {
            this.ranges = ranges;
            this.sampleStats = sampleStats;
            this.statsTypes = statsTypes;
        }

        @Override
        public int size() {
            return this.ranges.size();
        }

        @Override
        public Set<Statistics.StatsType> getStats() {
            return new LinkedHashSet<Statistics.StatsType>(this.statsTypes);
        }

        @Override
        public Range range(int i) {
            return this.ranges.get(i);
        }

        @Override
        public Double value(int i, Statistics.StatsType stat) {
            return this.sampleStats[i].getStatisticValue(stat);
        }

        @Override
        public Long count(int i) {
            return this.sampleStats[i].getNumAccepted();
        }

        public void print() {
            for (int i = 0; i < this.size(); ++i) {
                LOG.info(String.valueOf(this.range(i)));
                for (Statistics.StatsType type : this.statsTypes) {
                    LOG.info(String.valueOf(type) + " = " + this.value(i, type));
                }
            }
        }
    }
}

