/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.util.Collection;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.metadata.extent.GeographicExtent;
import org.geotools.api.metadata.extent.TemporalExtent;
import org.geotools.api.metadata.extent.VerticalExtent;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;

public class ExtentImpl
extends MetadataEntity
implements Extent {
    private static final long serialVersionUID = 7812213837337326257L;
    public static final Extent WORLD;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<TemporalExtent> temporalElements;
    private Collection<VerticalExtent> verticalElements;

    public ExtentImpl() {
    }

    public ExtentImpl(Extent source) {
        super(source);
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public void setGeographicElements(Collection<? extends GeographicExtent> newValues) {
        this.geographicElements = this.copyCollection(newValues, this.geographicElements, GeographicExtent.class);
    }

    public Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public void setTemporalElements(Collection<? extends TemporalExtent> newValues) {
        this.temporalElements = this.copyCollection(newValues, this.temporalElements, TemporalExtent.class);
    }

    public Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public void setVerticalElements(Collection<? extends VerticalExtent> newValues) {
        this.verticalElements = this.copyCollection(newValues, this.verticalElements, VerticalExtent.class);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        Object candidate = null;
        if (extent != null) {
            ModifiableMetadata modifiable = null;
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                GeographicBoundingBox box;
                if (!(geographicExtent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox bounds = box = (GeographicBoundingBox)geographicExtent;
                if (candidate == null) {
                    Boolean inclusion = bounds.getInclusion();
                    ExtentImpl.ensureNonNull("inclusion", inclusion);
                    if (!inclusion.booleanValue()) continue;
                    candidate = bounds;
                    continue;
                }
                if (modifiable == null) {
                    modifiable = new GeographicBoundingBoxImpl((GeographicBoundingBox)candidate);
                    candidate = modifiable;
                }
                ((GeographicBoundingBoxImpl)modifiable).add(bounds);
            }
            if (modifiable != null) {
                modifiable.freeze();
            }
        }
        return candidate;
    }

    static {
        ExtentImpl world = new ExtentImpl();
        world.getGeographicElements().add(GeographicBoundingBoxImpl.WORLD);
        world.freeze();
        WORLD = world;
    }
}

