/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.math;

import java.io.Serializable;
import org.geotools.api.util.Cloneable;

public final class Complex
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8143196508298758583L;
    public double real;
    public double imag;

    public Complex() {
    }

    public Complex(Complex c) {
        this.real = c.real;
        this.imag = c.imag;
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public void copy(Complex c) {
        this.real = c.real;
        this.imag = c.imag;
    }

    public void multiply(Complex c, double s) {
        this.real = c.real * s;
        this.imag = c.imag * s;
    }

    public void multiply(Complex c1, Complex c2) {
        double x1 = c1.real;
        double y1 = c1.imag;
        double x2 = c2.real;
        double y2 = c2.imag;
        this.real = x1 * x2 - y1 * y2;
        this.imag = y1 * x2 + x1 * y2;
    }

    public void divide(Complex c1, Complex c2) {
        double x1 = c1.real;
        double y1 = c1.imag;
        double x2 = c2.real;
        double y2 = c2.imag;
        double denom = x2 * x2 + y2 * y2;
        this.real = (x1 * x2 + y1 * y2) / denom;
        this.imag = (y1 * x2 - x1 * y2) / denom;
    }

    public void add(Complex c1, Complex c2) {
        this.real = c1.real + c2.real;
        this.imag = c1.imag + c2.imag;
    }

    public void addMultiply(Complex c0, Complex c1, Complex c2) {
        double x1 = c1.real;
        double y1 = c1.imag;
        double x2 = c2.real;
        double y2 = c2.imag;
        this.real = c0.real + (x1 * x2 - y1 * y2);
        this.imag = c0.imag + (y1 * x2 + x1 * y2);
    }

    public void power(Complex c, int power) {
        double x = c.real;
        double y = c.imag;
        switch (power) {
            case 0: {
                this.real = 1.0;
                this.imag = 0.0;
                break;
            }
            case 1: {
                this.real = x;
                this.imag = y;
                break;
            }
            case 2: {
                this.real = x * x - y * y;
                this.imag = 2.0 * x * y;
                break;
            }
            case 3: {
                this.real = x * x * x - 3.0 * x * y * y;
                this.imag = 3.0 * x * x * y - y * y * y;
                break;
            }
            case 4: {
                this.real = x * x * x * x - 6.0 * x * x * y * y + y * y * y * y;
                this.imag = 4.0 * x * x * x * y - 4.0 * x * y * y * y;
                break;
            }
            case 5: {
                this.real = x * x * x * x * x - 10.0 * x * x * x * y * y + 5.0 * x * y * y * y * y;
                this.imag = 5.0 * x * x * x * x * y - 10.0 * x * x * y * y * y + y * y * y * y * y;
                break;
            }
            case 6: {
                this.real = x * x * x * x * x * x - 15.0 * x * x * x * x * y * y + 15.0 * x * x * y * y * y * y - y * y * y * y * y * y;
                this.imag = 6.0 * x * x * x * x * x * y - 20.0 * x * x * x * y * y * y + 6.0 * x * y * y * y * y * y;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(power));
            }
        }
    }

    @Override
    public Complex clone() {
        return new Complex(this);
    }

    public boolean equals(Complex c) {
        return Double.doubleToLongBits(this.real) == Double.doubleToLongBits(c.real) && Double.doubleToLongBits(this.imag) == Double.doubleToLongBits(c.imag);
    }

    public boolean equals(Object c) {
        Complex c1;
        return c instanceof Complex && this.equals(c1 = (Complex)c);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.real) + 37L * Double.doubleToLongBits(this.imag);
        return (int)code ^ (int)(code >>> 32);
    }

    public String toString() {
        return "Complex[" + this.real + ", " + this.imag + "]";
    }
}

