/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.geotools.util.DerivedSet;

public abstract class DerivedMap<BK, K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -6994867383669885934L;
    protected final Map<BK, V> base;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private final Class<K> keyType;

    public DerivedMap(Map<BK, V> base, Class<K> keyType) {
        this.base = base;
        this.keyType = keyType;
    }

    protected abstract K baseToDerived(BK var1);

    protected abstract BK derivedToBase(K var1);

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keyType.isInstance(key)) {
            return this.base.containsKey(this.derivedToBase(this.keyType.cast(key)));
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.keyType.isInstance(key)) {
            return this.base.get(this.derivedToBase(this.keyType.cast(key)));
        }
        return null;
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException {
        return this.base.put(this.derivedToBase(key), value);
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        if (this.keyType.isInstance(key)) {
            return this.base.remove(this.derivedToBase(this.keyType.cast(key)));
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this.base.keySet());
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.base.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.base.entrySet());
        }
        return this.entrySet;
    }

    private final class KeySet
    extends DerivedSet<BK, K> {
        private static final long serialVersionUID = -2931806200277420177L;

        public KeySet(Set<BK> base) {
            super(base, DerivedMap.this.keyType);
        }

        @Override
        protected K baseToDerived(BK element) {
            return DerivedMap.this.baseToDerived(element);
        }

        @Override
        protected BK derivedToBase(K element) {
            return DerivedMap.this.derivedToBase(element);
        }
    }

    private final class EntrySet
    extends DerivedSet<Map.Entry<BK, V>, Entry<BK, K, V>> {
        private static final long serialVersionUID = -2931806200277420177L;

        public EntrySet(Set<Map.Entry<BK, V>> base) {
            super(base, Entry.class);
        }

        @Override
        protected Entry<BK, K, V> baseToDerived(Map.Entry<BK, V> entry) {
            Object derived = DerivedMap.this.baseToDerived(entry.getKey());
            return derived != null ? new Entry(entry, derived) : null;
        }

        @Override
        protected Map.Entry<BK, V> derivedToBase(Entry<BK, K, V> element) {
            return element.entry;
        }
    }

    private static final class Entry<BK, K, V>
    implements Map.Entry<K, V> {
        public final Map.Entry<BK, V> entry;
        private final K derived;

        public Entry(Map.Entry<BK, V> entry, K derived) {
            this.entry = entry;
            this.derived = derived;
        }

        @Override
        public K getKey() {
            return this.derived;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }
    }
}

