/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.geotools.util.BufferSoftReference;
import org.geotools.util.logging.Logging;

public final class NIOUtilities {
    static Map<Integer, Queue<Object>> cache = new ConcurrentHashMap<Integer, Queue<Object>>();
    static int maxCacheSize = 0x200000;
    static AtomicInteger hardCacheSize = new AtomicInteger(0);
    static final byte[] ZEROES = new byte[4096];
    private static boolean warned = false;
    private static boolean directBuffersEnabled = true;

    public static boolean isDirectBuffersEnabled() {
        return directBuffersEnabled;
    }

    public static void setDirectBuffersEnabled(boolean directBuffersEnabled) {
        NIOUtilities.directBuffersEnabled = directBuffersEnabled;
    }

    private NIOUtilities() {
    }

    public static void setMaxCacheSize(int maxCacheSize) {
        NIOUtilities.maxCacheSize = maxCacheSize;
    }

    public static ByteBuffer allocate(int size) {
        Queue<Object> buffers = NIOUtilities.getBuffers(size);
        Object sr = null;
        while ((sr = buffers.poll()) != null) {
            ByteBuffer buffer = null;
            if (sr instanceof BufferSoftReference) {
                BufferSoftReference reference = (BufferSoftReference)sr;
                buffer = (ByteBuffer)reference.get();
            } else {
                buffer = (ByteBuffer)sr;
                hardCacheSize.addAndGet(-buffer.capacity());
            }
            if (buffer == null) continue;
            buffer.clear();
            return buffer;
        }
        if (directBuffersEnabled) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<Object> getBuffers(int size) {
        Queue<Object> result = cache.get(size);
        if (result == null) {
            Map<Integer, Queue<Object>> map = cache;
            synchronized (map) {
                result = cache.get(size);
                if (result == null) {
                    result = new ConcurrentLinkedQueue<Object>();
                    cache.put(size, result);
                }
            }
        }
        return result;
    }

    public static boolean clean(ByteBuffer buffer, boolean memoryMapped) {
        if (memoryMapped) {
            return NIOUtilities.clean(buffer);
        }
        if (NIOUtilities.returnToCache(buffer)) {
            return true;
        }
        return NIOUtilities.clean(buffer);
    }

    public static boolean clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return true;
        }
        return NIOUtilities.cleanupAfterJdk8(buffer);
    }

    private static boolean cleanupAfterJdk8(ByteBuffer buffer) {
        boolean success;
        block2: {
            success = false;
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                Method invokeCleanerMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleanerMethod.invoke(theUnsafe, buffer);
                success = true;
            }
            catch (Exception e) {
                if (!NIOUtilities.isLoggable()) break block2;
                NIOUtilities.log(e, buffer);
            }
        }
        return success;
    }

    public static boolean returnToCache(ByteBuffer buffer) {
        int size;
        int capacity = buffer.capacity();
        if (capacity != 100 && capacity != 13 && capacity != 16000 && (size = (int)Math.pow(2.0, Math.ceil(Math.log(capacity) / Math.log(2.0)))) != capacity) {
            return false;
        }
        buffer.clear();
        buffer.order(ByteOrder.BIG_ENDIAN);
        Queue<Object> buffers = cache.get(capacity);
        if (hardCacheSize.get() > maxCacheSize) {
            buffers.add(new BufferSoftReference(buffer));
        } else {
            hardCacheSize.addAndGet(capacity);
            buffers.add(buffer);
        }
        return true;
    }

    private static synchronized boolean isLoggable() {
        try {
            return !warned && (Boolean.getBoolean("org.geotools.io.debugBuffer") || System.getProperty("os.name").indexOf("Windows") >= 0);
        }
        catch (SecurityException exception) {
            return false;
        }
    }

    private static synchronized void log(Exception e, ByteBuffer buffer) {
        warned = true;
        String message = "Error attempting to close a mapped byte buffer : " + buffer.getClass().getName() + "\n JVM : " + System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        Logging.getLogger(NIOUtilities.class).log(Level.SEVERE, message, e);
    }

    static {
        String directBuffers = System.getProperty("geotools.nioutilities.direct", "true");
        directBuffersEnabled = "TRUE".equalsIgnoreCase(directBuffers);
    }
}

