/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class PreventLocalEntityResolver
implements EntityResolver2,
Serializable {
    private static final long serialVersionUID = -5689036455423814933L;
    public static final String ERROR_MESSAGE_BASE = "Entity resolution disallowed for ";
    protected static final Logger LOGGER = Logging.getLogger(PreventLocalEntityResolver.class);
    private static final Pattern ALLOWED_URIS = Pattern.compile("(?i)(jar:file|jar:nested|http|vfs)[^?#;]*\\.xsd");
    public static final PreventLocalEntityResolver INSTANCE = new PreventLocalEntityResolver();

    protected PreventLocalEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("resolveEntity request: name=%s, publicId=%s, baseURI=%s, systemId=%s".formatted(name, publicId, baseURI, systemId));
        }
        try {
            String uri = systemId;
            if (!URI.create(systemId).isAbsolute()) {
                uri = new URL(new URL(baseURI), systemId).toString();
            }
            if (ALLOWED_URIS.matcher(uri).matches()) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SAXException(ERROR_MESSAGE_BASE + systemId);
    }
}

