/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.decorate;

import java.io.Serializable;
import org.geotools.util.decorate.Wrapper;

public class AbstractDecorator<D>
implements Wrapper,
Serializable {
    protected D delegate;

    public AbstractDecorator(D delegate) {
        if (delegate == null) {
            throw new NullPointerException("Cannot delegate to a null object");
        }
        this.delegate = delegate;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        D d = this.delegate;
        if (d instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)d;
            return wrapper.isWrapperFor(iface);
        }
        return iface.isInstance(this.delegate);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws IllegalArgumentException {
        D d = this.delegate;
        if (d instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)d;
            return wrapper.unwrap(iface);
        }
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        throw new IllegalArgumentException("Cannot unwrap to the requested interface " + String.valueOf(iface));
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.delegate) + "]";
    }
}

